/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.httpsniffer;

import java.awt.Component;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.koiroha.httpsniffer.HttpProxy;

public class Sniffer
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<HttpProxy> proxy = new ArrayList<HttpProxy>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpProxy get(int n) {
        List<HttpProxy> list = this.proxy;
        synchronized (list) {
            return this.proxy.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(HttpProxy httpProxy) {
        List<HttpProxy> list = this.proxy;
        synchronized (list) {
            this.proxy.add(httpProxy);
            this.fireTableRowsInserted(this.proxy.size() - 1, this.proxy.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(HttpProxy httpProxy) {
        List<HttpProxy> list = this.proxy;
        synchronized (list) {
            int n = this.proxy.indexOf(httpProxy);
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
                HttpProxy.logger.finer("table row " + n + " updated");
            } else {
                HttpProxy.logger.warning("proxy not found in table");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int ... nArray) {
        List<HttpProxy> list = this.proxy;
        synchronized (list) {
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.proxy.remove(nArray[i]);
                this.fireTableRowsDeleted(nArray[i], nArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<HttpProxy> list = this.proxy;
        synchronized (list) {
            int n = this.proxy.size();
            this.proxy.clear();
            if (n > 0) {
                this.fireTableRowsDeleted(0, n - 1);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "\u65e5\u6642";
            }
            case 2: {
                return "\u30b5\u30fc\u30d0";
            }
            case 3: {
                return "\u30ea\u30af\u30a8\u30b9\u30c8";
            }
            case 4: {
                return "\u30ec\u30b9\u30dd\u30f3\u30b9";
            }
            case 5: {
                return "Content-Type";
            }
            case 6: {
                return "\u8ee2\u9001\u30b5\u30a4\u30ba";
            }
        }
        assert (false);
        return null;
    }

    @Override
    public int getRowCount() {
        return this.proxy.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        HttpProxy httpProxy = this.proxy.get(n);
        switch (n2) {
            case 0: {
                return httpProxy.getState();
            }
            case 1: {
                return httpProxy.getDate();
            }
            case 2: {
                if (httpProxy.getServerName() == null) {
                    return null;
                }
                return httpProxy.getServerName() + ":" + httpProxy.getServerPort();
            }
            case 3: {
                if (httpProxy.getRequest() == null || httpProxy.getRequest().getUrl() == null) {
                    return null;
                }
                return httpProxy.getRequest().getMethod() + " " + httpProxy.getRequest().getUrl().getFile();
            }
            case 4: {
                if (httpProxy.getResponse() == null || httpProxy.getResponse().getCode() == 0) {
                    return null;
                }
                return httpProxy.getResponse().getCode() + " " + httpProxy.getResponse().getPhrase();
            }
            case 5: {
                if (httpProxy.getResponse() == null || httpProxy.getResponse().getHeader() == null) {
                    return null;
                }
                return httpProxy.getResponse().getHeader().getValue("Content-Type");
            }
            case 6: {
                if (httpProxy.getResponse() == null) {
                    return null;
                }
                return httpProxy.getResponse().getTransferContentSize();
            }
        }
        assert (false);
        return null;
    }

    public static class Renderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Number) {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                object = numberFormat.format(((Number)object).longValue());
                this.setHorizontalAlignment(4);
            } else if (object instanceof Date) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy/MM/dd HH:mm:ss.SSS");
                object = simpleDateFormat.format((Date)object);
                this.setHorizontalAlignment(4);
            } else if (object instanceof HttpProxy.State) {
                switch ((HttpProxy.State)((Object)object)) {
                    case DISCONNECTED: {
                        object = "";
                        break;
                    }
                    case REQUEST: {
                        object = "\u2192";
                        break;
                    }
                    case RESPONSE: {
                        object = "\u2190";
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.setHorizontalAlignment(2);
            } else {
                this.setHorizontalAlignment(2);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

