/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.httpsniffer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.koiroha.httpsniffer.HttpProxy;

public abstract class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = HttpProxy.logger;
    private String version = null;
    private Header header = null;
    private ByteArrayOutputStream content = null;

    protected Message() {
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        assert (string != null);
        this.version = string;
    }

    public abstract String getStatus();

    public void createHeader(String string) {
        assert (this.header == null);
        this.header = new Header(string);
    }

    public Header getHeader() {
        return this.header;
    }

    public long getTransferContentSize() {
        if (this.content == null) {
            return 0L;
        }
        return this.content.size();
    }

    public byte[] getContent() throws IOException {
        int n;
        if (this.content == null || this.getHeader() == null) {
            return this.getRawContent();
        }
        if (this.getTransferContentSize() == 0L) {
            return this.getRawContent();
        }
        InputStream inputStream = this.getRawInputStream();
        String string = this.getHeader().getValue("Content-Encoding");
        if (string != null && (string.equalsIgnoreCase("gzip") || string.equalsIgnoreCase("x-gzip"))) {
            inputStream = new GZIPInputStream(inputStream);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getRawContent() throws IOException {
        if (this.content == null) {
            return null;
        }
        return this.content.toByteArray();
    }

    public InputStream getRawInputStream() throws IOException {
        if (this.content == null) {
            return null;
        }
        return new ByteArrayInputStream(this.content.toByteArray());
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.content == null) {
            this.content = new ByteArrayOutputStream();
        }
        this.content.write(byArray, n, n2);
    }

    public void readFrom(InputStream inputStream, long l) throws IOException {
        byte[] byArray = new byte[1024];
        while (l != 0L) {
            int n = l < 0L ? byArray.length : (int)Math.min((long)byArray.length, l);
            if ((n = inputStream.read(byArray, 0, n)) < 0) break;
            this.write(byArray, 0, n);
            if (l <= 0L) continue;
            l -= (long)n;
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.content != null) {
            this.content.writeTo(outputStream);
        }
    }

    public static class Header
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String[]> headers = new ArrayList<String[]>();

        private Header(String string) {
            int n;
            String[] stringArray = string.split("\n");
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            for (n = 1; n < arrayList.size(); ++n) {
                if (!Character.isWhitespace(((String)arrayList.get(n)).charAt(0))) continue;
                arrayList.set(n - 1, (String)arrayList.get(n - 1) + "\n" + (String)arrayList.get(n));
                arrayList.remove(n);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                String string2 = (String)arrayList.get(n);
                int n2 = string2.indexOf(58);
                if (n2 < 0) {
                    logger.warning(string2);
                    continue;
                }
                this.headers.add(new String[]{string2.substring(0, n2).trim(), string2.substring(n2 + 1).trim()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getValue(String string) {
            List<String[]> list = this.headers;
            synchronized (list) {
                int n = this.getIndex(string);
                if (n < 0) {
                    return null;
                }
                return this.headers.get(n)[1];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceValue(String string, String string2) {
            List<String[]> list = this.headers;
            synchronized (list) {
                int n = this.getIndex(string);
                if (n < 0) {
                    this.headers.add(new String[]{string, string2});
                } else {
                    this.headers.get((int)n)[1] = string2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll(String string) {
            List<String[]> list = this.headers;
            synchronized (list) {
                for (int i = 0; i < this.headers.size(); ++i) {
                    if (!string.equalsIgnoreCase(this.headers.get(i)[0])) continue;
                    this.headers.remove(i);
                    --i;
                }
            }
        }

        private int getIndex(String string) {
            assert (Thread.holdsLock(this.headers));
            int[] nArray = this.getIndexes(string);
            if (nArray.length == 0) {
                return -1;
            }
            return nArray[0];
        }

        private int[] getIndexes(String string) {
            assert (Thread.holdsLock(this.headers));
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.headers.size(); ++i) {
                if (!string.equalsIgnoreCase(this.headers.get(i)[0])) continue;
                arrayList.add(i);
            }
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            return nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            List<String[]> list = this.headers;
            synchronized (list) {
                for (int i = 0; i < this.headers.size(); ++i) {
                    if (i != 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append(this.headers.get(i)[0]).append(": ").append(this.headers.get(i)[1]);
                }
            }
            return stringBuilder.toString();
        }
    }
}

