/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.httpsniffer;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.DecimalFormat;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.koiroha.httpsniffer.HttpProxy;
import org.koiroha.httpsniffer.HttpProxyEvent;
import org.koiroha.httpsniffer.HttpProxyListener;
import org.koiroha.httpsniffer.HttpProxyPanel;
import org.koiroha.httpsniffer.Sniffer;

public class HttpSniffer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = HttpProxy.logger;
    private final JTable requests = new JTable();
    private final Sniffer requestsModel = new Sniffer();
    private final HttpProxyPanel proxyPanel = new HttpProxyPanel();
    private final JSplitPane split = new JSplitPane();
    private final JFormattedTextField port = new JFormattedTextField(new DecimalFormat("####0"));
    private final JButton exec = new JButton();
    private transient Server proxy = null;

    public HttpSniffer() {
        this.setTitle("HTTP Sniffer Proxy");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", this.getToolbar());
        this.getContentPane().add("Center", this.split);
        this.split.setOrientation(0);
        this.split.setResizeWeight(0.0);
        this.split.setDividerLocation(120);
        this.split.setTopComponent(new JScrollPane(this.requests));
        this.split.setBottomComponent(this.proxyPanel);
        this.requests.setModel(this.requestsModel);
        this.requests.setDefaultRenderer(Object.class, new Sniffer.Renderer());
        this.requests.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this.requests.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(20);
        tableColumnModel.getColumn(1).setPreferredWidth(160);
        tableColumnModel.getColumn(2).setPreferredWidth(150);
        tableColumnModel.getColumn(3).setPreferredWidth(320);
        tableColumnModel.getColumn(4).setPreferredWidth(120);
        tableColumnModel.getColumn(5).setPreferredWidth(80);
        tableColumnModel.getColumn(6).setPreferredWidth(60);
        this.requests.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127 && keyEvent.getModifiers() == 0) {
                    HttpSniffer.this.deleteSelected();
                }
            }
        });
        this.requests.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = HttpSniffer.this.requests.getSelectedRow();
                if (n >= 0) {
                    n = HttpSniffer.this.requests.convertRowIndexToModel(n);
                    HttpProxy httpProxy = HttpSniffer.this.requestsModel.get(n);
                    HttpSniffer.this.proxyPanel.setProxy(httpProxy);
                }
            }
        });
        this.pack();
        this.setSize(800, 480);
    }

    private JToolBar getToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new JLabel("\u30d7\u30ed\u30ad\u30b7"));
        this.port.setValue(8088);
        this.port.setHorizontalAlignment(4);
        this.port.setPreferredSize(new Dimension(60, this.port.getPreferredSize().height));
        this.port.setMaximumSize(new Dimension(60, Integer.MAX_VALUE));
        this.port.setMinimumSize(new Dimension(60, 1));
        this.port.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                HttpSniffer.this.checkEnabled();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                HttpSniffer.this.checkEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                HttpSniffer.this.checkEnabled();
            }
        });
        jToolBar.add(this.port);
        this.exec.setText("\u958b\u59cb");
        this.exec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HttpSniffer.this.proxy == null) {
                    HttpSniffer.this.start(Integer.parseInt(HttpSniffer.this.port.getText()));
                } else {
                    HttpSniffer.this.stop();
                }
            }
        });
        jToolBar.add(this.exec);
        jToolBar.addSeparator();
        JButton jButton = new JButton("\u5168\u524a\u9664");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpSniffer.this.requestsModel.clear();
            }
        });
        jToolBar.add(jButton);
        return jToolBar;
    }

    private void checkEnabled() {
        try {
            int n = Integer.parseInt(this.port.getText());
            if (n < 0 || n > 65535) {
                throw new NumberFormatException();
            }
            this.exec.setEnabled(true);
        }
        catch (NumberFormatException numberFormatException) {
            this.exec.setEnabled(false);
        }
    }

    private void deleteSelected() {
        int[] nArray = this.requests.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            logger.finer("no selected rows");
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.requests.convertRowIndexToModel(nArray[i]);
        }
        this.requests.clearSelection();
        this.requestsModel.remove(nArray);
        logger.finer(nArray.length + " rows deleted");
    }

    public void start(int n) {
        HttpProxy.logger.fine("start: " + n);
        this.exec.setText("\u505c\u6b62");
        this.port.setEnabled(false);
        if (this.proxy == null) {
            this.proxy = new Server(n);
            this.proxy.start();
        }
    }

    public void stop() {
        HttpProxy.logger.fine("stop");
        if (this.proxy != null) {
            this.proxy.interrupt();
            this.proxy = null;
        }
        this.exec.setText("\u958b\u59cb");
        this.port.setEnabled(true);
    }

    public static void main(String[] stringArray) {
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Http Sniffer");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        HttpProxy.logger.addHandler(consoleHandler);
        HttpProxy.logger.setLevel(Level.ALL);
        HttpSniffer httpSniffer = new HttpSniffer();
        httpSniffer.setDefaultCloseOperation(3);
        httpSniffer.setVisible(true);
    }

    private class Proxy
    extends Thread
    implements HttpProxyListener {
        private final Socket client;

        public Proxy(Socket socket) {
            this.client = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                final HttpProxy httpProxy = new HttpProxy();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HttpSniffer.this.requestsModel.add(httpProxy);
                    }
                });
                httpProxy.addHttpProxyListener(this);
                httpProxy.execute(this.client);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    this.client.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public void proxyStateChanged(final HttpProxyEvent httpProxyEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HttpSniffer.this.requestsModel.update(httpProxyEvent.getProxy());
                }
            });
        }
    }

    private class Server
    extends Thread {
        private final int port;

        public Server(int n) {
            this.port = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerSocket serverSocket = null;
            try {
                InetAddress inetAddress = InetAddress.getByName("localhost");
                serverSocket = new ServerSocket(this.port, 20, inetAddress);
                serverSocket.setSoTimeout(1000);
                logger.fine("start proxy server: " + serverSocket.getInetAddress() + ":" + serverSocket.getLocalPort());
                while (!this.isInterrupted() && HttpSniffer.this.proxy == this) {
                    Socket socket = null;
                    try {
                        socket = serverSocket.accept();
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        continue;
                    }
                    socket.setSoTimeout(300000);
                    logger.fine("accept connection: " + socket.getInetAddress() + ":" + socket.getPort());
                    Proxy proxy = new Proxy(socket);
                    proxy.start();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                }
                catch (IOException iOException) {}
            }
            logger.fine("stop proxy server");
        }
    }
}

