/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.httpsniffer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import org.koiroha.httpsniffer.ContentPanel;
import org.koiroha.httpsniffer.HttpProxy;
import org.koiroha.httpsniffer.Message;
import org.koiroha.httpsniffer.ParamTableModel;

public class HttpProxyPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private HttpProxy proxy = null;
    private final JRadioButton request = new JRadioButton();
    private final ParamTableModel param = new ParamTableModel();
    private final ParamTableModel cookie = new ParamTableModel();
    private final JTextPane meta = new JTextPane();
    private final ContentPanel content = new ContentPanel();
    private final JSplitPane split1 = new JSplitPane();
    private final JSplitPane split2 = new JSplitPane();

    public HttpProxyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.request.setText("\u30ea\u30af\u30a8\u30b9\u30c8");
        this.request.setSelected(true);
        JRadioButton jRadioButton = new JRadioButton("\u30ec\u30b9\u30dd\u30f3\u30b9");
        buttonGroup.add(this.request);
        buttonGroup.add(jRadioButton);
        jToolBar.add(this.request);
        jToolBar.add(jRadioButton);
        jPanel2.add("North", jToolBar);
        this.request.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                HttpProxyPanel.this.update();
            }
        });
        this.meta.setEditable(false);
        this.split2.setOrientation(0);
        this.split2.setOneTouchExpandable(true);
        this.split2.setDividerLocation(80);
        this.split2.setTopComponent(new JScrollPane(this.meta));
        this.split2.setBottomComponent(this.content);
        jPanel2.add("Center", this.split2);
        this.split1.setOrientation(1);
        this.split1.setOneTouchExpandable(true);
        this.split1.setResizeWeight(0.0);
        this.split1.setDividerLocation(200);
        this.split1.setRightComponent(jPanel2);
        this.split1.setLeftComponent(this.getParamPanel());
        this.setLayout(new BorderLayout());
        this.add("Center", this.split1);
    }

    private JPanel getParamPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("\u30ea\u30af\u30a8\u30b9\u30c8\u30d1\u30e9\u30e1\u30fc\u30bf");
        JTable jTable = new JTable();
        jTable.setModel(this.param);
        jTable.setAutoResizeMode(0);
        jTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        HttpProxyPanel.layout(jPanel, jLabel, 0, 0, 1, 1, 17, 0, 0.0, 0.0, 0, 0, 0, 0, 0, 0);
        HttpProxyPanel.layout(jPanel, new JScrollPane(jTable), 0, 1, 1, 1, 17, 1, 1.0, 1.0, 0, 0, 0, 0, 0, 0);
        jLabel = new JLabel("\u30ea\u30af\u30a8\u30b9\u30c8Cookie");
        JTable jTable2 = new JTable();
        jTable2.setModel(this.cookie);
        jTable2.setAutoResizeMode(0);
        jTable2.getColumnModel().getColumn(0).setPreferredWidth(150);
        jTable2.getColumnModel().getColumn(1).setPreferredWidth(200);
        HttpProxyPanel.layout(jPanel, jLabel, 0, 2, 1, 1, 17, 0, 0.0, 0.0, 0, 0, 0, 0, 0, 0);
        HttpProxyPanel.layout(jPanel, new JScrollPane(jTable2), 0, 3, 1, 1, 17, 1, 1.0, 1.0, 0, 0, 0, 0, 0, 0);
        return jPanel;
    }

    public synchronized void setProxy(HttpProxy httpProxy) {
        this.proxy = httpProxy;
        this.update();
    }

    private void update() {
        Object object;
        Serializable serializable;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        byte[] byArray = null;
        String string = null;
        if (this.proxy != null) {
            serializable = this.request.isSelected() ? this.proxy.getRequest() : this.proxy.getResponse();
            printWriter.print("<html><body style=\"font-size:9px;font-family:dialog;white-space:nowrap;\">");
            if (serializable != null) {
                printWriter.print("<b style=\"font-size:12px;\">" + ((Message)serializable).getStatus().replaceAll("<", "&lt;") + "</b><br>");
                if (((Message)serializable).getHeader() != null) {
                    printWriter.print(((Message)serializable).getHeader().toString().replaceAll("<", "&lt;").replaceAll("\n", "<br>"));
                    string = ((Message)serializable).getHeader().getValue("Content-Type");
                }
                try {
                    byArray = ((Message)serializable).getContent();
                }
                catch (IOException iOException) {
                    try {
                        byArray = ((Message)serializable).getRawContent();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                if (byArray == null) {
                    byArray = new byte[]{};
                }
            }
        }
        this.meta.setContentType("text/html");
        this.meta.setText(stringWriter.toString());
        this.meta.setCaretPosition(0);
        serializable = new StringBuilder();
        this.param.clear();
        if (this.proxy != null && this.proxy.getRequest() != null && this.proxy.getRequest().getUrl() != null && (object = this.proxy.getRequest().getUrl().getQuery()) != null) {
            ((StringBuilder)serializable).append((String)object);
        }
        if (byArray != null && string != null && string.matches("(?i)\\s*application/x-www-form-urlencoded\\s*;?.*")) {
            if (((StringBuilder)serializable).length() > 0) {
                ((StringBuilder)serializable).append('&');
            }
            ((StringBuilder)serializable).append(new String(byArray, Charset.forName("UTF-8")));
        }
        object = ((StringBuilder)serializable).toString().split("&");
        for (int i = 0; i < ((String[])object).length; ++i) {
            int n = object[i].indexOf(61);
            if (n >= 0) {
                String string2 = object[i].substring(0, n);
                String string3 = object[i].substring(n + 1);
                this.param.add(string2, string3);
                continue;
            }
            this.param.add(object[i], null);
        }
        this.content.setContent(byArray, string);
    }

    protected static void layout(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8, int n9, int n10, int n11, int n12) {
        assert (container.getLayout() instanceof GridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        gridBagConstraints.insets = new Insets(n9, n10, n11, n9);
        container.add(component, gridBagConstraints);
    }
}

