/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.httpsniffer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.koiroha.httpsniffer.HttpProxy;

public class ContentPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = HttpProxy.logger;
    private static final Charset[] CHARSET_ALL;
    private static final Charset[] CHARSET_IANA;
    private byte[] content = null;
    private String contentType = null;
    private final JTextArea binary = new JTextArea();
    private final JTextArea text = new JTextArea();
    private final JComboBox textCharset = new JComboBox();
    private final JButton textGuard = new JButton();
    private final JPanel textArea = new JPanel();
    private String textEscape = null;
    private final JLabel image = new JLabel();
    private transient Thread thread = null;

    public ContentPanel() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("\u30d0\u30a4\u30ca\u30ea", this.getBinaryPanel());
        jTabbedPane.addTab("\u30c6\u30ad\u30b9\u30c8", this.getTextPanel());
        jTabbedPane.addTab("\u753b\u50cf", this.getImagePanel());
        this.setLayout(new BorderLayout());
        this.add("Center", jTabbedPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(byte[] byArray, String string) {
        long l = System.currentTimeMillis();
        logger.finer("setContent(content," + string + ")");
        ContentPanel contentPanel = this;
        synchronized (contentPanel) {
            this.content = byArray;
            this.contentType = string;
            this.binary.setText("\u5909\u63db\u4e2d...");
            this.image.setIcon(null);
            this.setDisplayText("\u5909\u63db\u4e2d...");
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }
        logger.fine("setContent(): " + (System.currentTimeMillis() - l) + "ms");
    }

    private JPanel getBinaryPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.binary.setEditable(false);
        this.binary.setFont(new Font("monospaced", 0, this.binary.getFont().getSize()));
        ContentPanel.layout(jPanel, new JScrollPane(this.binary), 0, 0, 1, 1, 10, 1, 1.0, 1.0, 0, 0, 0, 0, 0, 0);
        return jPanel;
    }

    private JPanel getTextPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.set(this.textCharset, CHARSET_IANA);
        ContentPanel.layout(jPanel, this.textCharset, 0, 0, 1, 1, 17, 0, 0.0, 0.0, 0, 0, 0, 0, 0, 0);
        this.textCharset.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ContentPanel.this.updateTextPanel();
            }
        });
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setText("\u5168\u3066\u8868\u793a");
        jCheckBox.setSelected(false);
        ContentPanel.layout(jPanel, jCheckBox, 1, 0, 1, 1, 17, 0, 1.0, 0.0, 0, 0, 0, 0, 0, 0);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (jCheckBox.isSelected()) {
                    ContentPanel.this.set(ContentPanel.this.textCharset, CHARSET_ALL);
                } else {
                    ContentPanel.this.set(ContentPanel.this.textCharset, CHARSET_IANA);
                }
            }
        });
        this.textArea.setLayout(new CardLayout());
        ContentPanel.layout(jPanel, this.textArea, 0, 1, 2, 1, 10, 1, 1.0, 1.0, 0, 0, 0, 0, 0, 0);
        this.text.setLineWrap(true);
        this.text.setTabSize(4);
        this.text.setEditable(false);
        this.textArea.add("text", new JScrollPane(this.text));
        this.textGuard.setText("\u30d0\u30a4\u30ca\u30ea\u3082\u3057\u304f\u306f\u6587\u5b57\u5316\u3051\u3092\u542b\u307f\u307e\u3059\u3002\u8868\u793a\u3059\u308b\u5834\u5408\u306f\u3053\u306e\u30d1\u30cd\u30eb\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        this.textGuard.setVisible(false);
        this.textArea.add("guard", this.textGuard);
        this.textGuard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContentPanel.this.setTextGuard(false);
            }
        });
        ((CardLayout)this.textArea.getLayout()).show(this.textArea, "text");
        return jPanel;
    }

    private JPanel getImagePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ContentPanel.layout(jPanel, new JScrollPane(this.image), 0, 0, 1, 1, 18, 0, 1.0, 1.0, 0, 0, 0, 0, 0, 0);
        return jPanel;
    }

    private void updateTextPanel() {
        Charset charset = (Charset)this.textCharset.getSelectedItem();
        if (charset == null) {
            charset = this.getDefaultCharset();
        }
        String string = ContentPanel.getDisplayText(this.content, charset);
        this.setDisplayText(string);
        this.text.setCaretPosition(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final Thread thread = Thread.currentThread();
        byte[] byArray = null;
        Object object = this;
        synchronized (object) {
            if (this.thread != thread) {
                return;
            }
            byArray = this.content;
        }
        object = ContentPanel.getDisplayBinary(byArray);
        if (this.thread != thread) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable((String)object){
            final /* synthetic */ String val$bin;
            {
                this.val$bin = string;
            }

            @Override
            public void run() {
                if (ContentPanel.this.thread == thread) {
                    ContentPanel.this.binary.setText(this.val$bin);
                    ContentPanel.this.binary.setCaretPosition(0);
                }
            }
        });
        Charset charset = (Charset)this.textCharset.getSelectedItem();
        if (charset == null) {
            charset = this.getDefaultCharset();
        }
        final String string = ContentPanel.getDisplayText(byArray, charset);
        if (this.thread != thread) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ContentPanel.this.thread == thread) {
                    ContentPanel.this.setDisplayText(string);
                    ContentPanel.this.text.setCaretPosition(0);
                }
            }
        });
        final Icon icon = ContentPanel.getDisplayImage(byArray);
        if (this.thread != thread) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ContentPanel.this.thread == thread) {
                    Container container;
                    ContentPanel.this.image.setIcon(icon);
                    if (icon != null) {
                        ContentPanel.this.image.setSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                    }
                    for (container = ContentPanel.this.image.getParent(); !(container instanceof JPanel) && container != null; container = container.getParent()) {
                    }
                    if (container != null) {
                        if (icon != null) {
                            container.setSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                        }
                        container.doLayout();
                    }
                }
            }
        });
    }

    private static String getDisplayBinary(byte[] byArray) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringBuilder stringBuilder = new StringBuilder(16);
        printWriter.println("    : 00 01 02 03 04 05 06 07  08 09 0A 0B 0C 0D 0E 0F |");
        printWriter.println("----+--------------------------------------------------+------------------");
        int n = 0;
        while (byArray != null && n * 16 < Math.min(byArray.length, 655360)) {
            printWriter.printf("%04X: ", n * 16);
            for (int i = 0; i < 16; ++i) {
                int n2 = n * 16 + i;
                if (n2 >= byArray.length) {
                    while (i < 16) {
                        printWriter.print("   ");
                        if (i == 7) {
                            printWriter.print(" ");
                        }
                        ++i;
                    }
                    break;
                }
                printWriter.printf("%X%X ", byArray[n2] >> 4 & 0xF, byArray[n2] & 0xF);
                if (byArray[n2] >= 32 && byArray[n2] < 127) {
                    stringBuilder.append((char)byArray[n2]);
                } else {
                    stringBuilder.append('.');
                }
                if (i != 7) continue;
                printWriter.print(' ');
                stringBuilder.append(' ');
            }
            printWriter.printf("| %s%n", stringBuilder);
            stringBuilder.setLength(0);
            ++n;
        }
        return stringWriter.toString();
    }

    private static String getDisplayText(byte[] byArray, Charset charset) {
        if (byArray == null) {
            return "";
        }
        String string = new String(byArray, 0, Math.min(byArray.length, 65536), charset);
        if (byArray.length > 65536) {
            string = string + "(\u7701\u7565)";
        }
        return string;
    }

    private static Icon getDisplayImage(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
            if (bufferedImage == null) {
                return null;
            }
            return new ImageIcon(bufferedImage);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "fail to convert image", exception);
            return null;
        }
    }

    private void setDisplayText(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = Math.min(string.length(), 8192);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '\ufffd' || !((double)(++n) / (double)n2 >= 0.01)) continue;
            bl = true;
            break;
        }
        this.textEscape = null;
        if (bl) {
            this.setTextGuard(true);
            this.text.setText("");
            this.textEscape = string;
        } else {
            this.setTextGuard(false);
            this.text.setText(string);
            this.textEscape = null;
        }
    }

    private void setTextGuard(boolean bl) {
        ((CardLayout)this.textArea.getLayout()).show(this.textArea, bl ? "guard" : "text");
        if (!bl && this.textEscape != null) {
            this.text.setText(this.textEscape);
            this.textEscape = null;
        }
    }

    private Charset getDefaultCharset() {
        Object object;
        if (this.contentType != null && (object = this.parseContentType(this.contentType)) != null) {
            return object;
        }
        if (this.content != null) {
            Object object2;
            object = new String(this.content, 0, Math.min(this.content.length, 4096), Charset.forName("us-ascii"));
            Pattern pattern = Pattern.compile("<\\?xml\\s([^?]*)\\?>");
            Matcher matcher = pattern.matcher((CharSequence)object);
            if (matcher.find()) {
                logger.finer("finding charset from xml declaration: " + matcher.group(1));
                pattern = Pattern.compile("encoding\\s*=\\s*[\"']([a-zA-Z0-9\\-_]*)[\"']");
                matcher = pattern.matcher(matcher.group(1));
                if (matcher.find()) {
                    object2 = matcher.group(1);
                    logger.finer("finding charset from xml declaration: encoding=\"" + (String)object2 + "\"");
                    if (Charset.isSupported((String)object2)) {
                        return Charset.forName((String)object2);
                    }
                    logger.finer("xml encoding " + (String)object2 + " is not supported");
                }
            }
            pattern = Pattern.compile("<meta\\s+http-equiv\\s*=\\s*[\"']?content-type[\"']?\\s+content\\s*=\\s*[\"']?([^\"'>]*)", 2);
            matcher = pattern.matcher((CharSequence)object);
            while (matcher.find()) {
                logger.finer("finding charset from html meta tag: " + matcher.group(1));
                object2 = this.parseContentType(matcher.group(1));
                if (object2 == null) continue;
                return object2;
            }
            pattern = Pattern.compile("@charset\\s+[\"']?([a-zA-Z0-9\\-_]*)[\"']?");
            matcher = pattern.matcher((CharSequence)object);
            if (matcher.find()) {
                logger.finer("finding charset from css @charset: " + matcher.group(1));
                if (Charset.isSupported(matcher.group(1))) {
                    return Charset.forName(matcher.group(1));
                }
            }
        }
        logger.finer("apply default charset");
        return Charset.defaultCharset();
    }

    private Charset parseContentType(String string) {
        Pattern pattern = Pattern.compile(";\\s*charset\\s*=\\s*[\"']?([a-zA-Z0-9\\-_]*)[\"']?", 2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            logger.finer("content-type not contain charset: " + string);
            return null;
        }
        String string2 = matcher.group(1);
        if (!Charset.isSupported(string2)) {
            logger.warning("charset not supported: " + string2);
            return null;
        }
        logger.finer("charset determine: " + string2);
        return Charset.forName(string2);
    }

    private void set(JComboBox jComboBox, Object[] objectArray) {
        Object object = jComboBox.getSelectedItem();
        jComboBox.removeAllItems();
        jComboBox.addItem(null);
        for (int i = 0; i < objectArray.length; ++i) {
            jComboBox.addItem(objectArray[i]);
        }
        jComboBox.setSelectedItem(object);
    }

    protected static void layout(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8, int n9, int n10, int n11, int n12) {
        assert (container.getLayout() instanceof GridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        gridBagConstraints.insets = new Insets(n9, n10, n11, n9);
        container.add(component, gridBagConstraints);
    }

    static {
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        CHARSET_ALL = new ArrayList<Charset>(sortedMap.values()).toArray(new Charset[sortedMap.size()]);
        ArrayList<Charset> arrayList = new ArrayList<Charset>();
        for (Charset charset : CHARSET_ALL) {
            if (!charset.isRegistered()) continue;
            arrayList.add(charset);
        }
        CHARSET_IANA = arrayList.toArray(new Charset[arrayList.size()]);
    }
}

