/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.httpsniffer;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.koiroha.httpsniffer.HttpProxy;

public class ChunkedInputStream
extends FilterInputStream {
    private static final Logger logger = HttpProxy.logger;
    private int remaining = 0;
    private boolean eof = false;

    public ChunkedInputStream(InputStream inputStream) {
        super(new PushbackInputStream(inputStream));
    }

    @Override
    public int read() throws IOException {
        if (!this.next()) {
            return -1;
        }
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        --this.remaining;
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.next()) {
            return -1;
        }
        n2 = Math.min(this.remaining, n2);
        if ((n2 = this.in.read(byArray, n, n2)) < 0) {
            throw new EOFException();
        }
        this.remaining -= n2;
        return n2;
    }

    private boolean next() throws IOException {
        if (this.remaining != 0) {
            return true;
        }
        if (this.eof) {
            return false;
        }
        String string = this.readLine().trim();
        if (string.length() == 0) {
            string = this.readLine().trim();
        }
        if (string.indexOf(59) >= 0) {
            string = string.substring(0, string.indexOf(59)).trim();
        }
        this.remaining = Integer.parseInt(string, 16);
        boolean bl = this.eof = this.remaining == 0;
        if (this.eof) {
            logger.finer("last chunk detected, eof");
            String string2 = null;
            while ((string2 = this.readLine()).length() > 0) {
            }
        } else {
            logger.finer("chunk detected: " + this.remaining + " bytes");
        }
        return !this.eof;
    }

    private String readLine() throws IOException {
        int n;
        PushbackInputStream pushbackInputStream = (PushbackInputStream)this.in;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = pushbackInputStream.read()) >= 0 && n != 10) {
            if (n == 13) {
                n = pushbackInputStream.read();
                if (n == 10 || n < 0) break;
                pushbackInputStream.unread(n);
                break;
            }
            byteArrayOutputStream.write(n);
        }
        return new String(byteArrayOutputStream.toByteArray(), Charset.forName("UTF-8"));
    }
}

