/* **************************************************************************
 * Copyright (C) 2008 BJoRFUAN. All Right Reserved
 * **************************************************************************
 * This module, contains source code, binary and documentation, is in the
 * BSD License, and comes with NO WARRANTY.
 * 
 *                                                 torao <torao@bjorfuan.com>
 *                                                       http://www.moyo.biz/
 * $Id: Type.java,v 1.2 2008/08/11 07:10:59 torao Exp $
*/
package org.koiroha.fixez;



// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Type: タイプ列挙
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/**
 * {@linkplain ExifField Exif フィールド}に対する型の列挙です。
 * <p>
 * @version fixez 1.0 - $Revision: 1.2 $ $Date: 2008/08/11 07:10:59 $
 * @author <a href="mailto:torao@mars.dti.ne.jp">torao</a>
 * @since fixez 1.0 - 2008/08/11
 */
public enum Type {

	// ======================================================================
	// [タイプ] 符号無 1 バイト値
	// ======================================================================
	/**
	 * 符号無 1 バイト整数を表すタイプです。
	 * <p>
	*/
	UBYTE(1),

	// ======================================================================
	// [タイプ] ASCII 文字列
	// ======================================================================
	/**
	 * ASCII 文字列を表すタイプです。文字列のバイナリは 0x00 で終了します。
	 * <p>
	*/
	ASCII(2),

	// ======================================================================
	// [タイプ] 符号無 2 バイト値
	// ======================================================================
	/**
	 * 符号無 2 バイト整数を表すタイプです。
	 * <p>
	*/
	USHORT(3),

	// ======================================================================
	// [タイプ] 符号無 4 バイト値
	// ======================================================================
	/**
	 * 符号無 4 バイト整数を表すタイプです。
	 * <p>
	*/
	ULONG(4),

	// ======================================================================
	// [タイプ] 符号無 4 バイト分数値
	// ======================================================================
	/**
	 * 符号無 4 バイト整数の分数を表します。
	 * <p>
	*/
	URATIONAL(5),

	// ======================================================================
	// [タイプ] 符号付 1 バイト値
	// ======================================================================
	/**
	 * 符号付1バイト値を表すタイプです。
	 * <p>
	*/
	BYTE(6),

	// ======================================================================
	// [タイプ] 未定義
	// ======================================================================
	/**
	 * タグ依存の未定義型を表すタイプです。
	 * <p>
	*/
	UNDEFINED(7),

	// ======================================================================
	// [タイプ] 符号付 2 バイト値
	// ======================================================================
	/**
	 * 符号付 2 バイト識別子を表すタイプです。
	 * <p>
	*/
	SHORT(8),

	// ======================================================================
	// [タイプ] 符号付 4 バイト値
	// ======================================================================
	/**
	 * 符号付 4 バイト識別子を表すタイプです。
	 * <p>
	*/
	LONG(9),

	// ======================================================================
	// [タイプ] 符号付 4 バイト分数値
	// ======================================================================
	/**
	 * 符号付 4 バイト整数の分数を表します。
	 * <p>
	*/
	RATIONAL(10),

	// ======================================================================
	// [タイプ] 単精度浮動小数点
	// ======================================================================
	/**
	 * 単精度浮動小数点を表します。
	 * <p>
	*/
	SFLOAT(11),

	// ======================================================================
	// [タイプ] 倍精度浮動小数点
	// ======================================================================
	/**
	 * 倍精度浮動小数点を表します。
	 * <p>
	*/
	DFLOAT(12),

	;

	// ======================================================================
	// 数値
	// ======================================================================
	/**
	 * このタイプの値です。
	 * <p>
	*/
	private final int num;

	// ======================================================================
	// コンストラクタ
	// ======================================================================
	/**
	 * 数値を指定して構築を行います。
	 * <p>
	 * @param num タイプの値
	*/
	private Type(int num){
		this.num = num;
		return;
	}

	// ======================================================================
	// 値の参照
	// ======================================================================
	/**
	 * このタイプの 16 ビット値を参照します。
	 * <p>
	 * @return タイプの値
	*/
	public int getDigit(){
		return num;
	}

	// ======================================================================
	// インスタンスの参照
	// ======================================================================
	/**
	 * 指定されたタイプの値に対するインスタンスを参照します。該当する定数が
	 * 定義されていない場合は null を返します。
	 * <p>
	 * @param num タイプの値
	 * @return タイプ
	*/
	public static Type valueOf(int num){
		for(Type type: Type.values()){
			if(type.getDigit() == num){
				return type;
			}
		}
		return null;
	}

}
