/* **************************************************************************
 * Copyright (C) 2008 BJoRFUAN. All Right Reserved
 * **************************************************************************
 * This module, contains source code, binary and documentation, is in the
 * BSD License, and comes with NO WARRANTY.
 * 
 *                                                 torao <torao@bjorfuan.com>
 *                                                       http://www.moyo.biz/
 * $Id: Tag.java,v 1.3 2008/08/11 17:30:11 torao Exp $
*/
package org.koiroha.fixez;



// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Tag: タグ値定義
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/**
 * タグ値の定数を定義するためのインターフェースです。
 * <p>
 * @version fixez 1.0 - $Revision: 1.3 $ $Date: 2008/08/11 17:30:11 $
 * @author <a href="mailto:torao@mars.dti.ne.jp">torao</a>
 * @since fixez 1.0 - 2008/08/11
 */
public interface Tag {

	// ======================================================================
	// IFD 0th
	// ======================================================================
	/**
	 * {@link IFD#I0TH} を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int IFD_0TH = 0xFFFF;

	// ======================================================================
	// IFD 1st
	// ======================================================================
	/**
	 * {@link IFD#I1ST} を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int IFD_1ST = 0xFFFE;

	// ======================================================================
	// IFD Exif
	// ======================================================================
	/**
	 * {@link IFD#EXIF} を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int IFD_EXIF = 0x8769;

	// ======================================================================
	// IFD GPS
	// ======================================================================
	/**
	 * {@link IFD#GPS} を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int IFD_GPS = 0x8825;

	// ======================================================================
	// IFD 互換性
	// ======================================================================
	/**
	 * {@link IFD#INTROP} を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int IFD_INTROP = 0xA005;

	// ======================================================================
	// 画像の幅
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像の幅を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_IMAGE_WIDTH = 0x0100;

	// ======================================================================
	// 画像の高さ
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像の高さを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_IMAGE_LENGTH = 0x0101;

	// ======================================================================
	// 画像のビットの深さ
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像のビットの深さを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_BITS_PER_SAMPLE = 0x0102;

	// ======================================================================
	// 圧縮の種類
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の圧縮の種類を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_COMPRESSION = 0x0103;

	// ======================================================================
	// 画素構成
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画素構成を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_PHOTOMETRIC_INTERPRETATION = 0x0106;

	// ======================================================================
	// 画像方向
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像方向を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_ORIENTATION = 0x0112;

	// ======================================================================
	// コンポーネント数
	// ======================================================================
	/**
	 * {@link IFD#I0TH} のコンポーネント数を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_SAMPLES_PER_PIXEL = 0x0115;

	// ======================================================================
	// 画像データの並び
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像データの並びを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_PLANAR_CONFIGURATION = 0x011C;

	// ======================================================================
	// YCC の画素構成（C の間引き率）
	// ======================================================================
	/**
	 * {@link IFD#I0TH} のYCC の画素構成（C の間引き率）を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_YCB_CR_SUB_SAMPLING = 0x0212;

	// ======================================================================
	// YCC の画素構成（Y とC の位置）
	// ======================================================================
	/**
	 * {@link IFD#I0TH} のYCC の画素構成（Y とC の位置）を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_YCB_CR_POSITIONING = 0x0213;

	// ======================================================================
	// 画像の幅の解像度
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像の幅の解像度を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_XRESOLUTION = 0x011A;

	// ======================================================================
	// 画像の高さの解像度
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像の高さの解像度を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_YRESOLUTION = 0x011B;

	// ======================================================================
	// 画像の幅と高さの解像度の単位
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像の幅と高さの解像度の単位を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_RESOLUTION_UNIT = 0x0128;

	// ======================================================================
	// 画像データのロケーション
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像データのロケーションを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_STRIP_OFFSETS = 0x0111;

	// ======================================================================
	// ストリップ中のライン数
	// ======================================================================
	/**
	 * {@link IFD#I0TH} のストリップ中のライン数を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_ROWS_PER_STRIP = 0x0116;

	// ======================================================================
	// ストリップのデータ量
	// ======================================================================
	/**
	 * {@link IFD#I0TH} のストリップのデータ量を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_STRIP_BYTE_COUNTS = 0x0117;

	// ======================================================================
	// JPEG のSOI へのオフセット
	// ======================================================================
	/**
	 * {@link IFD#I0TH} のJPEG のSOI へのオフセットを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_JPEG_INTERCHANGE_FORMAT = 0x0201;

	// ======================================================================
	// JPEG データのバイト数
	// ======================================================================
	/**
	 * {@link IFD#I0TH} のJPEG データのバイト数を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_JPEG_INTERCHANGE_FORMAT_LENGTH = 0x0202;

	// ======================================================================
	// 再生階調カーブ特性
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の再生階調カーブ特性を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_TRANSFER_FUNCTION = 0x012D;

	// ======================================================================
	// 参照白色点の色度座標値
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の参照白色点の色度座標値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_WHITE_POINT = 0x013E;

	// ======================================================================
	// 原色の色度座標値
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の原色の色度座標値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_PRIMARY_CHROMATICITIES = 0x013F;

	// ======================================================================
	// 色変換マトリクス係数
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の色変換マトリクス係数を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_YCB_CR_COEFFICIENTS = 0x0211;

	// ======================================================================
	// 参照黒色点値と参照白色点値
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の参照黒色点値と参照白色点値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_REFERENCE_BLACK_WHITE = 0x0214;

	// ======================================================================
	// ファイル変更日時
	// ======================================================================
	/**
	 * {@link IFD#I0TH} のファイル変更日時を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_DATE_TIME = 0x0132;

	// ======================================================================
	// 画像タイトル
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像タイトルを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_IMAGE_DESCRIPTION = 0x010E;

	// ======================================================================
	// 画像入力機器のメーカー名
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像入力機器のメーカー名を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_MAKE = 0x010F;

	// ======================================================================
	// 画像入力機器のモデル名
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の画像入力機器のモデル名を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_MODEL = 0x0110;

	// ======================================================================
	// 使用ソフトウェア名
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の使用ソフトウェア名を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_SOFTWARE = 0x0131;

	// ======================================================================
	// 作者名
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の作者名を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_ARTIST = 0x013B;

	// ======================================================================
	// 撮影著作権者/編集著作権者
	// ======================================================================
	/**
	 * {@link IFD#I0TH} の撮影著作権者/編集著作権者を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I0TH_COPYRIGHT = 0x8298;

	// ======================================================================
	// 画像の幅
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像の幅を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_IMAGE_WIDTH = 0x0100;

	// ======================================================================
	// 画像の高さ
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像の高さを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_IMAGE_LENGTH = 0x0101;

	// ======================================================================
	// 画像のビットの深さ
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像のビットの深さを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_BITS_PER_SAMPLE = 0x0102;

	// ======================================================================
	// 圧縮の種類
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の圧縮の種類を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_COMPRESSION = 0x0103;

	// ======================================================================
	// 画素構成
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画素構成を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_PHOTOMETRIC_INTERPRETATION = 0x0106;

	// ======================================================================
	// 画像方向
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像方向を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_ORIENTATION = 0x0112;

	// ======================================================================
	// コンポーネント数
	// ======================================================================
	/**
	 * {@link IFD#I1ST} のコンポーネント数を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_SAMPLES_PER_PIXEL = 0x0115;

	// ======================================================================
	// 画像データの並び
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像データの並びを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_PLANAR_CONFIGURATION = 0x011C;

	// ======================================================================
	// YCC の画素構成（C の間引き率）
	// ======================================================================
	/**
	 * {@link IFD#I1ST} のYCC の画素構成（C の間引き率）を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_YCB_CR_SUB_SAMPLING = 0x0212;

	// ======================================================================
	// YCC の画素構成（Y とC の位置）
	// ======================================================================
	/**
	 * {@link IFD#I1ST} のYCC の画素構成（Y とC の位置）を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_YCB_CR_POSITIONING = 0x0213;

	// ======================================================================
	// 画像の幅の解像度
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像の幅の解像度を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_XRESOLUTION = 0x011A;

	// ======================================================================
	// 画像の高さの解像度
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像の高さの解像度を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_YRESOLUTION = 0x011B;

	// ======================================================================
	// 画像の幅と高さの解像度の単位
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像の幅と高さの解像度の単位を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_RESOLUTION_UNIT = 0x0128;

	// ======================================================================
	// 画像データのロケーション
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像データのロケーションを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_STRIP_OFFSETS = 0x0111;

	// ======================================================================
	// ストリップ中のライン数
	// ======================================================================
	/**
	 * {@link IFD#I1ST} のストリップ中のライン数を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_ROWS_PER_STRIP = 0x0116;

	// ======================================================================
	// ストリップのデータ量
	// ======================================================================
	/**
	 * {@link IFD#I1ST} のストリップのデータ量を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_STRIP_BYTE_COUNTS = 0x0117;

	// ======================================================================
	// JPEG のSOI へのオフセット
	// ======================================================================
	/**
	 * {@link IFD#I1ST} のJPEG のSOI へのオフセットを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_JPEG_INTERCHANGE_FORMAT = 0x0201;

	// ======================================================================
	// JPEG データのバイト数
	// ======================================================================
	/**
	 * {@link IFD#I1ST} のJPEG データのバイト数を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_JPEG_INTERCHANGE_FORMAT_LENGTH = 0x0202;

	// ======================================================================
	// 再生階調カーブ特性
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の再生階調カーブ特性を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_TRANSFER_FUNCTION = 0x012D;

	// ======================================================================
	// 参照白色点の色度座標値
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の参照白色点の色度座標値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_WHITE_POINT = 0x013E;

	// ======================================================================
	// 原色の色度座標値
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の原色の色度座標値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_PRIMARY_CHROMATICITIES = 0x013F;

	// ======================================================================
	// 色変換マトリクス係数
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の色変換マトリクス係数を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_YCB_CR_COEFFICIENTS = 0x0211;

	// ======================================================================
	// 参照黒色点値と参照白色点値
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の参照黒色点値と参照白色点値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_REFERENCE_BLACK_WHITE = 0x0214;

	// ======================================================================
	// ファイル変更日時
	// ======================================================================
	/**
	 * {@link IFD#I1ST} のファイル変更日時を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_DATE_TIME = 0x0132;

	// ======================================================================
	// 画像タイトル
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像タイトルを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_IMAGE_DESCRIPTION = 0x010E;

	// ======================================================================
	// 画像入力機器のメーカー名
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像入力機器のメーカー名を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_MAKE = 0x010F;

	// ======================================================================
	// 画像入力機器のモデル名
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の画像入力機器のモデル名を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_MODEL = 0x0110;

	// ======================================================================
	// 使用ソフトウェア名
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の使用ソフトウェア名を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_SOFTWARE = 0x0131;

	// ======================================================================
	// 作者名
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の作者名を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_ARTIST = 0x013B;

	// ======================================================================
	// 撮影著作権者/編集著作権者
	// ======================================================================
	/**
	 * {@link IFD#I1ST} の撮影著作権者/編集著作権者を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int I1ST_COPYRIGHT = 0x8298;

	// ======================================================================
	// Exif バージョン
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の Exif バージョンを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_EXIF_VERSION = 0x9000;

	// ======================================================================
	// 対応フラッシュピックスバージョン
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の対応フラッシュピックスバージョンを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_FLASH_PIX_VERSION = 0xA000;

	// ======================================================================
	// 色空間情報
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の色空間情報を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_COLOR_SPACE = 0xA001;

	// ======================================================================
	// 各コンポーネントの意味
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の各コンポーネントの意味を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_COMPONENTS_CONFIGURATION = 0x9101;

	// ======================================================================
	// 画像圧縮モード
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の画像圧縮モードを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_COMPRESSED_BITS_PER_PIXEL = 0x9102;

	// ======================================================================
	// 実効画像幅
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の実効画像幅を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_PIXEL_XDIMENSION = 0xA002;

	// ======================================================================
	// 実効画像高さ
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の実効画像高さを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_PIXEL_YDIMENSION = 0xA003;

	// ======================================================================
	// メーカーノート
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のメーカーノートを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_MAKER_NOTE = 0x927C;

	// ======================================================================
	// ユーザーコメント
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のユーザーコメントを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_USER_COMMENT = 0x9286;

	// ======================================================================
	// 関連音声ファイル
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の関連音声ファイルを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_RELATED_SOUND_FILE = 0xA004;

	// ======================================================================
	// 原画像データの生成日時
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の原画像データの生成日時を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_DATE_TIME_ORIGINAL = 0x9003;

	// ======================================================================
	// ディジタルデータの作成日時
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のディジタルデータの作成日時を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_DATE_TIME_DIGITIZED = 0x9004;

	// ======================================================================
	// DateTime のサブセック
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のDateTime のサブセックを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SUB_SEC_TIME = 0x9290;

	// ======================================================================
	// DateTimeOriginal のサブセック
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のDate_Time_Original のサブセックを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SUB_SEC_TIME_ORIGINAL = 0x9291;

	// ======================================================================
	// DateTimeDigitized のサブセック
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のDateTimeDigitized のサブセックを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SUB_SEC_TIME_DIGITIZED = 0x9292;

	// ======================================================================
	// 互換性IFD へのポインタ
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の互換性 IFD へのポインタを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_INTEROPERABILIY_IFD_POINTER = 0xA005;

	// ======================================================================
	// 露出時間
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の露出時間を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_EXPOSURE_TIME = 0x829A;

	// ======================================================================
	// F ナンバー
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のF ナンバーを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_F_NUMBER = 0x829D;

	// ======================================================================
	// 露出プログラム
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の露出プログラムを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_EXPOSURE_PROGRAM = 0x8822;

	// ======================================================================
	// スペクトル感度
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のスペクトル感度を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SPECTRAL_SENSITIVITY = 0x8824;

	// ======================================================================
	// ISO スピードレート
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のISO スピードレートを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_ISO_SPEED_RATINGS = 0x8827;

	// ======================================================================
	// 光電変換関数
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の光電変換関数を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_OECF = 0x8828;

	// ======================================================================
	// シャッタースピード
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のシャッタースピードを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SHUTTER_SPEED_VALUE = 0x9201;

	// ======================================================================
	// 絞り値
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の絞り値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_APERTURE_VALUE = 0x9202;

	// ======================================================================
	// 輝度値
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の輝度値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_BRIGHTNESS_VALUE = 0x9203;

	// ======================================================================
	// 露光補正値
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の露光補正値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_EXPOSURE_BIAS_VALUE = 0x9204;

	// ======================================================================
	// レンズ最小Ｆ値
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のレンズ最小Ｆ値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_MAX_APERTURE_VALUE = 0x9205;

	// ======================================================================
	// 被写体距離
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の被写体距離を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SUBJECT_DISTANCE = 0x9206;

	// ======================================================================
	// 測光方式
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の測光方式を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_METERING_MODE = 0x9207;

	// ======================================================================
	// 光源
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の光源を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_LIGHT_SOURCE = 0x9208;

	// ======================================================================
	// フラッシュ
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のフラッシュを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_FLASH = 0x9209;

	// ======================================================================
	// レンズ焦点距離
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のレンズ焦点距離を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_FOCAL_LENGTH = 0x920A;

	// ======================================================================
	// フラッシュ強度
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のフラッシュ強度を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_FLASH_ENERGY = 0xA20B;

	// ======================================================================
	// 空間周波数応答
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の空間周波数応答を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SPATIAL_FREQUENCY_RESPONSE = 0xA20C;

	// ======================================================================
	// 焦点面の幅の解像度
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の焦点面の幅の解像度を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_FOCAL_PLANE_XRESOLUTION = 0xA20E;

	// ======================================================================
	// 焦点面の高さの解像度
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の焦点面の高さの解像度を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_FOCAL_PLANE_YRESOLUTION = 0xA20F;

	// ======================================================================
	// 焦点面解像度単位
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の焦点面解像度単位を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_FOCAL_PLANE_RESOLUTION_UNIT = 0xA210;

	// ======================================================================
	// 被写体位置
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の被写体位置を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SUBJECT_LOCATION = 0xA214;

	// ======================================================================
	// 露出インデックス
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の露出インデックスを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_EXPOSURE_INDEX = 0xA215;

	// ======================================================================
	// センサー方式
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のセンサー方式を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SENSING_METHOD = 0xA217;

	// ======================================================================
	// ファイルソース
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のファイルソースを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_FILE_SOURCE = 0xA300;

	// ======================================================================
	// シーンタイプ
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のシーンタイプを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SCENE_TYPE = 0xA301;

	// ======================================================================
	// CFA パターン
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のCFA パターンを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_CFAPATTERN = 0xA302;

	// ======================================================================
	// カスタム画像処理
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のカスタム画像処理を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_CUSTOM_RENDERED = 0xA401;

	// ======================================================================
	// 撮影モード
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の撮影モードを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_EXPOSURE_MODE = 0xA402;

	// ======================================================================
	// ホワイトバランスモード
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のホワイトバランスモードを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_WHITE_BALANCE = 0xA403;

	// ======================================================================
	// デジタルズーム
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のデジタルズームを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_DIGITAL_ZOOM_RATIO = 0xA404;

	// ======================================================================
	// レンズの焦点距離(35mm)
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のレンズの焦点距離(35mm)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_FOCAL_LENGTH_IN35MM_FILM = 0xA405;

	// ======================================================================
	// シーン撮影タイプ
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のシーン撮影タイプを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SCENE_CAPTURE_TYPE = 0xA406;

	// ======================================================================
	// ゲインコントロール
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のゲインコントロールを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_GAIN_CONTROL = 0xA407;

	// ======================================================================
	// コントラスト
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のコントラストを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_CONTRAST = 0xA408;

	// ======================================================================
	// 彩度
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の彩度を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SATURATION = 0xA409;

	// ======================================================================
	// シャープネス
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のシャープネスを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SHARPNESS = 0xA40A;

	// ======================================================================
	// デバイス設定詳細
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のデバイス設定詳細を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_DEVICE_SETTING_DESCRIPTION = 0xA40B;

	// ======================================================================
	// 被写体の距離範囲
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の被写体の距離範囲を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_SUBJECT_DISTANCE_RANGE = 0xA40C;

	// ======================================================================
	// 画像識別ID
	// ======================================================================
	/**
	 * {@link IFD#EXIF} の画像識別IDを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_IMAGE_UNIQUE_ID = 0xA420;

	// ======================================================================
	// ガンマ値
	// ======================================================================
	/**
	 * {@link IFD#EXIF} のガンマ値を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int EXIF_GAMMA = 0xA500;

	// ======================================================================
	// GPS: GPS タグのバージョン
	// ======================================================================
	/**
	 * {@link IFD#GPS} の GPS タグのバージョンを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_VERSION_ID = 0x0000;

	// ======================================================================
	// GPS: 北緯(N) or 南緯(S)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の北緯(N) or 南緯(S)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_LATITUDE_REF = 0x0001;

	// ======================================================================
	// GPS: 緯度 (数値)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の緯度 (数値)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_LATITUDE = 0x0002;

	// ======================================================================
	// GPS: 東経(E) or 西経(W)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の東経(E) or 西経(W)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_LONGITUDE_REF = 0x0003;

	// ======================================================================
	// GPS: 経度 (数値)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の経度 (数値)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_LONGITUDE = 0x0004;

	// ======================================================================
	// GPS: 高度の単位
	// ======================================================================
	/**
	 * {@link IFD#GPS} の高度の単位を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_ALTITUDE_REF = 0x0005;

	// ======================================================================
	// GPS: 高度 (数値)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の高度 (数値)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_ALTITUDE = 0x0006;

	// ======================================================================
	// GPS: GPS 時間 (原子時計の時間)
	// ======================================================================
	/**
	 * {@link IFD#GPS} のGPS 時間 (原子時計の時間)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_TIME_STAMP = 0x0007;

	// ======================================================================
	// GPS: 測位に使った衛星信号
	// ======================================================================
	/**
	 * {@link IFD#GPS} の測位に使った衛星信号を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_SATELLITES = 0x0008;

	// ======================================================================
	// GPS: GPS 受信機の状態
	// ======================================================================
	/**
	 * {@link IFD#GPS} のGPS 受信機の状態を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_STATUS = 0x0009;

	// ======================================================================
	// GPS: GPS の測位方法
	// ======================================================================
	/**
	 * {@link IFD#GPS} のGPS の測位方法を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_MEASURE_MODE = 0x000A;

	// ======================================================================
	// GPS: 測位の信頼性
	// ======================================================================
	/**
	 * {@link IFD#GPS} の測位の信頼性を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DOP = 0x000B;

	// ======================================================================
	// GPS: 速度の単位
	// ======================================================================
	/**
	 * {@link IFD#GPS} の速度の単位を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_SPEED_REF = 0x000C;

	// ======================================================================
	// GPS: 速度 (数値)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の速度 (数値)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_SPEED = 0x000D;

	// ======================================================================
	// GPS: 進行方向の単位
	// ======================================================================
	/**
	 * {@link IFD#GPS} の進行方向の単位を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_TRACK_REF = 0x000E;

	// ======================================================================
	// GPS: 進行方向 (数値)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の進行方向 (数値)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_TRACK = 0x000F;

	// ======================================================================
	// GPS: 撮影した画像の方向の単位
	// ======================================================================
	/**
	 * {@link IFD#GPS} の撮影した画像の方向の単位を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_IMG_DIRECTION_REF = 0x0010;

	// ======================================================================
	// GPS: 撮影した画像の方向（数値）
	// ======================================================================
	/**
	 * {@link IFD#GPS} の撮影した画像の方向（数値）を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_IMG_DIRECTION = 0x0011;

	// ======================================================================
	// GPS: 測位に用いた地図データ
	// ======================================================================
	/**
	 * {@link IFD#GPS} の測位に用いた地図データを示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_MAP_DATUM = 0x0012;

	// ======================================================================
	// GPS: 目的地の北緯(N) or 南緯(S)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の目的地の北緯(N) or 南緯(S)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DEST_LATITUDE_REF = 0x0013;

	// ======================================================================
	// GPS: 目的地の緯度（数値）
	// ======================================================================
	/**
	 * {@link IFD#GPS} の目的地の緯度（数値）を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DEST_LATITUDE = 0x0014;

	// ======================================================================
	// GPS: 目的地の東経(E) or 西経(W)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の目的地の東経(E) or 西経(W)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DEST_LONGITUDE_REF = 0x0015;

	// ======================================================================
	// GPS: 目的地の経度 (数値)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の目的地の経度 (数値)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DEST_LONGITUDE = 0x0016;

	// ======================================================================
	// GPS: 目的地の方角の単位
	// ======================================================================
	/**
	 * {@link IFD#GPS} の目的地の方角の単位を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DEST_BEARING_REF = 0x0017;

	// ======================================================================
	// GPS: 目的の方角 (数値)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の目的の方角 (数値)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DEST_BEARING = 0x0018;

	// ======================================================================
	// GPS: 目的地までの距離の単位
	// ======================================================================
	/**
	 * {@link IFD#GPS} の目的地までの距離の単位を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DEST_DISTANCE_REF = 0x0019;

	// ======================================================================
	// GPS: 目的地までの距離 (数値)
	// ======================================================================
	/**
	 * {@link IFD#GPS} の目的地までの距離 (数値)を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DEST_DISTANCE = 0x001A;

	// ======================================================================
	// GPS: 位置確定方法
	// ======================================================================
	/**
	 * {@link IFD#GPS} の位置確定方法を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_PROCESSING_METHOD = 0x001B;

	// ======================================================================
	// GPS: エリア情報
	// ======================================================================
	/**
	 * {@link IFD#GPS} のエリア情報を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_AREA_INFORMATION = 0x001C;

	// ======================================================================
	// GPS: UTC 相対時刻
	// ======================================================================
	/**
	 * {@link IFD#GPS} のUTC 相対時刻を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DATE_STAMP = 0x001D;

	// ======================================================================
	// GPS: 誤差
	// ======================================================================
	/**
	 * {@link IFD#GPS} の誤差を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int GPS_DIFFERENTIAL = 0x001E;

	// ======================================================================
	// 互換性識別子
	// ======================================================================
	/**
	 * {@link IFD#INTROP} の互換性識別子を示すタグ値 {@value} です。
	 * <p>
	*/
	public static final int INTROP_INTEROPERABIL_INDEX = 0x0001;

}
