/* **************************************************************************
 * Copyright (C) 2008 BJoRFUAN. All Right Reserved
 * **************************************************************************
 * This module, contains source code, binary and documentation, is in the
 * BSD License, and comes with NO WARRANTY.
 * 
 *                                                 torao <torao@bjorfuan.com>
 *                                                       http://www.moyo.biz/
 * $Id: IFD.java,v 1.3 2008/08/11 17:30:37 torao Exp $
*/
package org.koiroha.fixez;



// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// IFD: IDF 識別子列挙
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/**
 * IDF 識別子を表す列挙型です。
 * <p>
 * @version fixez 1.0 - $Revision: 1.3 $ $Date: 2008/08/11 17:30:37 $
 * @author <a href="mailto:torao@mars.dti.ne.jp">torao</a>
 * @since fixez 1.0 - 2008/08/11
 */
public enum IFD {

	// ======================================================================
	// [IFD] 0th IFD
	// ======================================================================
	/**
	 * 0th IFD を表す識別子です。
	 * <p>
	*/
	I0TH(Tag.IFD_0TH, "0th"),

	// ======================================================================
	// [IFD] 1st IFD
	// ======================================================================
	/**
	 * 1st IFD を表す識別子です。
	 * <p>
	*/
	I1ST(Tag.IFD_1ST, "1st"),

	// ======================================================================
	// [IFD] Exif IFD
	// ======================================================================
	/**
	 * Exif IFD を表す識別子です。
	 * <p>
	*/
	EXIF(Tag.IFD_EXIF, "exif"),

	// ======================================================================
	// [IFD] GPS IFD
	// ======================================================================
	/**
	 * GPS IFD を表す識別子です。
	 * <p>
	*/
	GPS(Tag.IFD_GPS, "gps"),

	// ======================================================================
	// [IFD] 互換性 IFD
	// ======================================================================
	/**
	 * 互換性 IFD を表す識別子です。
	 * <p>
	*/
	INTROP(Tag.IFD_INTROP, "introp"),

	;

	// ======================================================================
	// 数値
	// ======================================================================
	/**
	 * この IFD 識別子の値です。
	 * <p>
	*/
	private final int num;

	// ======================================================================
	// ラベル
	// ======================================================================
	/**
	 * この IFD 識別子のラベルです。
	 * <p>
	*/
	private final String label;

	// ======================================================================
	// コンストラクタ
	// ======================================================================
	/**
	 * 数値を指定して構築を行います。
	 * <p>
	 * @param num IFD 識別子の値
	 * @param label IFd 識別子のラベル
	*/
	private IFD(int num, String label){
		assert(label.matches("[a-z0-9]+"));
		this.num = num;
		this.label = label;
		return;
	}

	// ======================================================================
	// 値の参照
	// ======================================================================
	/**
	 * この IFD 識別子の 16 ビットタグ値を参照します。
	 * <p>
	 * @return IFD 識別子の値
	*/
	public int getDigit(){
		return num;
	}

	// ======================================================================
	// ラベルの参照
	// ======================================================================
	/**
	 * この IFD 識別子のラベルを参照します。ラベル文字列は半角英数で構成され
	 * る、人またはプログラムが認識できる文字です。
	 * <p>
	 * @return IFD 識別子のラベル
	*/
	public String getLabel(){
		return label;
	}

	// ======================================================================
	// インスタンスの参照
	// ======================================================================
	/**
	 * 指定された IFD 識別子の値に対するインスタンスを参照します。該当する
	 * 定数が定義されていない場合は null を返します。
	 * <p>
	 * @param num IFD 識別子の値
	 * @return IFD 識別子
	*/
	public static IFD valueOf(int num){
		for(IFD ifd: IFD.values()){
			if(ifd.getDigit() == num){
				return ifd;
			}
		}
		return null;
	}

}
