/* **************************************************************************
 * Copyright (C) 2008 BJoRFUAN. All Right Reserved
 * **************************************************************************
 * This module, contains source code, binary and documentation, is in the
 * BSD License, and comes with NO WARRANTY.
 * 
 *                                                 torao <torao@bjorfuan.com>
 *                                                       http://www.moyo.biz/
 * $Id: ExifFormatException.java,v 1.1 2008/08/11 17:29:04 torao Exp $
*/
package org.koiroha.fixez;



// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ExifFormatException: Exif フォーマット例外
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/**
 * Exif フォーマットに関するの例外クラスです。
 * <p>
 * @version $Revision: 1.1 $
 * @author torao
 * @since 2008/08/11 Java SE 6
 */
public class ExifFormatException extends Exception {

	// ======================================================================
	// シリアルバージョン
	// ======================================================================
	/**
	 * このクラスのシリアルバージョンです。
	 * <p>
	*/
	private static final long serialVersionUID = 1L;

	// ======================================================================
	// コンストラクタ
	// ======================================================================
	/**
	 * メッセージの付かない例外を構築します。
	 * <p>
	 */
	public ExifFormatException() {
		return;
	}

	// ======================================================================
	// コンストラクタ
	// ======================================================================
	/**
	 * 指定されたメッセージつきの例外を構築します。
	 * <p>
	 * @param message 例外メッセージ
	 */
	public ExifFormatException(String message) {
		super(message);
		return;
	}

	// ======================================================================
	// コンストラクタ
	// ======================================================================
	/**
	 * 指定された原因の例外付きの例外を構築します。
	 * <p>
	 * @param cause 原因の例外
	 */
	public ExifFormatException(Throwable cause) {
		super(cause);
		return;
	}

	// ======================================================================
	// コンストラクタ
	// ======================================================================
	/**
	 * 例外メッセージと原因の例外を指定して構築を行います。
	 * <p>
	 * @param message 例外メッセージ
	 * @param cause 原因の例外
	 */
	public ExifFormatException(String message, Throwable cause) {
		super(message, cause);
		return;
	}

}
