/* **************************************************************************
 * Copyright (C) 2008 BJoRFUAN. All Right Reserved
 * **************************************************************************
 * This module, contains source code, binary and documentation, is in the
 * BSD License, and comes with NO WARRANTY.
 * 
 *                                                 torao <torao@bjorfuan.com>
 *                                                       http://www.moyo.biz/
 * $Id: ByteBufferInputStream.java,v 1.3 2008/08/11 17:26:49 torao Exp $
*/
package org.koiroha.fixez;

import java.io.*;
import java.nio.ByteBuffer;



// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ByteBufferInputStream: ByteBuffer 入力ストリーム
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/**
 * {@link ByteBuffer} のインスタンスを入力ストリームとして使用するためのアダプタです。
 * <p>
 * @version fixez 1.0 - $Revision: 1.3 $ $Date: 2008/08/11 17:26:49 $
 * @author <a href="mailto:torao@mars.dti.ne.jp">torao</a>
 * @since fixez 1.0 - 2008/08/11
 */
class ByteBufferInputStream extends InputStream {

	// ======================================================================
	// バイトバッファ
	// ======================================================================
	/**
	 * 読み込みに使用するバイトバッファです。
	 * <p>
	 */
	private final ByteBuffer buffer;

	// ======================================================================
	// バイトバッファ
	// ======================================================================
	/**
	 * 読み込みに使用するバイトバッファです。
	 * <p>
	 */
	private int mark = -1;

	// ======================================================================
	// コンストラクタ
	// ======================================================================
	/**
	 * 指定されたバイトバッファを使用する入力ストリームを作成します。
	 * <p>
	 * @param buffer バイトバッファ
	 */
	public ByteBufferInputStream(ByteBuffer buffer) {
		this.buffer = buffer;
		return;
	}

	// ======================================================================
	// バイトの読み込み
	// ======================================================================
	/**
	 * バイト値を読み込みます。
	 * <p>
	 * @return バイト値
	 */
	@Override
	public int read() {
		if(buffer.hasRemaining()){
			return (buffer.get() & 0xFF);
		}
		return -1;
	}

	// ======================================================================
	// マークのサポート
	// ======================================================================
	/**
	 * true を返します。
	 * <p>
	 * @return true
	*/
	@Override
	public boolean markSupported() {
		return true;
	}

	// ======================================================================
	// マークの設定
	// ======================================================================
	/**
	 * 現在の位置にマークを設定します。
	 * <p>
	 * @param readlimit マーク上限
	*/
	@Override
	public void mark(int readlimit) {
		assert(mark < 0);
		this.mark = buffer.position();
		return;
	}

	// ======================================================================
	// マークのリセット
	// ======================================================================
	/**
	 * 読み出しをマークした位置に戻します。
	 * <p>
	*/
	@Override
	public void reset() {
		buffer.position(mark);
		mark = -1;
		return;
	}

}
