/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.fixez;

import java.io.Serializable;

public final class Rational
extends Number
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Rational NaN = new Rational(0L, 0L);
    public static final Rational ZERO = new Rational(0L, 1L);
    private static final Rational POSITIVE_INFINITY = new Rational(1L, 0L);
    private static final Rational NEGATIVE_INFINITY = new Rational(-1L, 0L);
    private final long numerator;
    private final long denominator;

    public Rational(long l, long l2) {
        if (l < 0L && l2 < 0L) {
            l = Math.abs(l);
            l2 = Math.abs(l2);
        } else if (l2 < 0L) {
            l = -l;
            l2 = -l2;
        }
        this.numerator = l;
        this.denominator = l2;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public Rational reduction() {
        long l = this.getNumerator();
        long l2 = this.getDenominator();
        if (l == 0L) {
            return l2 == 0L ? NaN : ZERO;
        }
        if (l2 == 0L) {
            return l < 0L ? NEGATIVE_INFINITY : POSITIVE_INFINITY;
        }
        while ((l & 1L) == 0L && (l2 & 1L) == 0L) {
            l >>>= 1;
            l2 >>>= 1;
        }
        long l3 = Math.max(Math.min(Math.abs(l), Math.abs(l2)), 65536L);
        int n = 3;
        while ((long)n <= l3 && l > 1L && l2 > 1L) {
            if (l % (long)n == 0L && l2 % (long)n == 0L) {
                l /= (long)n;
                l2 /= (long)n;
                n -= 2;
            }
            n += 2;
        }
        if (l == this.getNumerator()) {
            return this;
        }
        return new Rational(l, l2);
    }

    public Rational abs() {
        assert (this.denominator >= 0L);
        if (this.getNumerator() >= 0L) {
            return this;
        }
        return new Rational(-this.getNumerator(), this.getDenominator());
    }

    public boolean isNaN() {
        return this.getNumerator() == 0L && this.getDenominator() == 0L;
    }

    public boolean isNegative() {
        assert (this.denominator >= 0L);
        return this.getNumerator() < 0L;
    }

    public boolean isPositiveInfinity() {
        return this.getDenominator() == 0L && this.getNumerator() > 0L;
    }

    public boolean isNegativeInfinity() {
        return this.getDenominator() == 0L && this.getNumerator() < 0L;
    }

    public int intValue() {
        return (int)this.doubleValue();
    }

    public long longValue() {
        return (long)this.doubleValue();
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public double doubleValue() {
        if (this.denominator != 0L) {
            return (double)this.numerator / (double)this.denominator;
        }
        if (this.numerator == 0L) {
            return Double.NaN;
        }
        if (this.numerator < 0L) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.POSITIVE_INFINITY;
    }

    public int hashCode() {
        return (int)(this.getNumerator() + this.getDenominator());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rational)) {
            return false;
        }
        Rational rational = (Rational)object;
        return this.getNumerator() == rational.getNumerator() && this.getDenominator() == rational.getDenominator();
    }

    public String toString() {
        long l = this.getNumerator();
        long l2 = this.getDenominator();
        if (l2 == 0L) {
            if (l == 0L) {
                return String.valueOf(Double.NaN);
            }
            if (l > 0L) {
                return String.valueOf(Double.POSITIVE_INFINITY);
            }
            return String.valueOf(Double.NEGATIVE_INFINITY);
        }
        if (l2 == 1L) {
            return String.valueOf(l);
        }
        if (l == 0L) {
            return "0";
        }
        return l + "/" + l2;
    }
}

