/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.fixez;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.koiroha.fixez.Exif;
import org.koiroha.fixez.ExifField;
import org.koiroha.fixez.IFD;
import org.koiroha.fixez.Rational;

public final class Photograph {
    private static final Logger logger = Logger.getLogger(Photograph.class.getName());
    private final Exif exif;

    public Photograph(Exif exif) {
        this.exif = exif;
    }

    public Date getDate() {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        ExifField exifField = this.exif.getField(IFD.EXIF, 36867);
        if (exifField == null) {
            exifField = this.exif.getField(IFD.EXIF, 36868);
        }
        if (exifField == null) {
            exifField = this.exif.getField(IFD.I0TH, 306);
        }
        if (exifField != null) {
            try {
                date = simpleDateFormat.parse(exifField.getString());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public String getMake() {
        ExifField exifField = this.exif.getField(IFD.I0TH, 271);
        if (exifField == null) {
            return null;
        }
        return exifField.getString().trim();
    }

    public String getModel() {
        ExifField exifField = this.exif.getField(IFD.I0TH, 272);
        if (exifField == null) {
            return null;
        }
        return exifField.getString().trim();
    }

    public Rational getExposureTime() {
        ExifField exifField = this.exif.getField(IFD.EXIF, 33434);
        if (exifField == null) {
            return null;
        }
        return exifField.getRational();
    }

    public Rational getExposureBiasValue() {
        ExifField exifField = this.exif.getField(IFD.EXIF, 37380);
        if (exifField == null) {
            return null;
        }
        return exifField.getRational();
    }

    public double getFNumber() {
        ExifField exifField = this.exif.getField(IFD.EXIF, 33437);
        if (exifField == null) {
            return Double.NaN;
        }
        return exifField.getDouble();
    }

    public double getFocalLength() {
        ExifField exifField = this.exif.getField(IFD.EXIF, 37386);
        if (exifField == null) {
            return Double.NaN;
        }
        return exifField.getDouble();
    }

    public int getISOSpeedRatings() {
        ExifField exifField = this.exif.getField(IFD.EXIF, 34855);
        if (exifField == null) {
            return -1;
        }
        return exifField.getInt();
    }

    public Flash getFlash() {
        ExifField exifField = this.exif.getField(IFD.EXIF, 37385);
        if (exifField == null) {
            return null;
        }
        Flash flash = Flash.valueOf(exifField.getInt() & 7);
        if (flash == null) {
            logger.warning("unsupported flash: 0x" + Integer.toHexString(exifField.getInt()) + ": " + exifField + ": " + exifField.getTagLabel());
            return null;
        }
        return flash;
    }

    public LightSource getLightSource() {
        ExifField exifField = this.exif.getField(IFD.EXIF, 37384);
        if (exifField == null) {
            return LightSource.UNKNOWN;
        }
        LightSource lightSource = LightSource.valueOf(exifField.getInt());
        if (lightSource == null) {
            logger.warning("unsupported light-source: 0x" + Integer.toHexString(exifField.getInt()));
            return LightSource.UNKNOWN;
        }
        return lightSource;
    }

    public MeteringMode getMeteringMode() {
        ExifField exifField = this.exif.getField(IFD.EXIF, 37383);
        if (exifField == null) {
            return MeteringMode.UNKNOWN;
        }
        MeteringMode meteringMode = MeteringMode.valueOf(exifField.getInt());
        if (meteringMode == null) {
            logger.warning("unsupported metering-mode: 0x" + Integer.toHexString(exifField.getInt()));
            return MeteringMode.UNKNOWN;
        }
        return meteringMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MeteringMode {
        UNKNOWN(0, "\u4e0d\u660e"),
        AVERAGE(1, "\u5e73\u5747"),
        CENTER_WEIGHTED_AVERAGE(2, "\u4e2d\u592e\u91cd\u70b9"),
        SPOT(3, "\u30b9\u30dd\u30c3\u30c8"),
        MULTI_SPOT(4, "\u30de\u30eb\u30c1\u30b9\u30dd\u30c3\u30c8"),
        MULTI_SEGMENT(5, "\u5206\u5272\u6e2c\u5149"),
        PARTIAL(6, "\u90e8\u5206\u6e2c\u5149"),
        OTHER(255, "\u305d\u306e\u4ed6");

        private final int value;
        private final String label;

        private MeteringMode(int n2, String string2) {
            this.value = n2;
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }

        public static MeteringMode valueOf(int n) {
            for (MeteringMode meteringMode : MeteringMode.values()) {
                if (meteringMode.value != n) continue;
                return meteringMode;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LightSource {
        UNKNOWN(0, "\u4e0d\u660e"),
        DAYLIGHT(1, "\u663c\u5149"),
        FLUORESCENT(2, "\u86cd\u5149\u706f"),
        TUNGSTEN(3, "\u30bf\u30f3\u30b0\u30b9\u30c6\u30f3"),
        FLASH(10, "\u30d5\u30e9\u30c3\u30b7\u30e5"),
        STANdARD_LIGHT_A(17, "\u6a19\u6e96\u5149 A"),
        STANDARD_LIGHT_B(18, "\u6a19\u6e96\u5149 B"),
        STANDARD_LIGHT_C(19, "\u6a19\u6e96\u5149 C"),
        D55(20, "D55"),
        D65(21, "D65"),
        D75(22, "D75"),
        OTHER(255, "\u305d\u306e\u4ed6");

        private final int value;
        private final String label;

        private LightSource(int n2, String string2) {
            this.value = n2;
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }

        public static LightSource valueOf(int n) {
            for (LightSource lightSource : LightSource.values()) {
                if (lightSource.value != n) continue;
                return lightSource;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flash {
        NOT_FIRED(0, false, "\u306a\u3057"),
        FIRED(1, true, "\u3042\u308a"),
        RETURN_LIGHT_NOT_DETECTED(5, true, "\u3042\u308a (\u53cd\u5c04\u5149\u672a\u691c\u51fa)"),
        RETURN_LIGHT_DETECTED(7, true, "\u3042\u308a (\u53cd\u5c04\u5149\u691c\u51fa)");

        private final int value;
        private final boolean fired;
        private final String label;

        private Flash(int n2, boolean bl, String string2) {
            this.value = n2;
            this.fired = bl;
            this.label = string2;
        }

        public boolean isFired() {
            return this.fired;
        }

        public String getLabel() {
            return this.label;
        }

        public static Flash valueOf(int n) {
            for (Flash flash : Flash.values()) {
                if (flash.value != n) continue;
                return flash;
            }
            return null;
        }
    }
}

