/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.fixez;

import java.text.MessageFormat;
import org.koiroha.fixez.Exif;
import org.koiroha.fixez.ExifField;
import org.koiroha.fixez.IFD;
import org.koiroha.fixez.Rational;

public final class GPS {
    private final Exif exif;

    public GPS(Exif exif) {
        this.exif = exif;
    }

    public Degree getLatitude() {
        ExifField exifField = this.exif.getField(IFD.GPS, 1);
        ExifField exifField2 = this.exif.getField(IFD.GPS, 2);
        if (exifField == null || exifField2 == null) {
            return null;
        }
        double d = GPS.getDegree(exifField2.getRationals());
        if (exifField.getString().equalsIgnoreCase("N")) {
            d = Math.abs(d);
        } else if (exifField.getString().equalsIgnoreCase("S")) {
            d = -Math.abs(d);
        } else {
            return null;
        }
        return new Degree(d);
    }

    public Degree getLongitude() {
        ExifField exifField = this.exif.getField(IFD.GPS, 3);
        ExifField exifField2 = this.exif.getField(IFD.GPS, 4);
        if (exifField == null || exifField2 == null) {
            return null;
        }
        double d = GPS.getDegree(exifField2.getRationals());
        if (exifField.getString().equalsIgnoreCase("E")) {
            d = Math.abs(d);
        } else if (exifField.getString().equalsIgnoreCase("W")) {
            d = -Math.abs(d);
        } else {
            return null;
        }
        return new Degree(d);
    }

    public String getDatum() {
        ExifField exifField = this.exif.getField(IFD.GPS, 18);
        if (exifField == null) {
            return null;
        }
        return exifField.getString();
    }

    private static double getDegree(Rational[] rationalArray) {
        assert (rationalArray.length == 3);
        return rationalArray[0].doubleValue() + rationalArray[1].doubleValue() / 60.0 + rationalArray[2].doubleValue() / 60.0 / 60.0;
    }

    public static final class Degree {
        private final double degree;

        public Degree(double d) {
            this.degree = d;
        }

        public int getDegree() {
            return (int)this.degree;
        }

        public int getMinute() {
            return (int)(Math.abs(this.degree) * 60.0 % 60.0);
        }

        public double getSecond() {
            return Math.abs(this.degree) * 60.0 * 60.0 % 60.0;
        }

        public double toDouble() {
            return this.degree;
        }

        public int hashCode() {
            return (int)(this.degree * 60.0 * 60.0);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Degree)) {
                return false;
            }
            return this.toDouble() == ((Degree)object).toDouble();
        }

        public String toString() {
            return MessageFormat.format("{0,number,0}:{1,number,00}:{2,number,00.00}", this.getDegree(), this.getMinute(), this.getSecond());
        }
    }
}

