/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.fixez;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.koiroha.fixez.IFD;
import org.koiroha.fixez.Rational;
import org.koiroha.fixez.Type;

public class ExifField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, String> FIELD_NAME = new HashMap<Integer, String>();
    private static final Map<Integer, String> FIELD_LABEL = new HashMap<Integer, String>();
    private final IFD ifd;
    private final int tag;
    private final Type type;
    private final int count;
    private final String text;
    private final byte[] binary;
    private final Number[] number;

    ExifField(IFD iFD, int n, Type type, int n2, String string, byte[] byArray, Number[] numberArray) {
        this.ifd = iFD;
        this.tag = n;
        this.type = type;
        this.count = n2;
        this.text = string;
        this.binary = byArray;
        this.number = numberArray;
    }

    public IFD getIFD() {
        return this.ifd;
    }

    public int getTag() {
        return this.tag;
    }

    public String getTagName() {
        int n = ExifField.getKey(this.ifd, this.tag);
        String string = FIELD_NAME.get(n);
        if (string == null) {
            return ExifField.hex(this.getIFD().getDigit()) + "." + ExifField.hex(this.getTag());
        }
        return string;
    }

    public String getTagLabel() {
        int n = ExifField.getKey(this.ifd, this.tag);
        String string = FIELD_LABEL.get(n);
        if (string == null) {
            return "";
        }
        return string;
    }

    public Type getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public String getString() {
        return this.text;
    }

    public int getInt() {
        if (this.number == null || this.number.length == 0) {
            return 0;
        }
        return this.number[0].intValue();
    }

    public int[] getInts() {
        if (this.number == null || this.number.length == 0) {
            return new int[0];
        }
        int[] nArray = new int[this.number.length];
        for (int i = 0; i < this.number.length; ++i) {
            nArray[i] = this.number[i].intValue();
        }
        return nArray;
    }

    public double getDouble() {
        double[] dArray = this.getDoubles();
        if (dArray.length == 0) {
            return Double.NaN;
        }
        return dArray[0];
    }

    public double[] getDoubles() {
        if (this.number == null || this.number.length == 0) {
            return new double[0];
        }
        double[] dArray = new double[this.number.length];
        for (int i = 0; i < this.number.length; ++i) {
            dArray[i] = this.number[i].doubleValue();
        }
        return dArray;
    }

    public Rational getRational() {
        Rational[] rationalArray = this.getRationals();
        if (rationalArray.length == 0) {
            return Rational.NaN;
        }
        return rationalArray[0];
    }

    public Rational[] getRationals() {
        if (this.number == null || this.number.length == 0 || this.number[0] instanceof Float || this.number[0] instanceof Double) {
            return new Rational[0];
        }
        Rational[] rationalArray = new Rational[this.number.length];
        for (int i = 0; i < this.number.length; ++i) {
            if (this.number[i] instanceof Rational) {
                rationalArray[i] = (Rational)this.number[i];
                continue;
            }
            assert (this.number[i] instanceof Byte || this.number[i] instanceof Short || this.number[i] instanceof Integer || this.number[i] instanceof Long) : this.number[i].getClass().getSimpleName();
            rationalArray[i] = new Rational(this.number[i].longValue(), 1L);
        }
        return rationalArray;
    }

    public byte[] getBinary() {
        return (byte[])this.binary.clone();
    }

    public String toString() {
        return this.getIFD().getLabel() + ":" + ExifField.hex(this.getTag()) + "[" + this.getString() + "]";
    }

    private static void define(IFD iFD, int n, String string, String string2) {
        assert (string.matches("[a-zA-Z0-9]+")) : string;
        int n2 = ExifField.getKey(iFD, n);
        FIELD_NAME.put(n2, string);
        FIELD_LABEL.put(n2, string2);
    }

    private static int getKey(IFD iFD, int n) {
        return (iFD.getDigit() & 0xFFFF) << 16 | n & 0xFFFF;
    }

    private static String hex(int n) {
        return String.format("%04X", n);
    }

    static {
        ExifField.define(IFD.I0TH, 256, "ImageWidth", "\u753b\u50cf\u306e\u5e45");
        ExifField.define(IFD.I0TH, 257, "ImageLength", "\u753b\u50cf\u306e\u9ad8\u3055");
        ExifField.define(IFD.I0TH, 258, "BitsPerSample", "\u753b\u50cf\u306e\u30d3\u30c3\u30c8\u306e\u6df1\u3055");
        ExifField.define(IFD.I0TH, 259, "Compression", "\u5727\u7e2e\u306e\u7a2e\u985e");
        ExifField.define(IFD.I0TH, 262, "PhotometricInterpretation", "\u753b\u7d20\u69cb\u6210");
        ExifField.define(IFD.I0TH, 274, "Orientation", "\u753b\u50cf\u65b9\u5411");
        ExifField.define(IFD.I0TH, 277, "SamplesPerPixel", "\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u6570");
        ExifField.define(IFD.I0TH, 284, "PlanarConfiguration", "\u753b\u50cf\u30c7\u30fc\u30bf\u306e\u4e26\u3073");
        ExifField.define(IFD.I0TH, 530, "YCbCrSubSampling", "YCC \u306e\u753b\u7d20\u69cb\u6210\uff08C \u306e\u9593\u5f15\u304d\u7387\uff09");
        ExifField.define(IFD.I0TH, 531, "YCbCrPositioning", "YCC \u306e\u753b\u7d20\u69cb\u6210\uff08Y \u3068C \u306e\u4f4d\u7f6e\uff09");
        ExifField.define(IFD.I0TH, 282, "XResolution", "\u753b\u50cf\u306e\u5e45\u306e\u89e3\u50cf\u5ea6");
        ExifField.define(IFD.I0TH, 283, "YResolution", "\u753b\u50cf\u306e\u9ad8\u3055\u306e\u89e3\u50cf\u5ea6");
        ExifField.define(IFD.I0TH, 296, "ResolutionUnit", "\u753b\u50cf\u306e\u5e45\u3068\u9ad8\u3055\u306e\u89e3\u50cf\u5ea6\u306e\u5358\u4f4d");
        ExifField.define(IFD.I0TH, 273, "StripOffsets", "\u753b\u50cf\u30c7\u30fc\u30bf\u306e\u30ed\u30b1\u30fc\u30b7\u30e7\u30f3");
        ExifField.define(IFD.I0TH, 278, "RowsPerStrip", "\u30b9\u30c8\u30ea\u30c3\u30d7\u4e2d\u306e\u30e9\u30a4\u30f3\u6570");
        ExifField.define(IFD.I0TH, 279, "StripByteCounts", "\u30b9\u30c8\u30ea\u30c3\u30d7\u306e\u30c7\u30fc\u30bf\u91cf");
        ExifField.define(IFD.I0TH, 513, "JPEGInterchangeFormat", "JPEG \u306eSOI \u3078\u306e\u30aa\u30d5\u30bb\u30c3\u30c8");
        ExifField.define(IFD.I0TH, 514, "JPEGInterchangeFormatLength", "JPEG \u30c7\u30fc\u30bf\u306e\u30d0\u30a4\u30c8\u6570");
        ExifField.define(IFD.I0TH, 301, "TransferFunction", "\u518d\u751f\u968e\u8abf\u30ab\u30fc\u30d6\u7279\u6027");
        ExifField.define(IFD.I0TH, 318, "WhitePoint", "\u53c2\u7167\u767d\u8272\u70b9\u306e\u8272\u5ea6\u5ea7\u6a19\u5024");
        ExifField.define(IFD.I0TH, 319, "PrimaryChromaticities", "\u539f\u8272\u306e\u8272\u5ea6\u5ea7\u6a19\u5024");
        ExifField.define(IFD.I0TH, 529, "YCbCrCoefficients", "\u8272\u5909\u63db\u30de\u30c8\u30ea\u30af\u30b9\u4fc2\u6570");
        ExifField.define(IFD.I0TH, 532, "ReferenceBlackWhite", "\u53c2\u7167\u9ed2\u8272\u70b9\u5024\u3068\u53c2\u7167\u767d\u8272\u70b9\u5024");
        ExifField.define(IFD.I0TH, 306, "DateTime", "\u30d5\u30a1\u30a4\u30eb\u5909\u66f4\u65e5\u6642");
        ExifField.define(IFD.I0TH, 270, "ImageDescription", "\u753b\u50cf\u30bf\u30a4\u30c8\u30eb");
        ExifField.define(IFD.I0TH, 271, "Make", "\u753b\u50cf\u5165\u529b\u6a5f\u5668\u306e\u30e1\u30fc\u30ab\u30fc\u540d");
        ExifField.define(IFD.I0TH, 272, "Model", "\u753b\u50cf\u5165\u529b\u6a5f\u5668\u306e\u30e2\u30c7\u30eb\u540d");
        ExifField.define(IFD.I0TH, 305, "Software", "\u4f7f\u7528\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u540d");
        ExifField.define(IFD.I0TH, 315, "Artist", "\u4f5c\u8005\u540d");
        ExifField.define(IFD.I0TH, 33432, "Copyright", "\u64ae\u5f71\u8457\u4f5c\u6a29\u8005/\u7de8\u96c6\u8457\u4f5c\u6a29\u8005");
        ExifField.define(IFD.I1ST, 256, "ImageWidth", "\u753b\u50cf\u306e\u5e45");
        ExifField.define(IFD.I1ST, 257, "ImageLength", "\u753b\u50cf\u306e\u9ad8\u3055");
        ExifField.define(IFD.I1ST, 258, "BitsPerSample", "\u753b\u50cf\u306e\u30d3\u30c3\u30c8\u306e\u6df1\u3055");
        ExifField.define(IFD.I1ST, 259, "Compression", "\u5727\u7e2e\u306e\u7a2e\u985e");
        ExifField.define(IFD.I1ST, 262, "PhotometricInterpretation", "\u753b\u7d20\u69cb\u6210");
        ExifField.define(IFD.I1ST, 274, "Orientation", "\u753b\u50cf\u65b9\u5411");
        ExifField.define(IFD.I1ST, 277, "SamplesPerPixel", "\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u6570");
        ExifField.define(IFD.I1ST, 284, "PlanarConfiguration", "\u753b\u50cf\u30c7\u30fc\u30bf\u306e\u4e26\u3073");
        ExifField.define(IFD.I1ST, 530, "YCbCrSubSampling", "YCC \u306e\u753b\u7d20\u69cb\u6210\uff08C \u306e\u9593\u5f15\u304d\u7387\uff09");
        ExifField.define(IFD.I1ST, 531, "YCbCrPositioning", "YCC \u306e\u753b\u7d20\u69cb\u6210\uff08Y \u3068C \u306e\u4f4d\u7f6e\uff09");
        ExifField.define(IFD.I1ST, 282, "XResolution", "\u753b\u50cf\u306e\u5e45\u306e\u89e3\u50cf\u5ea6");
        ExifField.define(IFD.I1ST, 283, "YResolution", "\u753b\u50cf\u306e\u9ad8\u3055\u306e\u89e3\u50cf\u5ea6");
        ExifField.define(IFD.I1ST, 296, "ResolutionUnit", "\u753b\u50cf\u306e\u5e45\u3068\u9ad8\u3055\u306e\u89e3\u50cf\u5ea6\u306e\u5358\u4f4d");
        ExifField.define(IFD.I1ST, 273, "StripOffsets", "\u753b\u50cf\u30c7\u30fc\u30bf\u306e\u30ed\u30b1\u30fc\u30b7\u30e7\u30f3");
        ExifField.define(IFD.I1ST, 278, "RowsPerStrip", "\u30b9\u30c8\u30ea\u30c3\u30d7\u4e2d\u306e\u30e9\u30a4\u30f3\u6570");
        ExifField.define(IFD.I1ST, 279, "StripByteCounts", "\u30b9\u30c8\u30ea\u30c3\u30d7\u306e\u30c7\u30fc\u30bf\u91cf");
        ExifField.define(IFD.I1ST, 513, "JPEGInterchangeFormat", "JPEG \u306eSOI \u3078\u306e\u30aa\u30d5\u30bb\u30c3\u30c8");
        ExifField.define(IFD.I1ST, 514, "JPEGInterchangeFormatLength", "JPEG \u30c7\u30fc\u30bf\u306e\u30d0\u30a4\u30c8\u6570");
        ExifField.define(IFD.I1ST, 301, "TransferFunction", "\u518d\u751f\u968e\u8abf\u30ab\u30fc\u30d6\u7279\u6027");
        ExifField.define(IFD.I1ST, 318, "WhitePoint", "\u53c2\u7167\u767d\u8272\u70b9\u306e\u8272\u5ea6\u5ea7\u6a19\u5024");
        ExifField.define(IFD.I1ST, 319, "PrimaryChromaticities", "\u539f\u8272\u306e\u8272\u5ea6\u5ea7\u6a19\u5024");
        ExifField.define(IFD.I1ST, 529, "YCbCrCoefficients", "\u8272\u5909\u63db\u30de\u30c8\u30ea\u30af\u30b9\u4fc2\u6570");
        ExifField.define(IFD.I1ST, 532, "ReferenceBlackWhite", "\u53c2\u7167\u9ed2\u8272\u70b9\u5024\u3068\u53c2\u7167\u767d\u8272\u70b9\u5024");
        ExifField.define(IFD.I1ST, 306, "DateTime", "\u30d5\u30a1\u30a4\u30eb\u5909\u66f4\u65e5\u6642");
        ExifField.define(IFD.I1ST, 270, "ImageDescription", "\u753b\u50cf\u30bf\u30a4\u30c8\u30eb");
        ExifField.define(IFD.I1ST, 271, "Make", "\u753b\u50cf\u5165\u529b\u6a5f\u5668\u306e\u30e1\u30fc\u30ab\u30fc\u540d");
        ExifField.define(IFD.I1ST, 272, "Model", "\u753b\u50cf\u5165\u529b\u6a5f\u5668\u306e\u30e2\u30c7\u30eb\u540d");
        ExifField.define(IFD.I1ST, 305, "Software", "\u4f7f\u7528\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u540d");
        ExifField.define(IFD.I1ST, 315, "Artist", "\u4f5c\u8005\u540d");
        ExifField.define(IFD.I1ST, 33432, "Copyright", "\u64ae\u5f71\u8457\u4f5c\u6a29\u8005/\u7de8\u96c6\u8457\u4f5c\u6a29\u8005");
        ExifField.define(IFD.EXIF, 36864, "ExifVersion", "Exif \u30d0\u30fc\u30b8\u30e7\u30f3");
        ExifField.define(IFD.EXIF, 40960, "FlashPixVersion", "\u5bfe\u5fdc\u30d5\u30e9\u30c3\u30b7\u30e5\u30d4\u30c3\u30af\u30b9\u30d0\u30fc\u30b8\u30e7\u30f3");
        ExifField.define(IFD.EXIF, 40961, "ColorSpace", "\u8272\u7a7a\u9593\u60c5\u5831");
        ExifField.define(IFD.EXIF, 37121, "ComponentsConfiguration", "\u5404\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u306e\u610f\u5473");
        ExifField.define(IFD.EXIF, 37122, "CompressedBitsPerPixel", "\u753b\u50cf\u5727\u7e2e\u30e2\u30fc\u30c9");
        ExifField.define(IFD.EXIF, 40962, "PixelXDimension", "\u5b9f\u52b9\u753b\u50cf\u5e45");
        ExifField.define(IFD.EXIF, 40963, "PixelYDimension", "\u5b9f\u52b9\u753b\u50cf\u9ad8\u3055");
        ExifField.define(IFD.EXIF, 37500, "MakerNote", "\u30e1\u30fc\u30ab\u30fc\u30ce\u30fc\u30c8");
        ExifField.define(IFD.EXIF, 37510, "UserComment", "\u30e6\u30fc\u30b6\u30fc\u30b3\u30e1\u30f3\u30c8");
        ExifField.define(IFD.EXIF, 40964, "RelatedSoundFile", "\u95a2\u9023\u97f3\u58f0\u30d5\u30a1\u30a4\u30eb");
        ExifField.define(IFD.EXIF, 36867, "DateTimeOriginal", "\u539f\u753b\u50cf\u30c7\u30fc\u30bf\u306e\u751f\u6210\u65e5\u6642");
        ExifField.define(IFD.EXIF, 36868, "DateTimeDigitized", "\u30c7\u30a3\u30b8\u30bf\u30eb\u30c7\u30fc\u30bf\u306e\u4f5c\u6210\u65e5\u6642");
        ExifField.define(IFD.EXIF, 37520, "SubSecTime", "DateTime \u306e\u30b5\u30d6\u30bb\u30c3\u30af");
        ExifField.define(IFD.EXIF, 37521, "SubSecTimeOriginal", "DateTimeOriginal \u306e\u30b5\u30d6\u30bb\u30c3\u30af");
        ExifField.define(IFD.EXIF, 37522, "SubSecTimeDigitized", "DateTimeDigitized \u306e\u30b5\u30d6\u30bb\u30c3\u30af");
        ExifField.define(IFD.EXIF, 40965, "InteroperabiliyIFDPointer", "\u4e92\u63db\u6027IFD \u3078\u306e\u30dd\u30a4\u30f3\u30bf");
        ExifField.define(IFD.EXIF, 33434, "ExposureTime", "\u9732\u51fa\u6642\u9593");
        ExifField.define(IFD.EXIF, 33437, "FNumber", "F \u30ca\u30f3\u30d0\u30fc");
        ExifField.define(IFD.EXIF, 34850, "ExposureProgram", "\u9732\u51fa\u30d7\u30ed\u30b0\u30e9\u30e0");
        ExifField.define(IFD.EXIF, 34852, "SpectralSensitivity", "\u30b9\u30da\u30af\u30c8\u30eb\u611f\u5ea6");
        ExifField.define(IFD.EXIF, 34855, "ISOSpeedRatings", "ISO \u30b9\u30d4\u30fc\u30c9\u30ec\u30fc\u30c8");
        ExifField.define(IFD.EXIF, 34856, "OECF", "\u5149\u96fb\u5909\u63db\u95a2\u6570");
        ExifField.define(IFD.EXIF, 37377, "ShutterSpeedValue", "\u30b7\u30e3\u30c3\u30bf\u30fc\u30b9\u30d4\u30fc\u30c9");
        ExifField.define(IFD.EXIF, 37378, "ApertureValue", "\u7d5e\u308a\u5024");
        ExifField.define(IFD.EXIF, 37379, "BrightnessValue", "\u8f1d\u5ea6\u5024");
        ExifField.define(IFD.EXIF, 37380, "ExposureBiasValue", "\u9732\u5149\u88dc\u6b63\u5024");
        ExifField.define(IFD.EXIF, 37381, "MaxApertureValue", "\u30ec\u30f3\u30ba\u6700\u5c0f\uff26\u5024");
        ExifField.define(IFD.EXIF, 37382, "SubjectDistance", "\u88ab\u5199\u4f53\u8ddd\u96e2");
        ExifField.define(IFD.EXIF, 37383, "MeteringMode", "\u6e2c\u5149\u65b9\u5f0f");
        ExifField.define(IFD.EXIF, 37384, "LightSource", "\u5149\u6e90");
        ExifField.define(IFD.EXIF, 37385, "Flash", "\u30d5\u30e9\u30c3\u30b7\u30e5");
        ExifField.define(IFD.EXIF, 37386, "FocalLength", "\u30ec\u30f3\u30ba\u7126\u70b9\u8ddd\u96e2");
        ExifField.define(IFD.EXIF, 41483, "FlashEnergy", "\u30d5\u30e9\u30c3\u30b7\u30e5\u5f37\u5ea6");
        ExifField.define(IFD.EXIF, 41484, "SpatialFrequencyResponse", "\u7a7a\u9593\u5468\u6ce2\u6570\u5fdc\u7b54");
        ExifField.define(IFD.EXIF, 41486, "FocalPlaneXResolution", "\u7126\u70b9\u9762\u306e\u5e45\u306e\u89e3\u50cf\u5ea6");
        ExifField.define(IFD.EXIF, 41487, "FocalPlaneYResolution", "\u7126\u70b9\u9762\u306e\u9ad8\u3055\u306e\u89e3\u50cf\u5ea6");
        ExifField.define(IFD.EXIF, 41488, "FocalPlaneResolutionUnit", "\u7126\u70b9\u9762\u89e3\u50cf\u5ea6\u5358\u4f4d");
        ExifField.define(IFD.EXIF, 41492, "SubjectLocation", "\u88ab\u5199\u4f53\u4f4d\u7f6e");
        ExifField.define(IFD.EXIF, 41493, "ExposureIndex", "\u9732\u51fa\u30a4\u30f3\u30c7\u30c3\u30af\u30b9");
        ExifField.define(IFD.EXIF, 41495, "SensingMethod", "\u30bb\u30f3\u30b5\u30fc\u65b9\u5f0f");
        ExifField.define(IFD.EXIF, 41728, "FileSource", "\u30d5\u30a1\u30a4\u30eb\u30bd\u30fc\u30b9");
        ExifField.define(IFD.EXIF, 41729, "SceneType", "\u30b7\u30fc\u30f3\u30bf\u30a4\u30d7");
        ExifField.define(IFD.EXIF, 41730, "CFAPattern", "CFA \u30d1\u30bf\u30fc\u30f3");
        ExifField.define(IFD.EXIF, 41985, "CustomRendered", "\u30ab\u30b9\u30bf\u30e0\u753b\u50cf\u51e6\u7406");
        ExifField.define(IFD.EXIF, 41986, "ExposureMode", "\u64ae\u5f71\u30e2\u30fc\u30c9");
        ExifField.define(IFD.EXIF, 41987, "WhiteBalance", "\u30db\u30ef\u30a4\u30c8\u30d0\u30e9\u30f3\u30b9\u30e2\u30fc\u30c9");
        ExifField.define(IFD.EXIF, 41988, "DigitalZoomRatio", "\u30c7\u30b8\u30bf\u30eb\u30ba\u30fc\u30e0");
        ExifField.define(IFD.EXIF, 41989, "FocalLengthIn35mmFilm", "\u30ec\u30f3\u30ba\u306e\u7126\u70b9\u8ddd\u96e2(35mm)");
        ExifField.define(IFD.EXIF, 41990, "SceneCaptureType", "\u30b7\u30fc\u30f3\u64ae\u5f71\u30bf\u30a4\u30d7");
        ExifField.define(IFD.EXIF, 41991, "GainControl", "\u30b2\u30a4\u30f3\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb");
        ExifField.define(IFD.EXIF, 41992, "Contrast", "\u30b3\u30f3\u30c8\u30e9\u30b9\u30c8");
        ExifField.define(IFD.EXIF, 41993, "Saturation", "\u5f69\u5ea6");
        ExifField.define(IFD.EXIF, 41994, "Sharpness", "\u30b7\u30e3\u30fc\u30d7\u30cd\u30b9");
        ExifField.define(IFD.EXIF, 41995, "DeviceSettingDescription", "\u30c7\u30d0\u30a4\u30b9\u8a2d\u5b9a\u8a73\u7d30");
        ExifField.define(IFD.EXIF, 41996, "SubjectDistanceRange", "\u88ab\u5199\u4f53\u306e\u8ddd\u96e2\u7bc4\u56f2");
        ExifField.define(IFD.EXIF, 42016, "ImageUniqueID", "\u753b\u50cf\u8b58\u5225ID");
        ExifField.define(IFD.EXIF, 42240, "Gamma", "\u30ac\u30f3\u30de\u5024");
        ExifField.define(IFD.GPS, 0, "GPSVersionID", "GPS \u30bf\u30b0\u306e\u30d0\u30fc\u30b8\u30e7\u30f3");
        ExifField.define(IFD.GPS, 1, "GPSLatitudeRef", "\u5317\u7def(N) or \u5357\u7def(S)");
        ExifField.define(IFD.GPS, 2, "GPSLatitude", "\u7def\u5ea6 (\u6570\u5024)");
        ExifField.define(IFD.GPS, 3, "GPSLongitudeRef", "\u6771\u7d4c(E) or \u897f\u7d4c(W)");
        ExifField.define(IFD.GPS, 4, "GPSLongitude", "\u7d4c\u5ea6 (\u6570\u5024)");
        ExifField.define(IFD.GPS, 5, "GPSAltitudeRef", "\u9ad8\u5ea6\u306e\u5358\u4f4d");
        ExifField.define(IFD.GPS, 6, "GPSAltitude", "\u9ad8\u5ea6 (\u6570\u5024)");
        ExifField.define(IFD.GPS, 7, "GPSTimeStamp", "GPS \u6642\u9593 (\u539f\u5b50\u6642\u8a08\u306e\u6642\u9593)");
        ExifField.define(IFD.GPS, 8, "GPSSatellites", "\u6e2c\u4f4d\u306b\u4f7f\u3063\u305f\u885b\u661f\u4fe1\u53f7");
        ExifField.define(IFD.GPS, 9, "GPSStatus", "GPS \u53d7\u4fe1\u6a5f\u306e\u72b6\u614b");
        ExifField.define(IFD.GPS, 10, "GPSMeasureMode", "GPS \u306e\u6e2c\u4f4d\u65b9\u6cd5");
        ExifField.define(IFD.GPS, 11, "GPSDOP", "\u6e2c\u4f4d\u306e\u4fe1\u983c\u6027");
        ExifField.define(IFD.GPS, 12, "GPSSpeedRef", "\u901f\u5ea6\u306e\u5358\u4f4d");
        ExifField.define(IFD.GPS, 13, "GPSSpeed", "\u901f\u5ea6 (\u6570\u5024)");
        ExifField.define(IFD.GPS, 14, "GPSTrackRef", "\u9032\u884c\u65b9\u5411\u306e\u5358\u4f4d");
        ExifField.define(IFD.GPS, 15, "GPSTrack", "\u9032\u884c\u65b9\u5411 (\u6570\u5024)");
        ExifField.define(IFD.GPS, 16, "GPSImgDirectionRef", "\u64ae\u5f71\u3057\u305f\u753b\u50cf\u306e\u65b9\u5411\u306e\u5358\u4f4d");
        ExifField.define(IFD.GPS, 17, "GPSImgDirection", "\u64ae\u5f71\u3057\u305f\u753b\u50cf\u306e\u65b9\u5411\uff08\u6570\u5024\uff09");
        ExifField.define(IFD.GPS, 18, "GPSMapDatum", "\u6e2c\u4f4d\u306b\u7528\u3044\u305f\u5730\u56f3\u30c7\u30fc\u30bf");
        ExifField.define(IFD.GPS, 19, "GPSDestLatitudeRef", "\u76ee\u7684\u5730\u306e\u5317\u7def(N) or \u5357\u7def(S)");
        ExifField.define(IFD.GPS, 20, "GPSDestLatitude", "\u76ee\u7684\u5730\u306e\u7def\u5ea6\uff08\u6570\u5024\uff09");
        ExifField.define(IFD.GPS, 21, "GPSDestLongitudeRef", "\u76ee\u7684\u5730\u306e\u6771\u7d4c(E) or \u897f\u7d4c(W)");
        ExifField.define(IFD.GPS, 22, "GPSDestLongitude", "\u76ee\u7684\u5730\u306e\u7d4c\u5ea6 (\u6570\u5024)");
        ExifField.define(IFD.GPS, 23, "GPSDestBearingRef", "\u76ee\u7684\u5730\u306e\u65b9\u89d2\u306e\u5358\u4f4d");
        ExifField.define(IFD.GPS, 24, "GPSDestBearing", "\u76ee\u7684\u306e\u65b9\u89d2 (\u6570\u5024)");
        ExifField.define(IFD.GPS, 25, "GPSDestDistanceRef", "\u76ee\u7684\u5730\u307e\u3067\u306e\u8ddd\u96e2\u306e\u5358\u4f4d");
        ExifField.define(IFD.GPS, 26, "GPSDestDistance", "\u76ee\u7684\u5730\u307e\u3067\u306e\u8ddd\u96e2 (\u6570\u5024)");
        ExifField.define(IFD.GPS, 27, "GPSProcessingMethod", "\u4f4d\u7f6e\u78ba\u5b9a\u65b9\u6cd5");
        ExifField.define(IFD.GPS, 28, "GPSAreaInformation", "\u30a8\u30ea\u30a2\u60c5\u5831");
        ExifField.define(IFD.GPS, 29, "GPSDateStamp", "UTC \u76f8\u5bfe\u6642\u523b");
        ExifField.define(IFD.GPS, 30, "GPSDifferential", "\u8aa4\u5dee");
        ExifField.define(IFD.INTROP, 1, "InteroperabilityIndex", "\u4e92\u63db\u6027\u8b58\u5225\u5b50");
    }
}

