/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.fixez;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.koiroha.fixez.ByteBufferInputStream;
import org.koiroha.fixez.Exif;
import org.koiroha.fixez.ExifField;
import org.koiroha.fixez.ExifFormatException;
import org.koiroha.fixez.IFD;
import org.koiroha.fixez.Rational;
import org.koiroha.fixez.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifFactory {
    private static final Logger logger = Logger.getLogger(ExifFactory.class.getName());
    private static final int SOI = 65496;
    private static final int APP1 = 65505;
    private static final int SOS = 65498;
    private static final int EOI = 65497;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exif getInstance(File file) throws IOException, ExifFormatException {
        FileChannel fileChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            Exif exif = this.getInstance(mappedByteBuffer);
            return exif;
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Exif getInstance(ByteBuffer byteBuffer) throws ExifFormatException {
        assert (byteBuffer != null);
        String string = null;
        int n = byteBuffer.position();
        try {
            ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(byteBuffer);
            string = URLConnection.guessContentTypeFromStream(byteBufferInputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byteBuffer.position(n);
        logger.fine("content-type: " + string);
        if (string == null) {
            logger.fine("content-type unresolved");
            return null;
        }
        if (string.matches("image/p?jpe?g")) {
            logger.fine("parse as jpeg image: " + string);
            return ExifFactory.readJPEG(byteBuffer);
        }
        logger.fine("unsupported content-type: " + string);
        return null;
    }

    private static Exif readJPEG(ByteBuffer byteBuffer) throws ExifFormatException {
        int n;
        do {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            n = byteBuffer.getShort() & 0xFFFF;
            logger.finer("mark found: " + ExifFactory.hex(n));
            if (n == 65496) continue;
            int n2 = (byteBuffer.getShort() & 0xFFFF) - 2;
            if (n == 65505) {
                logger.finer("APP1 marker found at 0x" + ExifFactory.hex(byteBuffer.position() - 4));
                Exif exif = ExifFactory.readExif(byteBuffer, n2);
                if (exif != null) {
                    return exif;
                }
                logger.finer("exif information isn't retrieve, continue");
                continue;
            }
            logger.finer("not a APP1 marker, continue");
            byteBuffer.position(byteBuffer.position() + n2);
        } while (n != 65497 && n != 65498);
        logger.fine("APP1 marker not found");
        return null;
    }

    private static Exif readExif(ByteBuffer byteBuffer, int n) throws ExifFormatException {
        boolean bl;
        int n2;
        byte[] byArray = new byte[]{69, 120, 105, 102, 0, 0};
        byte[] byArray2 = new byte[byArray.length];
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            byArray2[n2] = byteBuffer.get();
        }
        if (!Arrays.equals(byArray, byArray2)) {
            byteBuffer.position(byteBuffer.position() + n - byArray2.length);
            logger.finer(ExifFactory.hex(byteBuffer.position()) + ": not a exif block");
            return null;
        }
        logger.finer("exif signature found");
        n2 = byteBuffer.position();
        logger.finer("header position: 0x" + Integer.toHexString(n2));
        boolean bl2 = bl = (byteBuffer.getShort() & 0xFFFF) == 19789;
        if (bl) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        logger.finer("byte order: " + byteBuffer.order());
        int n3 = byteBuffer.getShort() & 0xFFFF;
        int n4 = byteBuffer.getInt();
        logger.finer("tiff header: tag marker=" + ExifFactory.hex(n3) + ", offset=" + n4);
        if (n3 != 42) {
            logger.finer("invalid tag marker: 0x" + ExifFactory.hex(n3));
            return null;
        }
        ArrayList<ExifField> arrayList = new ArrayList<ExifField>();
        ExifFactory.read(arrayList, byteBuffer, IFD.I0TH, n2, n4);
        return new Exif(arrayList);
    }

    private static void read(List<ExifField> list, ByteBuffer byteBuffer, IFD iFD, int n, int n2) throws ExifFormatException {
        logger.finer("starting ifd: " + (Object)((Object)iFD));
        while (n2 != 0) {
            byteBuffer.position(n + n2);
            int n3 = byteBuffer.getShort() & 0xFFFF;
            logger.finer("start " + n3 + " entries");
            for (int i = 0; i < n3; ++i) {
                int n4 = byteBuffer.getShort() & 0xFFFF;
                int n5 = byteBuffer.getShort() & 0xFFFF;
                int n6 = byteBuffer.getInt();
                int n7 = byteBuffer.getInt();
                logger.finer("tag=" + ExifFactory.hex(n4) + ",type=" + ExifFactory.hex(n5) + ",count=" + n6 + ",value=" + Integer.toHexString(n7));
                if (n4 == 34665 || n4 == 34853 || n4 == 40965) {
                    int n8 = byteBuffer.position();
                    ExifFactory.read(list, byteBuffer, IFD.valueOf(n4), n, n7);
                    byteBuffer.position(n8);
                    continue;
                }
                Type type = Type.valueOf(n5);
                if (type == null) {
                    throw new ExifFormatException("unsupported type detected: 0x" + ExifFactory.hex(n5) + " at position 0x" + Integer.toHexString(byteBuffer.position()));
                }
                ExifField exifField = ExifFactory.readExifField(byteBuffer, iFD, n4, type, n6, n7, n);
                list.add(exifField);
            }
            n2 = byteBuffer.getInt();
            logger.finer("end entries, next offset: 0x" + Integer.toHexString(n + n2));
            if (iFD != IFD.I0TH) continue;
            iFD = IFD.I1ST;
            logger.finer("moving ifd: " + (Object)((Object)iFD));
        }
    }

    private static ExifField readExifField(ByteBuffer byteBuffer, IFD iFD, int n, Type type, int n2, int n3, int n4) {
        logger.finest(iFD.toString() + ":" + ExifFactory.hex(n) + ":" + type.toString() + "[" + n2 + "]");
        byte[] byArray = null;
        String string = null;
        Number[] numberArray = null;
        switch (type) {
            case BYTE: 
            case UBYTE: {
                int n5;
                byArray = ExifFactory.readBinary(byteBuffer, 1, n2, n3, n4);
                numberArray = new Number[byArray.length];
                for (n5 = 0; n5 < byArray.length; ++n5) {
                    numberArray[n5] = type == Type.UBYTE ? (Number)new Short((short)(byArray[n5] & 0xFF)) : (Number)new Byte(byArray[n5]);
                }
                break;
            }
            case USHORT: 
            case SHORT: {
                byArray = ExifFactory.readBinary(byteBuffer, 2, n2, n3, n4);
                numberArray = ExifFactory.toShortArray(byArray, n2, byteBuffer.order(), type == Type.USHORT);
                break;
            }
            case ULONG: 
            case LONG: {
                byArray = ExifFactory.readBinary(byteBuffer, 4, n2, n3, n4);
                numberArray = ExifFactory.toIntArray(byArray, n2, byteBuffer.order(), type == Type.ULONG);
                break;
            }
            case URATIONAL: 
            case RATIONAL: {
                byArray = ExifFactory.readBinary(byteBuffer, 4, n2 * 2, n3, n4);
                numberArray = ExifFactory.toRationalArray(byArray, n2, byteBuffer.order(), type == Type.URATIONAL);
                break;
            }
            case SFLOAT: {
                byArray = ExifFactory.readBinary(byteBuffer, 4, n2, n3, n4);
                numberArray = ExifFactory.toFloatArray(byArray, n2);
                break;
            }
            case DFLOAT: {
                byArray = ExifFactory.readBinary(byteBuffer, 8, n2, n3, n4);
                numberArray = ExifFactory.toDoubleArray(byArray, n2);
                break;
            }
            case ASCII: {
                int n5;
                byArray = ExifFactory.readBinary(byteBuffer, 1, n2, n3, n4);
                numberArray = null;
                for (n5 = byArray.length; n5 > 0 && byArray[n5 - 1] == 0; --n5) {
                }
                string = new String(byArray, 0, n5);
                break;
            }
            case UNDEFINED: {
                byArray = ExifFactory.readBinary(byteBuffer, 1, n2, n3, n4);
                numberArray = null;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < byArray.length; ++i) {
                    char c = (char)(byArray[i] & 0xFF);
                    if (Character.isDefined(c) && !Character.isISOControl(c)) {
                        stringBuilder.append(c);
                        if (c != '\\') continue;
                        stringBuilder.append('\\');
                        continue;
                    }
                    stringBuilder.append('\\');
                    stringBuilder.append(Character.forDigit(byArray[i] >> 4 & 0xF, 16));
                    stringBuilder.append(Character.forDigit(byArray[i] >> 0 & 0xF, 16));
                }
                string = stringBuilder.toString();
                break;
            }
            default: {
                assert (false) : "Bug! unexpected type:" + (Object)((Object)type);
                break;
            }
        }
        if (string == null) {
            assert (numberArray != null);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < numberArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(numberArray[i]);
            }
            string = stringBuilder.toString();
        }
        logger.finer((Object)((Object)iFD) + "." + ExifFactory.hex(n) + ": [" + (Object)((Object)type) + "] " + string);
        return new ExifField(iFD, n, type, n2, string.toString(), byArray, numberArray);
    }

    private static Number[] toShortArray(byte[] byArray, int n, ByteOrder byteOrder, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(byteOrder);
        Number[] numberArray = new Number[n];
        for (int i = 0; i < numberArray.length; ++i) {
            numberArray[i] = bl ? (Number)new Integer(byteBuffer.getShort() & 0xFFFF) : (Number)new Short(byteBuffer.getShort());
            if (byteOrder != ByteOrder.LITTLE_ENDIAN) continue;
            byArray[i * 2 + 0] = (byte)(numberArray[i].intValue() >> 8 & 0xFF);
            byArray[i * 2 + 1] = (byte)(numberArray[i].intValue() >> 0 & 0xFF);
        }
        return numberArray;
    }

    private static Number[] toIntArray(byte[] byArray, int n, ByteOrder byteOrder, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(byteOrder);
        Number[] numberArray = new Number[n];
        for (int i = 0; i < numberArray.length; ++i) {
            numberArray[i] = bl ? (Number)new Long((long)byteBuffer.getInt() & 0xFFFFFFFFL) : (Number)new Integer(byteBuffer.getInt());
            if (byteOrder != ByteOrder.LITTLE_ENDIAN) continue;
            byArray[i * 4 + 0] = (byte)(numberArray[i].intValue() >>> 24 & 0xFF);
            byArray[i * 4 + 1] = (byte)(numberArray[i].intValue() >>> 16 & 0xFF);
            byArray[i * 4 + 2] = (byte)(numberArray[i].intValue() >>> 8 & 0xFF);
            byArray[i * 4 + 3] = (byte)(numberArray[i].intValue() >>> 0 & 0xFF);
        }
        return numberArray;
    }

    private static Rational[] toRationalArray(byte[] byArray, int n, ByteOrder byteOrder, boolean bl) {
        Number[] numberArray = ExifFactory.toIntArray(byArray, n * 2, byteOrder, bl);
        Rational[] rationalArray = new Rational[numberArray.length / 2];
        for (int i = 0; i < rationalArray.length; ++i) {
            rationalArray[i] = new Rational(numberArray[i * 2].longValue(), numberArray[i * 2 + 1].longValue());
        }
        return rationalArray;
    }

    private static Number[] toFloatArray(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Number[] numberArray = new Number[n];
        for (int i = 0; i < numberArray.length; ++i) {
            numberArray[i] = new Float(byteBuffer.getFloat());
        }
        return numberArray;
    }

    private static Number[] toDoubleArray(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Number[] numberArray = new Number[n];
        for (int i = 0; i < numberArray.length; ++i) {
            numberArray[i] = new Double(byteBuffer.getDouble());
        }
        return numberArray;
    }

    private static byte[] readBinary(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        int n5 = byteBuffer.position();
        int n6 = n * n2;
        byte[] byArray = new byte[n6];
        if (n6 <= 4) {
            if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
                if (byArray.length > 0) {
                    byArray[0] = (byte)(n3 >>> 24 & 0xFF);
                }
                if (byArray.length > 1) {
                    byArray[1] = (byte)(n3 >>> 16 & 0xFF);
                }
                if (byArray.length > 2) {
                    byArray[2] = (byte)(n3 >>> 8 & 0xFF);
                }
                if (byArray.length > 3) {
                    byArray[3] = (byte)(n3 >>> 0 & 0xFF);
                }
            } else {
                if (byArray.length > 0) {
                    byArray[0] = (byte)(n3 >>> 0 & 0xFF);
                }
                if (byArray.length > 1) {
                    byArray[1] = (byte)(n3 >>> 8 & 0xFF);
                }
                if (byArray.length > 2) {
                    byArray[2] = (byte)(n3 >>> 16 & 0xFF);
                }
                if (byArray.length > 3) {
                    byArray[3] = (byte)(n3 >>> 24 & 0xFF);
                }
            }
        } else {
            byteBuffer.position(n4 + n3);
            byteBuffer.get(byArray);
        }
        if (byteBuffer.position() != n5) {
            byteBuffer.position(n5);
        }
        return byArray;
    }

    private static String hex(int n) {
        return String.format("%04X", n);
    }
}

