/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.fixez;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.koiroha.fixez.ExifField;
import org.koiroha.fixez.IFD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exif
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<ExifField> field = new ArrayList<ExifField>();
    private final Map<Integer, ExifField> ifdTagIndex = new HashMap<Integer, ExifField>();

    Exif(Collection<ExifField> collection) {
        for (ExifField exifField : collection) {
            this.setField(exifField);
        }
    }

    public Collection<ExifField> getFields() {
        return Collections.unmodifiableCollection(this.field);
    }

    public ExifField getField(IFD iFD, int n) {
        return this.ifdTagIndex.get(Exif.getKey(iFD, n));
    }

    public String toString() {
        return this.field.toString();
    }

    private void setField(ExifField exifField) {
        this.field.add(exifField);
        this.ifdTagIndex.put(Exif.getKey(exifField.getIFD(), exifField.getTag()), exifField);
    }

    private static int getKey(IFD iFD, int n) {
        return (iFD.getDigit() & 0xFFFF) << 16 | n & 0xFFFF;
    }
}

