/**
 *	@file	kzversion.asm
 *	@brief	KOBANZAME SDK Version File
 *
 *	KOBANZAME SDK
 *		Software Developers Kit for Blackfin DSP Evaluation Board(KOBANZAME).
 *		
 *	Copyright (C) 2010, KOBANZAME SDK Project, all right reserved
 *
 *	LICENSE:
 *	The software is a free and you can use and redistribute it for
 *	personal, non-profit or commercial products. Redistributions of
 *	source code must retain the above copyright notice. There is no 
 *	warranty in this software, if you suffer any damages by using 
 *	the software.
 */
 
#include "kzversion.h"

.section constdata;

.BYTE _KzBuildDate[] = __DATE__,'/',__TIME__,0;
.BYTE _KzCopyRight[] = 'KOBANZAME SDK Project',0;

.section program;
.global _KzGetVersionMajor;
.global	_KzGetVersionMinor;
.global _KzGetBuildIdx;
.global	_KzGetBuildDate;
.global _KzGetCopyRight;

// int KzGetVersionMajor(void)
_KzGetVersionMajor:
	r0 = KZVER_MEJOR(Z);
	nop;nop;nop;
	rts;
_KzGetVersionMajor.END:


// int _KzGetVersionMinor(void)
_KzGetVersionMinor:
	r0 = KZVER_MINOR(Z);
	nop;nop;nop;
	rts;
_KzGetVersionMinor.END:

// int KzGetBuildIdx(void)
_KzGetBuildIdx:
	r0 = KZVER_BUILD_IDX(Z);
	nop;nop;nop;
	rts;
_KzGetBuildIdx.END:


// const char *KzGetBuildDate(void)
_KzGetBuildDate:
	r0.l = lo(_KzBuildDate);
	r0.h = hi(_KzBuildDate);
	nop;nop;
	rts;
_KzGetBuildDate.END:

// const char *KzGetCopyRight(void)
_KzGetCopyRight:
	r0.l = lo(_KzCopyRight);
	r0.h = hi(_KzCopyRight);
	nop;nop;
	rts;
_KzGetCopyRight.END:
