/** @defgroup API_DeviceDriver
 * @defgroup API_CommandLine
 * @defgroup API_stdio
 * @defgroup API_AudioDSP
 * @defgroup UserCongifuration 
 */
/**
 *	@file	kobanzame.h
 *	@brief	KOBANZAME SDK Standard Include file
 *
 *	KOBANZAME SDK
 *		Software Developers Kit for Blackfin DSP Evaluation Board(KOBANZAME).
 *		
 *	Copyright (C) 2010, KOBANZAME SDK Project, all right reserved
 *
 *	LICENSE:
 *	The software is a free and you can use and redistribute it for
 *	personal, non-profit or commercial products. Redistributions of
 *	source code must retain the above copyright notice. There is no 
 *	warranty in this software, if you suffer any damages by using 
 *	the software.
 *
 *	@note	KOBANZAME SDK Common include file
 */
 
/**
 * @mainpage	KOBANZAME SDK
 *
 *	<Div Align="center"><STRONG> Software Developers Kit for </STRONG></DIV>
 *	<Div Align="center"><STRONG> KOBANZAME Blackfin Evaluation Board</STRONG></DIV><BR>
 *
 *	This software is free and is developed in SourceForge.jp KOBANZAME SDK Project.
 *	Please visit project page for getting latest software and documents(Japanese).
 *
 *	http://sourceforge.jp/projects/kobanzame-sdk/
 *
 *	<strong>KOBANZAME SDK</strong> is a Software Developers Kit(SDK) for KOBANZAME DSP Evaluation Board which embedded Analog Devices Blackfin Processor BF-533. 
 *
 *	Target users of this software are those who
 *	<UL><Li> Try to learn DSP Processor</Li>
 *		<Li> Try DSP evaluation quickly</Li>
 *		<Li> Implement your Audio DSP algorithm quickly</Li>
 *		<Li> etc ... </Li></UL>
 *
 *	This SDK has following features.
 *	<UL><Li>uITRON4 RTOS is ready to use. Users can implement multi-task system easily.</Li>
 *	    <Li>Filesystem(FAT32/16/12/VFAT) for micro-SD-Card is ready to use. </Li>
 *	    <Li>Serial Command line is ready to use. Users can add original commands easily.</Li>
 *		<Li>Device Drivers APIs are ready to use. Users can access following hardwares easily.</Li>
 *		<UL><Li>48kHz 24bit 4in/ 4out audio</Li>
 *			<Li>MEMS</Li>
 *			<Li>Switches</Li>
 *			<Li>LEDs</Li></UL>
 *		<Li>The SDK equips almost C-Language standard functions defined in stdio.h. Thier standard I/O is accessed via Serial or micro-SD's filesystem, not debugger console. The functions are overwritten standard ones by including "kobanzame.h". </Li>
 *		<Li>Q5.26 Audio DSP Library is ready to use. The library uses Blackfin Hardware DSP Units, and users can make powerful DSP software easily even without knowledge of DSP Hardware Units. </Li> 
 *	</UL>
 *
 *	The SDK support following tool.
 *	<UL><LI>Analog Devices VDSP++5.0 Update7 </LI>
 *	</UL>
 *
 *	KOBANZAME is a DSP evaluation board distributed by J-Person Co., Ltd.
 *	Main parts of the board are
 *	<UL><LI> Analog Devices Blackfin Processor BF-533 500MHz </LI>
 *	    <LI> 32Mbyte SD-RAM</LI>
 *		<LI> 2MByte Serial flash</LI>
 *		<LI> Analog Devices Audio CODEC AD1836 </LI>
 *		<LI> Freescale MEMS MMA7455L </LI>
 *		<LI> Two LEDs </LI>
 *		<LI> Two Switches </LI></UL>
 *
 *	Get more information about KOBANZAME, please visit j-person's home page(English).
 * 
 *	http://kobanzame.j-person.com/bf533/index-en.html
 *				
 *	This software is consist of
 *	<UL><LI> Toppers JSP(RTOS> by TOPPERS Project</LI>
 *		<LI> Toppers JSP for Blackfin by suikan</LI>
 *		<LI> FAT Filesystem Fatfs by ChaN </LI>
 *		<LI> Device Drivers for KOBANZAME </LI>
 *		<LI> Command line </LI></UL>
 *
 *	LICENSE:
 *	The software is a free and you can use and redistribute it for
 *	personal, non-profit or commercial products. Redistributions of
 *	source code must retain the above copyright notice. There is no 
 *	warranty in this software, if you suffer any damages by using 
 *	the software.
 *
 *	The documents are automatically generated by DOXYGEN from the SDK source codes
 *
 *	<Div Align="center">Copyright (C) 2010, KOBANZAME SDK Project, all right reserved</Div>
 */
 
#ifndef _kobanzame_h_
#define _kobanzame_h_

/*--- include -----------------------------------*/
#include "target_def.h"
#include "kzconfig.h"
#include "kernel.h"
#include <stdio.h>
#include "kzstdio.h"
#include "kzdev.h"
#include "kzdsp.h"

/*--- define  -----------------------------------*/
#define	numof(x)		sizeof(x)/sizeof(x[0])		/*!< number of the contents */

/** physical switches type */	
typedef enum {
	eKzSW0, 						/*!< KOBANZAME hardware switch 0 */
	eKzSW1, 						/*!< KOBANZAME hardware switch 1 */
	numof_KzSW 						/*!< number of the physical switches */
} KzSW_t;											

/** definition for LEDs */
typedef enum {
	eKzLED0, 						/*!< KOBANZAME hardware LED 0 */
	eKzLED1, 						/*!< KOBANZAME hardware LED 1 */
	numof_KzLED 					/*!< number of the LEDs of KOBANZAME */
} KzLED_t;							


/** 
 * @typedef 	KzFnCmd_t
 * @brief		command line function's type
 * @param		argc number of the arguments from command line
 * @param		argv argument strings
*/
typedef int (*KzFnCmd_t)(	int argc, char *argv[] );

/** 
 * @typedef	KzSwCbk_t
 * @brief		callback type for physical switches change status 
 * @param		nSw KOBANZAME hardware switch ID
 * @param		bPushed	TRUE  ... Pushed / 
 *						FALSE ... Released
 */
typedef void (*KzSwCbk_t)(	KzSW_t nSw , BOOL bPushed );	

/**
 * @typedef	KzMemsCbk_t
 * @brief		callback function type for MEMS changes 
 * @param		x MEMS X value
 * @param		y MEMS Y value
 * @param		z MEMS Z value
 */
typedef void (*KzMemsCbk_t)( int x, int y, int z);

/**
 * @typedef	KzAudioCbk_t
 * @brief		callback function type for audio
 * @param		in audio input buffer from Audio Codec
 * @param		out audio output buffer to Audio Codec
 * @param		nBlocks number of the Audio blocks
 * @param		nChannels numober of the Audio Channels (1-4)
 * @note		in and out buffer is clustared as L0/R0/L1/R1
 */
typedef void (*KzAudioCbk_t)( int *in, int *out, int nBlocks, int nChannels);


/** command line registration type */
typedef struct {					
	KzFnCmd_t		mfnExe;			/*!< function pointer for the command line */
	const char*		msCmd;			/*!< command strings for the command line */
	const char*		msHelp;			/*!< help strings for the command line */
} KzCmdRegist_t;					

#define KZ_AUDIOCLUSTAR		(4)		/*!< @brief Numbers of the Audio Clustar, Audio Clustar Order is L0/R0/L1/R1 */

#if TARGET_TOOL == TOOL_VS2008
#pragma warning ( disable : 4996 )	/*!< @brief To avoid win32 excess warning */
#endif

/*-- Memory Section Definitions ------------------*/
#if TARGET_TOOL == TOOL_VDSP
#define		L1DATA_S		section("L1_data_s")		/*!< @brief Memory section directive: L1 SCRATCH */
#define		L1DATA_A		section("L1_data_a")		/*!< @brief Memory section directive: L1 DATA A */
#define		L1DATA_B		section("L1_data_b")		/*!< @brief Memory section directive: L1 DATA B */
#define		L1CODE			section("L1_code")			/*!< @brief Memory section directive: L1 CODE */
#define		L3DATA			section("L3_data")			/*!< @brief Memory section directive: SDRAM DATA */
#define		L3CODE			section("L3_code")			/*!< @brief Memory section directive: SDRAM CODE */

#elif TARGET_TOOL == TOOL_GCC
#define		L1DATA_S		section("L1_data_s")		/*!< @brief Memory section directive: L1 SCRATCH */
#define		L1DATA_A		section("L1_data_a")		/*!< @brief Memory section directive: L1 DATA A */
#define		L1DATA_B		section("L1_data_b")		/*!< @brief Memory section directive: L1 DATA B */
#define		L1CODE			section("L1_code")			/*!< @brief Memory section directive: L1 CODE */
#define		L3DATA			section("L3_data")			/*!< @brief Memory section directive: SDRAM DATA */
#define		L3CODE			section("L3_code")			/*!< @brief Memory section directive: SDRAM CODE */

#elif TARGET_TOOL == TOOL_VS2008
#define		L1DATA_S									/*!< @brief Memory section directive: L1 SCRATCH */
#define		L1DATA_A									/*!< @brief Memory section directive: L1 DATA A */
#define		L1DATA_B									/*!< @brief Memory section directive: L1 DATA B */
#define		L1CODE										/*!< @brief Memory section directive: L1 CODE */
#define		L3DATA										/*!< @brief Memory section directive: SDRAM DATA */
#define		L3CODE										/*!< @brief Memory section directive: SDRAM CODE */

#else
#error "Please define TARGET_TOOL"
#endif

/*--- return status  ----------------------------*/
/** KOBANZAME SDK's general return type */
typedef enum {
	KZ_OK			=	0,			/*!< Success */
	KZ_ERR			=	-1,			/*!< Error   */
} KZSTATUS_t;						

/*--- global functions  -------------------------*/
#ifdef __cplusplus
extern "C" {
#endif

/*-- cmdline.c --*/
extern KZSTATUS_t	KzCmdlineStart(void);
extern KZSTATUS_t	KzCmdlineExit(void);
extern KZSTATUS_t	KzCmdlineAdd( const KzCmdRegist_t *exe );
extern KZSTATUS_t	KzCmdlineAddMany( const KzCmdRegist_t *exes );

/*-- kzdev.c --*/
extern KZSTATUS_t	KzAddCmdDeviceDriver(void);
extern KZSTATUS_t	KzSwStart(KzSwCbk_t cbk);
extern KZSTATUS_t	KzSwStop(void);
extern KZSTATUS_t	KzLedOn(KzLED_t nLedNo);
extern KZSTATUS_t	KzLedOff(KzLED_t nLedNo);
extern KZSTATUS_t	KzLedBlink(KzLED_t nLedNo,int nOnTime, int nOffTime);
extern KZSTATUS_t	KzMemsStart(KzMemsCbk_t cbk);
extern KZSTATUS_t	KzMemsStop(void);
extern KZSTATUS_t	KzAudioStart(KzAudioCbk_t cbk,long lSampleRate, int nBlocks, int nChannels );
extern KZSTATUS_t	KzAudioStop(void);

/*-- version.asm --*/
extern int			KzGetVersionMajor(void);		/*!< @brief Get KOBANZAME SDK Major Version */
extern int			KzGetVersionMinor(void);		/*!< @brief Get KOBANZAME SDK Minor Version */
extern int			KzGetBuildIdx(void);			/*!< @brief Get KOBANZAME SDK Build index */
extern const char	*KzGetBuildDate(void);			/*!< @brief Get KOBANZAME SDK Build Date String */
extern const char	*KzGetCopyRight(void);			/*!< @brief Get KOBANZAME SDK Copyright String */

/*-- fs_cmd.c --*/
extern KZSTATUS_t	KzFilesystemStart(void);
extern KZSTATUS_t	KzAddCmdFilesystem(void);

/*-- kzstdio.c --*/
extern KZSTATUS_t	KzAddCmdStdioTest(void);

#ifdef __cplusplus
}
#endif

/*--- private global functions  -------------------------*/
#include "kzprivate.h"

#endif	/* !_kobanzame_h_ */

