/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: fdc37c935a.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 * X[pI/O FDC37C935A phCo
 */
#ifndef _FDC37C935A_H_
#define _FDC37C935A_H_

#include <t_config.h>

/*
 * x[XAhX 
 */
//#define SMSC_BASE_ADDR 0xB0400000

#define SMSC_CONFIG_PORT (SMSC_BASE_ADDR + 0x7E0)  /* H */
#define SMSC_INDEX_PORT  (SMSC_BASE_ADDR + 0x7E0)  /* H */
#define SMSC_DATA_PORT   (SMSC_BASE_ADDR + 0x7E2)  /* H */


#ifndef _MACRO_ONLY

Inline void
smsc_config_write(UH index, UH data)
{
    sil_wrh_mem((VP)SMSC_INDEX_PORT, (index << 8));
    sil_wrh_mem((VP)SMSC_DATA_PORT, (data << 8));
}

Inline UH
smsc_config_read(UH index)
{
    sil_wrh_mem((VP)SMSC_INDEX_PORT, (index << 8));
    return(sil_reh_mem((VP)SMSC_DATA_PORT) >> 8);
}

/*
 *  
 */
extern void smsc_init(void);



#endif /*  _MACRO_ONLY */


/*
 * SCI0
 */
#define SMSC_SCI0_BASE_ADDR  0x03f8

#define SMSC_SCI0_RBR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x0)  /* H */
#define SMSC_SCI0_THR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x0)  /* H */
#define SMSC_SCI0_DLL (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x0)  /* H */
#define SMSC_SCI0_IER (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x2)  /* H */
#define SMSC_SCI0_DLM (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x2)  /* H */
#define SMSC_SCI0_IIR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x4)  /* H */
#define SMSC_SCI0_FCR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x4)  /* H */
#define SMSC_SCI0_LCR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x6)  /* H */
#define SMSC_SCI0_MCR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0x8)  /* H */
#define SMSC_SCI0_LSR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0xA)  /* H */
#define SMSC_SCI0_MSR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0xC)  /* H */
#define SMSC_SCI0_SCR (SMSC_BASE_ADDR + SMSC_SCI0_BASE_ADDR * 2 + 0xE)  /* H */

/*
 *  X[p[I/O(FDC37C935A)p ȈSIOhCo
 */

#ifndef _MACRO_ONLY

/*
 *  ݈ȊȌ
 *  J[lNp̏(sys_putcgp邽)
 */
extern void fdc37c935a_init(void);


/*
 *  VAI/O|[gǗubN̒`
 */
typedef struct sio_port_control_block   SIOPCB;

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND    1u      /* M\R[obN */
#define SIO_ERDY_RCV    2u      /* MʒmR[obN */


/*
 *  SIOhCȍ[`
 */
extern void smsc_sci0_initialize(void);


/*
 *  I[vĂ|[g邩H
 */
extern BOOL smsc_sci0_openflag(void);


/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB   *smsc_sci0_opn_por(ID siopid, VP_INT exinf);


/*
 *  VAI/O|[g̃N[Y
 */
extern void smsc_sci0_cls_por(SIOPCB *siopcb);


/*
 *  VAI/O|[gւ̕M
 */
extern BOOL smsc_sci0_snd_chr(SIOPCB *siopcb, char c);


/*
 *  VAI/O|[g̕M
 */
extern INT  smsc_sci0_rcv_chr(SIOPCB *siopcb);


/*
 *  VAI/O|[g̃R[obN̋
 */
extern void smsc_sci0_ena_cbr(SIOPCB *siopcb, UINT cbrtn);


/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void smsc_sci0_dis_cbr(SIOPCB *siopcb, UINT cbrtn);


/*
 *  SIO̊݃T[rX[`
 */
extern void smsc_sci0_isr(void);


/*
 *  VAI/O|[g̑M\R[obN
 */
extern void smsc_sci0_ierdy_snd(VP_INT exinf);


/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void smsc_sci0_ierdy_rcv(VP_INT exinf);




#endif /* _MACRO_ONLY */


#endif /* _FDC37C935A_H_ */
