/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: dataqueue.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	f[^L[@\
 */

#ifndef _DATAQUEUE_H_
#define _DATAQUEUE_H_

#include "queue.h"

/*
 *  f[^L[ubN
 */
typedef struct dataqueue_initialization_block {
	ATR	dtqatr;		/* f[^L[ */
	UINT	dtqcnt;		/* f[^L[̗̈e */
	VP	dtq;		/* f[^L[̈̐擪Ԓn */
} DTQINIB;

/*
 *  f[^L[ǗubN
 */
typedef struct dataqueue_control_block {
	QUEUE	swait_queue;	/* f[^L[M҂L[ */
	const DTQINIB *dtqinib;	/* f[^L[ubNւ̃|C^ */
	QUEUE	rwait_queue;	/* f[^L[M҂L[ */
	UINT	count;		/* f[^L[̃f[^̐ */
	UINT	head;		/* ŏ̃f[^̊i[ꏊ */
	UINT	tail;		/* Ō̃f[^̊i[ꏊ̎ */
} DTQCB;

/*
 *  f[^L[@\̏
 */
extern void	dataqueue_initialize(void);

/*
 *  f[^L[̈Ƀf[^i[
 */
extern BOOL	enqueue_data(DTQCB *dtqcb, VP_INT data);

/*
 *  f[^L[̈Ƀf[^i[
 */
extern void	force_enqueue_data(DTQCB *dtqcb, VP_INT data);

/*
 *  f[^L[̈悩f[^o
 */
extern BOOL	dequeue_data(DTQCB *dtqcb, VP_INT *p_data);

/*
 *  M҂L[̐擪^XNւ̃f[^M
 */
extern TCB	*send_data_rwait(DTQCB *dtqcb, VP_INT data);

/*
 *  M҂L[̐擪^XÑf[^M
 */
extern TCB	*receive_data_swait(DTQCB *dtqcb, VP_INT *p_data);

#endif /* _DATAQUEUE_H_ */
