/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *
 */


/*
 *	vZbTˑ̃J[liBLACKfinpj
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  T[rXR[I}N̓ǂݍ
 */
#ifdef __GNUC__
/*
* T[rXR[ÍAconfigureXNvgȂ̂ŁAgnuł͕sv
*/
//#include <api.h>
#elif defined(__ECC__)
/*
* T[rXR[ÍAIPAŝŁAVisualDSP++łׂ͂đIĂ
*/
#include <api.h>
#else
#error "Compiler is not supported"
#endif

/*
*  CxgvCIeB錾. sys_config.h  device_dispatcher()ŎgB
*/
#ifndef ik_timer
#define ik_timer 6
#endif

#ifndef ik_hardware
#define ik_hardware_err 5
#endif

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
*	BLACKfiñrbg}bv@\g
*   BLACKfinMSB琔B
*/
#define	CPU_BITMAP_SEARCH
#define	PRIMAP_BIT(pri)		(0x40000000u >> (pri))


/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */


/*
*	BLACKfinIMASKւ̐ݒp^[
*
*/
#define IMASK_LOCK   0xc01f
#define IMASK_UNLOCK 0xffff

#ifndef _MACRO_ONLY
/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
/*
 *  fBL[T[`̂߂̃rbg}bvT[`֐
 *
 *  rbg}bv̉16rbggpCŉʃrbgŒDxɑΉ
 *  D
 */


Inline UINT
bitmap_search(UINT bitmap)
{
	UINT	numOfSign;

	/*
	 *  ̃R[h́CbitmapiUINT^j32rbgł邱Ƃ肵
	 *  ĂDSignbits ߂32rbgMSBA
	 *  rbg - 1 ԂBall 0̂Ƃ31ԂBLSB݂̂1
	 *  Ƃ30ԂB
	 */
#ifdef __GNUC__			// gcc
	// gcc 3.4.1 ̎_ł́AIyhɉʃn[tWX^w
	// łȂ߁A]vȃR[hKvɂȂB
	Asm( "r0.L=signbits %1; %0 = r0.L;": "=d"(numOfSign) : "d"(bitmap) : "R0" );
#elif defined(__ECC__)	// visualdsp
	Asm( "%0=signbits %1;": "=l"(numOfSign) : "d"(bitmap) );
#else
#error "Compiler is not supported"
#endif
	return( numOfSign );
}



/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	VP	sp;		/* X^bN|C^ */
	FP	pc;		/* vOJE^ */
} CTXB;


/*
 *  VXeԎQ
 *	Ԃl͈ȉ̂Ƃ
 *	TRUE : ^XNReLXg
 *	FALSE: ^XNReLXg
 *				IPEND$8000$8010̎A^XNReLXgłBȊÔƂ͔^XNReLXgB
 */

Inline BOOL
sense_context(void)
{
	return( *__pIPEND & 0x7FEF );
}

/*
* ݂̃bNԂ𒲂ׂBǗO荞݂܂ŃbNsil_loc_int()
* 郍bNԂ́Asense_lock()ł͖B
*/
Inline BOOL
sense_lock(void)
{
#ifdef UNMANAGED_INT
	return((*__pIMASK & ~UNMANAGED_INT )== 0xC01F );
#else
	return(*__pIMASK == 0xC01F );
#endif
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock


/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Cchg_ipm T|[g邽߂̕ϐDchg_ipm T|[
 *  gȂꍇɂ́Ctask_intmask  0 ɂȂĂƍl΂悢D
 *
 */

#ifdef SUPPORT_CHG_IPM
extern UH	task_intmask;	/* ^XNReLXgł̊݃}XN */
#endif /* SUPPORT_CHG_IPM */

#ifdef UNMANAGED_INT
#if UNMANAGED_INT & 0xC01F
// ǗO荞݂͈̔̓`FbNBǗO荞݂IVHWIVG13̊ԂłȂ΂ȂȂ
#error "Illegal un-managed interrupt : must be IVHW-IVG13"
#endif
#endif


// BLACKfinłIMASK0xC01FCPUbNB
Inline void
t_lock_cpu()
{
#ifdef UNMANAGED_INT
	unsigned int imask;
	Asm( "cli %0;" :"=d"(imask) );
	Asm( "sti %0;" : :"d"(0xC01f | (imask & UNMANAGED_INT) ) );
#else
    Asm( "cli r0;" : : :"R0" );
	Asm( "sti %0;" : :"d"(0xC01F) );
#endif
}

Inline void
t_unlock_cpu()
{
#ifdef UNMANAGED_INT
	unsigned int imask;
	Asm( "cli %0;" :"=d"(imask) );
	Asm( "sti %0;" : :"d"( (0xffff & ~UNMANAGED_INT) | (imask & UNMANAGED_INT) ) );
#else
	Asm( "sti %0;" : :"d"(0xffff) );
#endif
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */


Inline void
i_lock_cpu()
{
#ifdef UNMANAGED_INT
	unsigned int imask;
	Asm( "cli %0;" :"=d"(imask) );
	Asm( "sti %0;" : :"d"(0xC01f | (imask & UNMANAGED_INT) ) );
#else
    Asm( "cli r0;" : : :"R0" );
	Asm( "sti %0;" : :"d"(0xC01F) );
#endif
}

Inline void
i_unlock_cpu()
{
#ifdef UNMANAGED_INT
	unsigned int imask;
	Asm( "cli %0;" :"=d"(imask) );
	Asm( "sti %0;" : :"d"( (0xffff & ~UNMANAGED_INT) | (imask & UNMANAGED_INT) ) );
#else
	Asm( "sti %0;" : :"d"(0xffff) );
#endif
}

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */


/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 * evtvector start.asmŒ`ĂB
 */
extern void (* dev_vector[])(void) ;

extern void (* exc_vector)(VP) ;
Inline void
define_inh(INHNO inhno, FP inthdr)
{
	dev_vector[inhno] = inthdr;
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
//	exc_vector[excno] = exchdr;		// OnhzɊi[
	exc_vector = (void (*)(VP))exchdr;		// Onhi[
}

/*
 *  ݃nh^CPUOnh̏o
 */

/*
 *  ݃nh̏o̐}N
 *
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 */

#define	INTHDR_ENTRY(inthdr)	extern void inthdr(void);
#define	INT_ENTRY(inthdr)	inthdr

/*
 *  CPUOnh̏o̐}N
 *
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 */

#define	EXCHDR_ENTRY(exchdr)	extern void exchdr( VP );
#define	EXC_ENTRY(exchdr)	exchdr

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg̎Q
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return( *__pIPEND & 0x7FE6 );				// IVG15, GIE, EXP, EMU ȊÕrbgĂΔ^XNReLXg
}

/*
 *  CPUO̔CPUbNԂ̎QƁBǗO荞݂̏Ԃ͖B
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
#ifdef UNMANAGED_INT
	return((*__pIMASK | UNMANAGED_INT) != 0xFFFF );		// 0xFFFFȂAbN
#else
	return(*__pIMASK != 0xFFFF );				// 0xFFFFȂAbN
#endif
}

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
