/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: garbage.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/garbage.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $

#include "base/garbage.h"

#include <stdexcept>
#include <algorithm>

using namespace std;

TrashBox * TrashBox::current_box = 0;

//----------------------------------------------------------------
// Garbage : S~

    //RXgN^
Garbage::Garbage(void) throw()
{
        //S~Ɋ֘At
    assigned_box = TrashBox::getCurrentTrashBox();
    if(assigned_box->isValid())
        cookie = assigned_box->addGarbage(this);
}

    //fXgN^
Garbage::~Garbage(void) throw()
{
    rescue();
}

    //S~~o
void Garbage::rescue(void) throw()
{
    if(assigned_box->isValid()) {
        assigned_box->recoverGarbage(cookie);
        assigned_box = 0;
    }
}


//----------------------------------------------------------------
// TrashBox : S~锠

TrashBox::TrashBox(void) throw()
{
        //S~̍ւ
    previous_box = current_box;
    current_box  = this;
}

TrashBox::~TrashBox(void) throw()
{
        //S~ȂȂ܂ō폜
    while(!garbage.empty()) {
            //ӂ
        try{   cleanup();   }
        catch(...) {}
    }

        //S~̍ւ
    current_box = previous_box;
}

/*
    //S~ɓꂽS~菜
void TrashBox::recoverGarbage(Garbage * _garbage, TrashBox::Cookie cookie) throw()
{
    if(isValid() && _garbage != 0) {
        bool forward = true;
        list<Garbage *>::iterator scope;

        if(!garbage.empty()) {
            scope = garbage.erase(cookie);

                //n
            if(scope != garbage.end() || garbage.empty())
                forward = false;
        }

            //eS~ɉ
        if(forward && previous_box->isValid())
            previous_box->recoverGarbage(_garbage, cookie);
    }
}
*/
    /*  C̃ 
              ֘AtꂽS~邱Ƃ͖(Ԃ̓S~̂ق͂)̂ŁAeɉ񑗂Kv͖Bif(forward...߂͕svB
              nłȂS~͖̂(cleanuprecoverGargabeĂ΂Ȃ)Aerase̕ԋpl̃`FbN͕svB
              ʍ폜v̓S~ôŁAsꂽ_ŃS~1ȏ㑶݂͂Ȃ̂ŁAempty`FbN͕sv.
              ̎_eraseɂȂA͕svB
    */

    //S~ɓꂽS~菜  
void TrashBox::recoverGarbage(TrashBox::Cookie cookie) throw()
{   garbage.erase(cookie);  }

    //S~ɂ
void TrashBox::cleanup(void)
{
        //gbvxS~łȂ玸s
    if(current_box != this)
        throw std::runtime_error("TrashBox::cleanup can be performed from the top level trash box only.");

    try {
        while(!garbage.empty())
            delete *garbage.begin();        //S~XgvfÔ͎q̖
    }
    catch(...) {
        garbage.erase(garbage.begin());     //ONŏ̗vf폜
        throw;                              //đ
    }
}



/****************************************** eXgXB[g ******************************************/

#ifdef TESTSUITE
#include "coverage_undefs.h"

namespace { int counter = 0; }

#ifdef _MSC_VER
    class DummyGarbage : public Garbage
    {
    public:
        int * count;
        bool throw_exception;

        DummyGarbage(int * _count = 0) : count(_count), throw_exception(false)
        { TestSuite::check("DummyGarbage::DummyGarbage");  }

        ~DummyGarbage(void) throw(int)
        {
            if(count != 0) *count = ++counter;
            if(throw_exception) throw 0;
            TestSuite::check("DummyGarbage::~DummyGarbage"); 
        }

    };
#elif __GNUC__
    class DummyGarbage : public Garbage
    {
    public:
        int * count;

        DummyGarbage(int * _count = 0) : count(_count)
        { TestSuite::check("DummyGarbage::DummyGarbage");  }

        ~DummyGarbage(void) throw()
        {
            if(count != 0) *count = ++counter;
            TestSuite::check("DummyGarbage::~DummyGarbage"); 
        }
    };
#endif

TESTSUITE(main, TrashBox)
{
    BEGIN_CASE("1","S~Ɠo^") {
        TrashBox mybox;
        TEST_CASE("1", "S~݂̃S~ɂȂĂ", TrashBox::current_box == &mybox);
        
        {
            TrashBox mybox2;
            TEST_CASE("2", "S~݂̃S~ɂȂĂ (2)", TrashBox::current_box == &mybox2);
            TEST_CASE("3", "ƂƂ̃S~ۑĂ", mybox2.previous_box == &mybox);
        }

        TEST_CASE("4", "Ƃ̃S~ɖ߂", TrashBox::current_box == &mybox);
    } END_CASE;

    BEGIN_CASE("2","isValid") {
        TrashBox mybox;

        TEST_CASE("1","S~͐", mybox.isValid());
        TEST_CASE("2","NULLُ͈", !((TrashBox *)0)->isValid());
    } END_CASE;

    BEGIN_CASE("3","operator new") {
        BEGIN_CASE("1","new TrashBoxbad_allocOԂ") {
            bool result = false;

            try { TrashBox * box = new TrashBox; }
            catch(bad_alloc) { result = true; }

            if(!result)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","new(nothrow) TrashBoxNULLԂ") {
            bool result = true;
            TrashBox * box;

            try { box = new(nothrow) TrashBox; }
            catch(...) { result = false; }

            TEST_CASE("1", "new(nothrow)͗OԂȂ", result);
            TEST_CASE("2", "new(nothrow)NULLԂ",   box == 0);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("4","{IȐ폜") {
        BEGIN_CASE("1","ƃS~O") {
            TrashBox mybox;

            DummyGarbage * garbage = new DummyGarbage;

            TEST_CASE("0","[O] S~Ă", std::find(mybox.garbage.begin(), mybox.garbage.end(), garbage) != mybox.garbage.end());
            delete garbage;
            TEST_CASE("1","S~Ă", std::find(mybox.garbage.begin(), mybox.garbage.end(), garbage) == mybox.garbage.end());


        } END_CASE;

        BEGIN_CASE("2","ẽS~ɓĂ̂S~O") {
            TrashBox mybox;
            DummyGarbage * garbage = new DummyGarbage;
            TEST_CASE("0","[O] S~Ă", find(mybox.garbage.begin(), mybox.garbage.end(), garbage) != mybox.garbage.end());

            TrashBox secondbox;
            delete garbage;

            TEST_CASE("1","S~Ă", find(mybox.garbage.begin(), mybox.garbage.end(), garbage) == mybox.garbage.end());
           
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("5","TrashBox::cleanup") {
        BEGIN_CASE("1","IɍIuWFNgjł") {
            TrashBox mybox;
            DummyGarbage * garbage;

            TestSuite::clearCheckpoints();

            garbage = new DummyGarbage;
            TEST_CASE("0","[O] RXgN^NĂ", TestSuite::isReached("DummyGarbage::DummyGarbage"));

            mybox.cleanup();
            TEST_CASE("1","fXgN^NĂ", TestSuite::isReached("DummyGarbage::~DummyGarbage"));
        } END_CASE;

#ifdef _MSC_VER
        BEGIN_CASE("2","O͂") {
            TrashBox mybox;
            DummyGarbage * garbage;

            TestSuite::clearCheckpoints();

            garbage = new DummyGarbage;
            garbage->throw_exception = true;

            bool result = false;
            try { mybox.cleanup(); }
            catch(...) { result = true; }

            if(!result)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","ONIuWFNgj󂳂Ă (2djɂȂȂ)") {
            TrashBox mybox;
            DummyGarbage * garbage;
            DummyGarbage * garbage2;

            TestSuite::clearCheckpoints();

            garbage = new DummyGarbage;
            garbage->throw_exception = true;
            garbage2 = new DummyGarbage;
            garbage2->throw_exception = true;

            try { mybox.cleanup(); }
            catch(...) {}
            try { mybox.cleanup(); }    //AccessViolationNȂ
            catch(...) {}

            if(!mybox.garbage.empty())
                TEST_FAIL;
        } END_CASE;
#endif

        BEGIN_CASE("4","폜̏") {
            TrashBox mybox;
            DummyGarbage * garbage;
            DummyGarbage * garbage2;
            DummyGarbage * garbage3;
            int g  = 0;
            int g2 = 0;
            int g3 = 0;

            TestSuite::clearCheckpoints();

            garbage  = new DummyGarbage(&g);
            garbage2 = new DummyGarbage(&g2);
            garbage3 = new DummyGarbage(&g3);

            mybox.cleanup();

            TEST_CASE("1","ŏɓo^ꂽ͍̂Ōɍ폜",g == 3);
            TEST_CASE("2","ɓo^ꂽ̂2Ԗڂɍ폜",g2 == 2);
            TEST_CASE("3","ɓo^ꂽ͍̂ŏɍ폜",g3 == 1);
        } END_CASE;

        BEGIN_CASE("5","gbvxłȂS~cleanupłȂ") {
            TrashBox outerbox;
            TrashBox innerbox;

            bool result = false;
            try {   outerbox.cleanup();   }
            catch(std::runtime_error)
            {   result = true;   }

            if(!result)
                TEST_FAIL;
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("6","fXgN^ɂj") {
        BEGIN_CASE("1","IɍIuWFNgjł (TrashBox::~TrashBox)") {
            {
                TrashBox mybox;
                DummyGarbage * garbage;

                TestSuite::clearCheckpoints();

                garbage = new DummyGarbage;
                TEST_CASE("0","[O] RXgN^NĂ", TestSuite::isReached("DummyGarbage::DummyGarbage"));
            }
            TEST_CASE("1","fXgN^NĂ", TestSuite::isReached("DummyGarbage::~DummyGarbage"));
        } END_CASE;

        BEGIN_CASE("2","O͂Ȃ") {
            bool result = true;
            try{
                TrashBox mybox;
                DummyGarbage * garbage;

                TestSuite::clearCheckpoints();

                garbage = new DummyGarbage;
                TEST_CASE("0","[O] RXgN^NĂ", TestSuite::isReached("DummyGarbage::DummyGarbage"));
            }
            catch(...)
            { result = false; }
            TEST_CASE("1","O͂Ȃ", result);
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("7","rescue") {
        DummyGarbage * garbage;
        {
            TrashBox mybox;
            garbage = new DummyGarbage;
            garbage->rescue();

            TestSuite::clearCheckpoints();
        }
        TEST_CASE("1","rescueS~͍폜Ȃ", !TestSuite::isReached("DummyGarbage::~DummyGarbage"));
        delete garbage;
    } END_CASE;

    BEGIN_CASE("8","ÓIȃIuWFNgdjȂ") {
        TrashBox outerbox;
        {
            DummyGarbage garbage;
            TrashBox innerbox;
            DummyGarbage garbage2;

            TEST_CASE("0","[O] RXgN^NĂ", TestSuite::isReached("DummyGarbage::DummyGarbage"));
        }   //2djMACVɂȂȂ
    } END_CASE;
}

#endif



