/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: mpstrstream.h 1 2008-08-22 05:57:26Z koban $
 */

#ifndef MPSTRSTREAM_H
#define MPSTRSTREAM_H

#ifdef _MSC_VER
#  pragma warning(disable:4290) //C++ ̗O̎w͖܂B֐ __declspec(nothrow) łȂƂ̂ݕ\܂B
#  pragma warning(disable:4786) //fobOŎʎq255ɐ؂̂Ă܂B
#endif

#include "testsuite.h"
#include "base/except.h"
#include "base/message.h"
#include "base/event.h"

#include <fstream>
#include <sstream>
#include <string>
#include <list>


    //ʂȂo͗pXg[̃NX
class MultipartStream : public Event<ShutdownEvent>::Handler
{
public:

        //ʂȂo͗pXg[̈ꕔʂɑNX
    class Part
    {
    protected:
        std::string       name;
        std::stringstream stream;

    public:
            //RXgN^
        Part(std::string name) throw();
        Part(const Part & src) throw();

            //
        inline bool isValid(void) const throw()
        {   return (this != 0) && !name.empty() && stream.good();   }

            //Xg[ւ̏
        template<class T>
        Part & operator << ( T src ) throw(Exception)
        {
            if(isValid())
                stream << src;
            else
                ExceptionMessage("Operation was performed against an invalid stream.","ȃXg[ɑ΂đ삪s܂").throwException();

            return *this;
        }

            //Xg[ɏe󂯎
        std::string getContents(void) const throw(Exception);

            //Xg[̓e𒼐ڐݒ肷
        void setContents(std::string contents) throw(Exception);

            //Xg[̎Q
        inline const std::string & getName(void) const throw(Exception)
        {
            if(!isValid())
                ExceptionMessage("Operation was performed against an invalid stream.","ȃXg[ɑ΂đ삪s܂").throwException();
            return name;
        }

            //Zq
        inline Part & operator = (const Part & src) throw()
        {
            name = src.name;
            stream.clear();
            stream << src.stream.str();
        
            return *this;
        }

        TESTSUITE_PROTOTYPE(main)
    };


protected:
    std::string         filename;       //֘Atꂽt@C
    std::list<Part>     parts;          //ʏW()
    Part *              current;        //Ă镔
    bool                dirty;          //t@Cɏo͂vtrue (񂾂... ł͂ȂA܂o͂ĂȂǂ)
    bool                output;         //o͂ĂǂȂtrue

    virtual void handler(ShutdownEvent & evt)
    {   serialize();    }
  
public:
        //RXgN^
    MultipartStream(std::string filename = "") throw();

        //fXgN^
    virtual ~MultipartStream(void) throw();

        //
    inline bool isValid(void) const throw()
    {   return (this != 0) && !filename.empty();   }

        //t@C
    std::string setFilename(std::string filename) throw(Exception);
    std::string getFilename(void) const throw() { return filename; };

        //Xg[̓et@Cɏo
    bool serialize(void) throw(Exception);

        //ʂ̐
    MultipartStream & createPart(std::string name, bool precedence = false) throw(Exception);

        //ʂ̑I
    MultipartStream & movePart(std::string name) throw(Exception);

        //o͂邩ǂ̐ݒ
    inline void enableOutput(void) throw()
    {   if(isValid()) output = true;   }
    inline void disableOutput(void) throw()
    {   if(isValid()) output = false;   }

        //_[eBrbg̐ݒ
    inline void setDirty(bool _dirty = true) throw()
    {   dirty = _dirty;   }

        //o
    template <class T>
    inline MultipartStream & operator << ( T src ) throw(Exception)
    {
        if(this != 0 && current != 0) {
            setDirty();
            (*current) << src;
        }
        else
            ExceptionMessage("Invalid operation against an invalid object","ȃIuWFNgɑ΂v").throwException();
        return *this;
    }

        //ʂ̑I (Synonym)
    inline MultipartStream & operator[] (std::string name) throw(Exception)
    {   return movePart(name);   }

    TESTSUITE_PROTOTYPE(main)
};

#endif


