/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: mpstrstream.cpp 1 2008-08-22 05:57:26Z koban $
 */

#include "base/mpstrstream.h"

using namespace std;

/*
 *   ʂȂXg[̈ꕔʂɑNX
 */

    //RXgN^
MultipartStream::Part::Part(string _name) throw() : name(_name)
{}

    //Rs[RXgN^
MultipartStream::Part::Part(const MultipartStream::Part & src) throw() : name("")
{
    if(src.isValid()) {
        name.assign(src.name);
        setContents(src.getContents());
    }
}

    //Xg[ɏe󂯎
string MultipartStream::Part::getContents(void) const throw(Exception)
{
    string result;

    if(isValid())
        result = stream.str();
    else
        ExceptionMessage("Operation was performed against an invalid stream.","ȃXg[ɑ΂đ삪s܂").throwException();

    return result;
}

    //Xg[̓e𒼐ڐݒ肷
void MultipartStream::Part::setContents(string contents) throw(Exception)
{
    if(isValid()) {
        stream.clear();
        stream << contents;
    }
    else
        ExceptionMessage("Operation was performed against an invalid stream.","ȃXg[ɑ΂đ삪s܂").throwException();
}



/*
 *   ʂȂXg[̈ꕔʂɑNX
 */

    //RXgN^
MultipartStream::MultipartStream(string _filename) throw() : filename(_filename), current(0), dirty(false), output(true)
{
    dirty = isValid();  //łĂt@CȂƂȂ̂...   
}

MultipartStream::~MultipartStream(void) throw()
{
    if(isValid() && dirty) {
            //W
        try { serialize(); }
        catch(...) {}
    }
}

    //t@C̊֘At
string MultipartStream::setFilename(string _filename) throw(Exception)
{
    string result;

    if(this != 0) {
        if(!_filename.empty()) {
            result   = filename;
            filename = _filename;
            dirty    = isValid();
        }
        else
            ExceptionMessage("Empty filename should not be allowed.","̃t@C͎gpłȂ").throwException();
    }
    else
        ExceptionMessage("Invalid object can not perform the request.","ȃIuWFNgɑ΂v͎słȂ").throwException();

    return result;
}

    //t@Co ({Ƀt@Cɏo͂Ƃtrue)
bool MultipartStream::serialize(void) throw(Exception)
{
    bool result = false;

    if(isValid() && dirty && output) {

        fstream file(filename.c_str(), ios::out);
        if(file.is_open()) {
            list<Part>::iterator scope;

                //SĂ̕ʂ̓eo
            scope = parts.begin();
            while(scope != parts.end()) {
                file << scope->getContents();
                ++ scope;
            }

            file.close();
            dirty  = false;
            result = true;
        }
        else {
            ExceptionMessage("File could not open [%]","t@CJȂ [%]") << filename << throwException;
            disableOutput();    //fXgN^x킷̂
        }
    }
    else {
        if(!isValid())
            ExceptionMessage("Invalid object can not perform the request.","ȃIuWFNgɑ΂v͎słȂ").throwException();
    }

    return result;
}

    //ʂ̍쐬
MultipartStream & MultipartStream::createPart(string name, bool precedence) throw(Exception)
{
    if(this != 0) {
        list<Part>::iterator scope;
        list<Part>::iterator newnode;

            //OȂƂmF
        scope = parts.begin();
        while(scope != parts.end()) {
            if(scope->getName().compare(name) == 0) {
                ExceptionMessage("The part \"%\" is already created.","ʖ[%]͂łɗpĂ") << name << throwException;
                break;
            }
            ++ scope;
        }

            //OȂȂvfǉ
        if(scope == parts.end()) {
            
                //}ʒǔ
            if(current != 0) {
                scope = parts.begin();
                while(scope != parts.end() && &(*scope) != current)
                    ++ scope;

                    //}ʒu̒ (݈ʒuɂ炷 when precedence = false; )
                if(scope != parts.end() && !precedence)
                    ++ scope;
            }
            else
                scope = parts.end();

                //vf̑}
            newnode = parts.insert(scope, Part(name));
            current = &(*newnode);
        }
    }else
        ExceptionMessage("Invalid object can not perform the request.","ȃIuWFNgɑ΂v͎słȂ").throwException();

    return *this;
}

    //ʂ̑I
MultipartStream & MultipartStream::movePart(string name) throw(Exception)
{
    list<Part>::iterator scope;

    if(this != 0 && !name.empty()) {

            //Ov̂T
        scope = parts.begin();
        while(scope != parts.end()) {
            if(scope->getName() == name) {
                current = &(*scope);
                break;
            }
            ++ scope;
        }

            //Ȃ
        if(scope == parts.end())
            ExceptionMessage("Unknown part [%] specified.","Ȏʖ [%]") << name << throwException;
    }
    else{
        if(this == 0)
            ExceptionMessage("Invalid object can not perform the request.","ȃIuWFNgɑ΂v͎słȂ").throwException();
        else //if(name.empty()) //Oif̏Aif͏ɐ^
            ExceptionMessage("Empty identifier was passed as a name of part.","󕶎nꂽ").throwException();
    }

    return *this;
}


/********************************** eXgXB[g **********************************/

#ifdef TESTSUITE

#include "coverage_undefs.h"

#include <iomanip>
#include <cstdio>

#ifdef _MSC_VER
#  pragma warning(disable:4101)   //[Jϐ͈xgĂ܂
#endif

TESTSUITE_(main,Part, MultipartStream)
{
    BEGIN_CASE("constructor/isValid","RXgN^ / ") {
        BEGIN_CASE("1","Oō쐬Lȃp[g") {
            Part part("test");
            if(!part.isValid())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","OȂō쐬疳ȃp[gɂȂ") {
            Part part("");
            if(part.isValid())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","NULL͖ȃp[g") {
            if(((Part *)0)->isValid())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","NULLIuWFNgŃRs[RXgN^NĂsȂ") {
            Part * part = 0;
            Part work(*part);
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("operator <<","operator <<") {
        BEGIN_CASE("1", "o͂ł") {
            Part part("test");

            part << "test";

            if(part.stream.str().compare("test") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2", "iomanipg") {
            Part part("test");

            part << setw(8) << setbase(16) << setfill('0') << 0x1234567;

            if(part.stream.str().compare("01234567") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3", "ȃXg[ɏON") {
            Part part("");
            bool result = false;

            if(part.isValid())
                TEST_FAIL;

            Exception::setThrowControl(true);
            try {
                Message::selectLanguage(Message::NEUTRAL);
                part << setw(8) << setbase(16) << setfill('0') << 0x1234567;
            }
            catch(Exception & e) {
                if(e.getDetails().compare("Operation was performed against an invalid stream.") == 0)
                    result = true;
            }
            if(!result)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("getContents","getContents") {
        BEGIN_CASE("1", "e擾ł") {
            Part part("test");

            part << "test";

            if(part.getContents().compare("test") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2", "ēǂł܂ēǂ߂") {
            Part part("test");

            part << "abc";
            if(part.getContents().compare("abc") != 0)
                TEST_FAIL;

            part << "def";
            if(part.getContents().compare("abcdef") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3", "ȃXg[ǂ񂾂ON") {
            Part part("");
            bool result = false;

            if(part.isValid())
                TEST_FAIL;

            Exception::setThrowControl(true);
            try {
                string work = part.getContents();
            }
            catch(Exception & e) {
                if(e.getDetails().compare("Operation was performed against an invalid stream.") == 0)
                    result = true;
            }
            if(!result)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("setContents","setContents") {
        BEGIN_CASE("1", "ݒ肵e擾ł") {
            Part part("test");

            part.setContents("test");

            if(part.getContents().compare("test") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2", "setContentsŐݒ肵ƂɒǋLł") {
            Part part("test");

            part.setContents("abc");
            part << "def";
            if(part.getContents().compare("abcdef") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3", "ȃXg[ɐݒ肵ON") {
            Part part("");
            bool result = false;

            if(part.isValid())
                TEST_FAIL;

            Exception::setThrowControl(true);
            try {
                part.setContents("test");
            }
            catch(Exception & e) {
                if(e.getDetails().compare("Operation was performed against an invalid stream.") == 0)
                    result = true;
            }
            if(!result)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("getName","getName") {
        BEGIN_CASE("1", "p[g擾ł") {
            Part part("name_of_stream");

            if(part.getName().compare("name_of_stream") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2", "sȃp[g̖OƗON") {
            Part part("");
            bool result = false;

            Exception::setThrowControl(true);
            try { string work = part.getName(); }
            catch(Exception & e) {
                if(e.getDetails().compare("Operation was performed against an invalid stream.") == 0)
                    result = true;
            }
            if(!result)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("CopyConstructor","Rs[RXgN^") {
        Part source("test");
        source << "abcdefg";

        Part dest(source);
        BEGIN_CASE("1","Xg[̓eRs[łĂ") {
            if(dest.getContents().compare("abcdefg") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","ʖRs[łĂ") {
            if(dest.getName() != source.getName())
                TEST_FAIL;
        } END_CASE;
    } END_CASE;
}

TESTSUITE(main,MultipartStream)
{
    BEGIN_CASE("constructor/isValid","constructor/isValid") {
        BEGIN_CASE("1","t@Cw肵ĐIuWFNg͗L") {
            MultipartStream mps("test.dat");

            if(!mps.isValid())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","t@CȂIuWFNg͖") {
            MultipartStream mps;

            if(mps.isValid())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","̃t@CIuWFNg͖") {
            MultipartStream mps("");

            if(mps.isValid())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","NULLIuWFNg͖") {
            if(((MultipartStream *)0)->isValid())
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("setFilename","setFilename") {
        BEGIN_CASE("1","t@Cw肹ɐt@CɖO") {
            MultipartStream mps;
            if(mps.isValid())
                TEST_FAIL;

            BEGIN_CASE("1","Xg[͗LɂȂ") {
                mps.setFilename("test");
                if(!mps.isValid())
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2","Xg[̖OύXĂ") {
                if(mps.filename.compare("test") != 0)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("2","t@Cw肵Đt@CɖO") {
            MultipartStream mps("initialname");
            if(!mps.isValid())
                TEST_FAIL;

            BEGIN_CASE("1","Xg[͗LɂȂ") {
                mps.setFilename("test");
                if(!mps.isValid())
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2","Xg[̖OύXĂ") {
                if(mps.filename.compare("test") != 0)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("3","󕶎nƗO") {
            MultipartStream mps;
            bool result = false;

            Exception::setThrowControl(true);
            try { mps.setFilename(""); }
            catch(Exception & e)
            {   result = true;   }
            if(!result)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","NULLIuWFNgɖOƗO") {
            bool result = false;

            Exception::setThrowControl(true);
            try { ((MultipartStream *)0)->setFilename("test"); }
            catch(Exception & e)
            {   result = true;   }
            if(!result)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("serialize","serialize") {

        BEGIN_CASE("1", "NULLIuWFNgɑ΂VACY͗O") {
            bool result = false;

            Exception::setThrowControl(true);
            try 
            {   ((MultipartStream *)0)->serialize();   }
            catch(Exception & e)
            {   result = true;   }

            if(!result)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2", "ȃIuWFNgɑ΂VACYO") {
            bool result = false;
            MultipartStream mps;

            Exception::setThrowControl(true);
            try
            {   mps.serialize();   }
            catch(Exception & e)
            {   result = true;   }

            if(!result)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3", "ɃVACYł") {
            MultipartStream mps("debug.out");
            Part part("abc");

            part << "abcdefg";
            mps.parts.push_back(part);
            mps.dirty = true;

            ::remove("debug.out");
            BEGIN_CASE("1", "VACYtrueԂ") {
                if(!mps.serialize())
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2", "o͂t@C̓e") {
                if(!TestSuite::compareFileContents("debug.out","abcdefg"))
                    TEST_FAIL;
            } END_CASE;
            
        } END_CASE;

        BEGIN_CASE("4", "eĂdirty=falseȂo͂Ȃ") {
            MultipartStream mps("debug.out");
            Part part("abc");

            part << "abcdefg";
            mps.parts.push_back(part);
            mps.dirty = false;

            ::remove("debug.out");
            BEGIN_CASE("1", "VACYfalseԂ") {
                if(mps.serialize())
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2", "t@C͏o͂ĂȂ") {
                fstream file("debug.out",ios::in);
                if(file.is_open())
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("5", "eĂo͋֎~Ȃo͂Ȃ") {
            MultipartStream mps("debug.out");
            Part part("abc");

            part << "abcdefg";
            mps.parts.push_back(part);
            mps.dirty = true;

            mps.disableOutput();

            ::remove("debug.out");
            BEGIN_CASE("1", "VACYfalseԂ") {
                if(mps.serialize())
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2", "t@C͏o͂ĂȂ") {
                fstream file("debug.out",ios::in);
                if(file.is_open())
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("Destructor","Destructor") {
        BEGIN_CASE("1","ĉ") {
            MultipartStream mps("debug.out");
            Part part("abc");

            part << "abcdefg";
            mps.parts.push_back(part);
            mps.dirty = true;

            ::remove("debug.out");
        } END_CASE;

        BEGIN_CASE("2","et@CɊi[Ă") {
            if(!TestSuite::compareFileContents("debug.out","abcdefg"))
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("createPart","createPart") {
        BEGIN_CASE("1","p[go^") {
            MultipartStream mps("debug.out");
            mps.disableOutput();

            BEGIN_CASE("1","OȂo^ł") {
                Exception::setThrowControl(true);
                mps .createPart("abc")
                    .createPart("def")
                    .createPart("ghi");
            } END_CASE;

            BEGIN_CASE("2","go^ŕł") {
                list<Part>::iterator scope;
                scope = mps.parts.begin();
                if(scope->getName().compare("abc") != 0)
                    TEST_FAIL;
                ++ scope;
                if(scope->getName().compare("def") != 0)
                    TEST_FAIL;
                ++ scope;
                if(scope->getName().compare("ghi") != 0)
                    TEST_FAIL;
                ++ scope;
                if(scope != mps.parts.end())
                    TEST_FAIL;
            } END_CASE;

        } END_CASE;

        BEGIN_CASE("2","p[gtœo^") {
            MultipartStream mps("debug.out");
            mps.disableOutput();

            BEGIN_CASE("1","OȂo^ł") {
                Exception::setThrowControl(true);
                mps .createPart("abc",true)
                    .createPart("def",true)
                    .createPart("ghi",true);
            } END_CASE;

            BEGIN_CASE("2","go^tŕł") {
                list<Part>::iterator scope;
                scope = mps.parts.begin();
                if(scope->getName().compare("ghi") != 0)
                    TEST_FAIL;
                ++ scope;
                if(scope->getName().compare("def") != 0)
                    TEST_FAIL;
                ++ scope;
                if(scope->getName().compare("abc") != 0)
                    TEST_FAIL;
                ++ scope;
                if(scope != mps.parts.end())
                    TEST_FAIL;
            } END_CASE;

        } END_CASE;

        BEGIN_CASE("3","NULLɑ΂鑀ŗO") {
            bool result = false;
            Exception::setThrowControl(true);
            try {
                ((MultipartStream *)0)->createPart("test");
            }
            catch(...)
            {   result = true;   }
            if(!result)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","Õp[gƗON") {
            BEGIN_CASE("1","Õp[gƗON") {
                bool result = false;
                MultipartStream mps("debug.out");
                Exception::setThrowControl(true);

                try {
                    mps .createPart("abc")
                        .createPart("def")
                        .createPart("abc");
                }
                catch(...)
                {   result = true;   }

                if(!result)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2","O𕕂Ă") {
                bool result = true;
                MultipartStream mps("debug.out");
                Exception::setThrowControl(false);

                BEGIN_CASE("1","O̓X[Ȃ") {
                try {
                        mps .createPart("abc")
                            .createPart("def")
                            .createPart("abc");
                    }
                    catch(...)
                    {   result = false;   }

                    if(!result)
                        TEST_FAIL;
                } END_CASE;

                BEGIN_CASE("2","݈ʒu͕ωȂ") {
                    if(mps.current == 0 || mps.current->getName().compare("def") != 0)
                        TEST_FAIL;
                } END_CASE;
            } END_CASE;
        } END_CASE;

        Exception::setThrowControl(true);

        BEGIN_CASE("5","o^ƌ݈ʒuω") {
            MultipartStream mps("debug.out");
            mps.disableOutput();

            BEGIN_CASE("1","o^ƈʒuω (1)") {
                mps.createPart("abc");
                if(mps.current == 0 || mps.current->getName().compare("abc") != 0)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2","o^ƈʒuω (2)") {
                mps.createPart("def");
                if(mps.current == 0 || mps.current->getName().compare("def") != 0)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("3","o^ƈʒuω (3)") {
                mps.createPart("ghi");
                if(mps.current == 0 || mps.current->getName().compare("ghi") != 0)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("opeator <<","operator <<") {

        BEGIN_CASE("1","operator <<g") {
            MultipartStream mps("debug.out");

            mps.createPart("test");

            mps << "abcdefghijklmn";
        } END_CASE;

        BEGIN_CASE("2","o͂ꂽg") {
            if(!TestSuite::compareFileContents("debug.out","abcdefghijklmn"))
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","NULLIuWFNgɏo͂ƗO") {
            bool result = false;
            Exception::setThrowControl(true);
            try {
                *((MultipartStream *)0) << "test";
            }
            catch(...)
            {   result = true;   }
            if(!result)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","p[gSĂȂIuWFNgɏo͂ƗO") {
            bool result = false;
            Exception::setThrowControl(true);
            try {
                MultipartStream mps("debug.out");
                mps.disableOutput();
                *((MultipartStream *)0) << "test";
            }
            catch(...)
            {   result = true;   }
            if(!result)
                TEST_FAIL;
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("movePart/operator []","movePart/operator []") {
        BEGIN_CASE("1","ʂɈړ") {
            MultipartStream mps("debug.out");
            mps.disableOutput();

            mps .createPart("abc")
                .createPart("def")
                .createPart("ghi");

            BEGIN_CASE("1","ړł") {
                mps.movePart("def");

                if(mps.current->getName().compare("def") != 0)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("2","ȖOƗO") {
                bool result = false;
                Exception::setThrowControl(true);

                try {
                    mps.movePart("unknwon");
                }
                catch(...)
                {   result = true;   }
                if(!result)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("3","󕶎ƗO") {
                bool result = false;
                Exception::setThrowControl(true);

                try {
                    mps.movePart("");
                }
                catch(...)
                {   result = true;   }
                if(!result)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("2", "NULLIuWFNgɑ삷ƗO") {
            bool result = false;
            Exception::setThrowControl(true);

            try {
                ((MultipartStream *)0)->movePart("");
            }
            catch(...)
            {   result = true;   }
            if(!result)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;
}


#endif




