/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */


#ifndef FILECONTAINER_H
#define FILECONTAINER_H

#ifdef _MSC_VER
#pragma warning(disable:4786) //fobO255ɐ؂l߂܂
#endif

#include "testsuite.h"

#include <string>
#include <map>

#include "base/except.h"
#include "base/message.h"
#include "base/collection.h"

class FileContainer : public RuntimeObject
{
public:
    typedef unsigned long address_t;

    struct tagVariableInfo {
        address_t  address;
        union {
            size_t     size;
            int        value;
        };
    };

    enum tagByteOrder { LITTLE, BIG, HOSTORDER=LITTLE, UNKNOWN };   /* UNKNOWN̓eXgp */

protected:
    enum tagByteOrder byteorder;

    std::map<std::string, struct tagVariableInfo> variableinfo;

    FileContainer(void) throw() : byteorder(HOSTORDER) {}
    virtual ~FileContainer(void) throw() {}

public:
        /* C^tF[X */
    virtual void                    attachModule(const std::string & filename) throw(Exception) = 0;
    virtual void                    loadContents(void * dest, address_t address, size_t size) throw(Exception) = 0;
    virtual address_t               getSymbolAddress(const std::string & symbol) throw(Exception) = 0;
    virtual std::string             getArchitecture(void) throw(Exception) = 0;

    virtual struct tagVariableInfo  getVariableInfo(const std::string & name) throw(Exception);
    virtual void                    attachInfo(const std::string & filename) throw(Exception);

        /* o^ĂReǐĂяo */
    static inline FileContainer * getInstance(void) throw(Exception)
    {
        FileContainer * result;
        RuntimeObjectTable::getInstance(&result);
        if(result == 0)
            ExceptionMessage("[Internal error] Filecontainer has no instance.","[G[] FileContainer̃CX^X܂").throwException();
        return result;
    }

    enum tagByteOrder getByteOrder(void) const
    {   return byteorder;   }
};

class TargetVariableBase
{
protected:
    FileContainer::address_t address;               //ϐ̃AhX
    size_t                   size;                  //ϐ̃TCY
    size_t                   offset;                //\̂̐擪̃ItZbg
    size_t                   structure_size;        //\̂̑傫
    bool                     loaded;                //lǏoς݂ł邱ƂێtO

    inline TargetVariableBase(FileContainer::address_t _address, size_t _size) throw()
        : address(_address), size(_size), offset(0), structure_size(_size), loaded(false)
    {}

    inline TargetVariableBase(FileContainer::address_t addr, size_t sz, size_t ofs, size_t ssz) throw()
        : address(addr), size(sz), offset(ofs), structure_size(ssz), loaded(false)
    {}
    
    TargetVariableBase(const std::string & sym) throw();
    TargetVariableBase(const std::string & sym, size_t _size) throw();
    TargetVariableBase(const std::string & sym, const std::string & sz) throw();
    TargetVariableBase(const TargetVariableBase & src) throw();

    virtual ~TargetVariableBase(void) throw() {}

        /* e̎擾 */
    void loadContent(void * dest, size_t dest_size) throw(Exception);

        /* GfBAϊ */
    void changeEndian(char * buffer, size_t size) throw();

        /* AhẌړ (łloaded) */
    inline void setAddress(int offset) throw()
    {
        if(isValid()) {
            address += offset;
            loaded   = false;
        }
    }

public:
    inline bool isValid(void) const throw()
    {   return this != 0 && address != 0 && size != 0 && structure_size != 0;   }

    inline size_t getSize(void) const throw()
    {   return this != 0 ? size : 0;   }

    inline size_t getOffset(void) const throw()
    {   return this != 0 ? offset : 0;   }

    inline size_t getStructureSize(void) const throw()
    {   return this != 0 ? structure_size : 0;   }

    inline FileContainer::address_t getAddress(void) const throw()
    {   return this != 0 ? address : 0;   }

    inline bool isLoaded(void) const throw()
    {   return this != 0 ? loaded : false;   }

        /* {Iȑ */
    inline bool operator == (const TargetVariableBase & right) const throw()
    {   return isValid() && right.isValid() && address == right.address;   }

    inline bool operator != (const TargetVariableBase & right) const throw()
    {   return ! operator ==(right);   }

    inline FileContainer::address_t operator & (void) const throw()
    {   return isValid() ? address + offset : 0;   }

    inline size_t sizeOf(void) const throw()
    {   return isValid() ? size : 0;   }
};

template<class T>
class TargetVariable : public TargetVariableBase
{
protected:
    T    entity;

public:
        /*
         * RXgN^ (TargetVariableBaseɉ)
         */
    inline TargetVariable(FileContainer::address_t addr) throw()
        : TargetVariableBase(addr, sizeof(T)), entity() 
    {}

    inline TargetVariable(FileContainer::address_t addr, size_t sz) throw()
        : TargetVariableBase(addr, sz), entity() 
    {}

    inline TargetVariable(FileContainer::address_t addr, size_t sz, size_t ofs, size_t ssz) throw()
        : TargetVariableBase(addr, sz, ofs, ssz), entity() 
    {}

    inline TargetVariable(const std::string & sym) throw()
        : TargetVariableBase(sym), entity()
    {}

    inline TargetVariable(const std::string & sym, const std::string & sz) throw()
        : TargetVariableBase(sym, sz), entity() 
    {}

    inline TargetVariable(const TargetVariable<T> & src) throw()
        : TargetVariableBase(src), entity()
    {
        if(isValid() && src.isValid()) {
            loaded = src.loaded;
            entity = src.entity;
        }
    }

        /* fXgN^ (ɉȂ) */
    virtual ~TargetVariable(void) throw() 
    {}

        /* Ɋi[ɏ\ȃTCY邩ǂǉĂ */
    inline bool isValid(void) const
    {   return TargetVariableBase::isValid() && (sizeof(T) >= getSize());   }

        /*
         * |C^̓Iy[^Q
         */
    inline TargetVariable<T> offsetInBytes(int offset) const throw()
    {   return TargetVariable<T>(getAddress() + offset, getSize(), getOffset(), getStructureSize());   }

    inline TargetVariable<T> operator + (int index) const throw()
    {   return offsetInBytes(index * static_cast<int>(getStructureSize()));   }

    inline TargetVariable<T> operator - (int index) const throw()
    {   return offsetInBytes(- index * static_cast<int>(getStructureSize()));   }

    inline TargetVariable<T> operator ++ (int) throw()
    {
        TargetVariable<T> result(*this);
        ++ (*this);
        return result;
    }

    inline TargetVariable<T> operator -- (int) throw()
    {
        TargetVariable<T> result(*this);
        -- (*this);
        return result;
    }

    inline TargetVariable<T> & operator ++ (void) throw()
    {
        setAddress(static_cast<int>(getStructureSize()));
        return *this;
    }

    inline TargetVariable<T> & operator -- (void) throw()
    {  
        setAddress(-static_cast<int>(getStructureSize()));   
        return *this;
    }

    inline TargetVariable<T> & operator += (int sz) throw()
    {   
        setAddress(static_cast<int>(getStructureSize()) * sz);   
        return *this;
    }

    inline TargetVariable<T> & operator -= (int sz) throw()
    {   
        setAddress(-static_cast<int>(getStructureSize()) * sz);   
        return *this;
    }

    inline const T & operator * (void) throw(Exception)
    {
        if(!isLoaded())
            loadContent(&entity, sizeof(T));
        return entity;
    }

    inline T operator [] (int index) const throw(Exception)
    {   return * TargetVariable<T>(getAddress() + index * getStructureSize(), getSize(), getOffset(), getStructureSize());   }
};

#endif

