/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

#ifdef _MSC_VER
#pragma warning(disable:4786) //fobO255ɐ؂l߂
#endif

#include "base/filecontainer.h"
#include <memory.h>
#include <fstream>

using namespace std;

namespace {
        /* Ȃ10ĩp[X */
    char * parse_uint(char * src, unsigned int * dest, unsigned int default_value = 0)
    {
        int result = 0;

        if(*src < '0' || *src > '9') {
            *dest = default_value;
            return src;
        }

        do {
            result = result * 10 + *(src++) - '0';
        } while(*src >= '0' && *src <='9');

        *dest = result;
        return src;
    }
}

    /* ϐ̓ǂݍ */
void FileContainer::attachInfo(const string & filename) throw(Exception)
{
    char    buffer[256];
    fstream file;

    char * work;
    struct tagVariableInfo info;

    memset(&info, 0, sizeof(info));

    file.open(filename.c_str(), ios::in);
    if(!file.is_open()) {
        ExceptionMessage("Structure information file(%) was not found. ","\̏t@C(%)܂ ") << filename << throwException;
        return;
    }

    while(!file.eof())
    {
        file.get(buffer, 256);

        if(!file.fail()) {
            switch(buffer[0])
            {
            case 's':
                {
                    unsigned int address = 0;
                    unsigned int size    = 0;

                    work = buffer+1;
                    while(*work != ',' && *work != '\x0')
                        work++;
                    if(*work != '\x0') {
                        *work = '\x0';
                        work = parse_uint(work+1,&size);
                        work = parse_uint(work+1,&address);
                    }

                    info.address = static_cast<address_t>(address);
                    info.size    = static_cast<size_t>(size);
                    variableinfo[string(buffer+1)] = info;
                    break;
                }

            case 'd':   //ʎq͖
                break;

            default:
                ExceptionMessage("Unknown information type identifier found - [%]","m̌^ʎq - [%]") << buffer[0] << throwException;
            }
        }
        else
            file.clear();

        file.get();
    }

    file.close();
}

    /* ϐ̎擾 */
struct FileContainer::tagVariableInfo FileContainer::getVariableInfo(const string & name) throw(Exception)
{
    map<string, tagVariableInfo>::const_iterator scope;

    scope = variableinfo.find(name);
    if(scope == variableinfo.end()) {
        ExceptionMessage("Operation against the unknwon symbol [%] was rejected.","sȃV{ [%] ̏擾悤ƂĂ܂") << name << throwException;

        struct tagVariableInfo dummy;
        memset(&dummy, 0, sizeof(dummy));
        return dummy;
    }

    return scope->second;
}


    /* RXgN^ (V{w肵ď) */
TargetVariableBase::TargetVariableBase(const std::string & sym) throw() 
    : address(0), size(0), offset(0), structure_size(0), loaded(false)
{
    try{
        FileContainer * fc = FileContainer::getInstance();
        address = fc->getSymbolAddress(sym);
        size    = fc->getVariableInfo(sym).size;
        structure_size = size;
    }
    catch(...) {
        address = 0;
        size    = 0;
    }
}

    /* RXgN^ (V{, f[^w肵ď) */
TargetVariableBase::TargetVariableBase(const string & sym, size_t _size) throw() 
    : address(0), size(_size), offset(0), structure_size(_size), loaded(false)
{
    try{
        FileContainer * fc = FileContainer::getInstance();
        address = fc->getSymbolAddress(sym);
    }
    catch(...) {
        address = 0;
        size    = 0;
    }
}

    /* RXgN^ (V{Aow肵ď) */
TargetVariableBase::TargetVariableBase(const string & sym, const string & sz) throw() 
    : address(0), size(0), offset(0), structure_size(0), loaded(false)
{
    try{
        FileContainer * fc = FileContainer::getInstance();
        address = fc->getSymbolAddress(sym);                                //\̂̐擪AhX
        size    = fc->getVariableInfo(sz).size;                             //oϐ̒
        offset  = static_cast<size_t>(fc->getVariableInfo(sz).address);     //oϐ̃ItZbg
        structure_size = fc->getVariableInfo(sym).size;                     //\̂̒
    }
    catch(...) {
        address = 0;
        size    = 0;
    }
}

    /* Rs[RXgN^ */
TargetVariableBase::TargetVariableBase(const TargetVariableBase & src) throw()
    : address(0), size(0), offset(0), structure_size(0), loaded(false)
{
    if(src.isValid()) {
        address        = src.address;
        size           = src.size;
        offset         = src.offset;   
        structure_size = src.structure_size;
        loaded         = false;
    }
}


    /* IuWFNge̎擾 */
void TargetVariableBase::loadContent(void * dest, size_t dest_size) throw(Exception)
{
    char * buffer = 0;

    try {
        if(isValid()) {
            buffer = new char[getSize()];
            FileContainer * fc = FileContainer::getInstance();

            fc->loadContents(buffer, getAddress() + getOffset(), getSize());
            if(fc->getByteOrder() != FileContainer::HOSTORDER)
                changeEndian(buffer, getSize());

            if(size < dest_size)
                memset(dest, 0, dest_size);
            else if(size > dest_size)
                ExceptionMessage("[TargetVariableBase::loadContent] Destination storage is too small to store the contents.","[TargetVariableBase::loadContent] o͐obt@̃TCY܂").throwException();
            memcpy(dest, buffer, getSize());

            delete [] buffer;
            loaded = true;
        }
        else {
            ExceptionMessage("loadContent was performed with an illegal target variable.","sȃ^[QbgϐloadContentĂ΂܂").throwException();
        }
    }
    catch(bad_alloc &) {
        ExceptionMessage("No available memory [%B]","sł [%B]") << (unsigned int)getSize() << throwException;
    }
    catch(Exception &) {
        if(buffer)
            delete [] buffer;
        throw;
    }
}

    /* oCgI[_̕ύX */
void TargetVariableBase::changeEndian(char * buffer, size_t size) throw()
{
    char * tail = buffer + size - 1;

    while(buffer < tail) {
        char temporary = *buffer;
        *buffer = *tail;
        *tail   = temporary;

        ++ buffer;
        -- tail;
    }
}



//---------------------------------------------

#ifdef TESTSUITE
#include "base/coverage_undefs.h"

#include <cctype>
#define _isprint(x) isprint(x)

class TFileContainer : public FileContainer
{
public:
    TFileContainer(void) throw() {}
    virtual ~TFileContainer(void) throw() {}

    string module;
    void attachModule(const std::string & _module) throw(Exception) 
    {
        CHECKPOINT("attachModule"); 
        module = _module;
    }

    void *    dest;
    address_t addr;
    size_t    sz;
    void loadContents(void * _dest, address_t _addr, size_t _sz) throw(Exception) 
    {
        CHECKPOINT("loadContents");
        dest = _dest;
        addr = _addr;
        sz   = _sz;
        memset(_dest, ~0, _sz);
    }

    string symbol;
    address_t getSymbolAddress(const std::string & _symbol) throw(Exception) 
    {
        CHECKPOINT("getSymbolAddress");
        symbol = _symbol;
        return 1; 
    }

    std::string getArchitecture(void) throw(Exception)
    {   return "TFileContainer";   }

    TESTSUITE_PROTOTYPE(main)
};

TESTSUITE(main, TFileContainer)
{
    PREDECESSOR("SingletonBase");
    PREDECESSOR("RuntimeObjectTable");

    SingletonBase::ContextChain chain;
    chain.saveContext<RuntimeObjectTable>();
    chain.renewInstance();

    BEGIN_CASE("getInstance","getInstance") {
        BEGIN_CASE("1","o^ĂȂƂgetInstanceŗO") {
            bool result = false;
            try { FileContainer::getInstance(); } catch(Exception &) { result = true; }
            if(!result)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","getInstanceŃCX^XԂ") {
            TFileContainer fc;
            FileContainer * instance;
            bool result = true;
            try { instance = FileContainer::getInstance(); } catch(...) { result = false; }
            TEST_CASE("1","O͂Ȃ", result);
            TEST_CASE("2","擾łCX^X", instance == &fc);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("parse_uint","parse_uint") {
        BEGIN_CASE("1","؂o") {
            unsigned int dest;
            char * src = "123";
            char * result = parse_uint(src, &dest);

            TEST_CASE("1","resultŌɗĂ", result == src + 3);
            TEST_CASE("2","l͐", dest == 123);
        } END_CASE;

        BEGIN_CASE("2","Ŗ^ƃftHglԂ") {
            unsigned int dest;
            char * src = "abc";
            char * result = parse_uint(src, &dest, 1234567);

            TEST_CASE("1","result͐iłȂ", result == src);
            TEST_CASE("2","ftHglԂ", dest == 1234567);
        } END_CASE;

        BEGIN_CASE("3","f~^łƂ܂") {
            unsigned int dest;
            char * src = "321,123";
            char * result = parse_uint(src, &dest);

            TEST_CASE("1","result͐iłȂ", result == src + 3);
            TEST_CASE("2","ftHglԂ", dest == 321);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("attachInfo","attachInfo") {
        BEGIN_CASE("1","ʂɏ") {
            fstream file("dummy",ios::out);
            file << "s_kernel_tinib_table,32,0\nstask_initialization_block::texrtn,4,28\n";
            file.close();

            TFileContainer fc;

            bool result = true;
            try { fc.attachInfo("dummy"); } catch(...) { result = false; }

            TEST_CASE("1","O͂Ȃ", result);

            map<string, struct tagVariableInfo>::iterator scope = fc.variableinfo.find("_kernel_tinib_table");
            TEST_CASE("2","vfǉĂ (tinib)", scope != fc.variableinfo.end());
            TEST_CASE("3","l (tinib)", scope->second.size == 32);

            scope = fc.variableinfo.find("task_initialization_block::texrtn");
            TEST_CASE("4","vfǉĂ (texrtn)", scope != fc.variableinfo.end());
            TEST_CASE("5","l (texrtn.size)", scope->second.size == 4);
            TEST_CASE("6","l (texrtn.address)", scope->second.address == 28);
        } END_CASE;
        remove("dummy");

        BEGIN_CASE("2","ʕ 'd' 𖳎") {
            fstream file("dummy",ios::out);
            file << "ddummy,0\ndtask_initialization_block::texrtn,4,28\n";
            file.close();

            TFileContainer fc;

            bool result = true;
            try { fc.attachInfo("dummy"); } catch(...) { result = false; }

            TEST_CASE("1","O͂Ȃ", result);
            TEST_CASE("2","vf͒ǉĂȂ", fc.variableinfo.size() == 0);
        } END_CASE;
        remove("dummy");

        BEGIN_CASE("3","s𖳎ł") {
            fstream file("dummy",ios::out);
            file << "s_kernel_tinib_table,32,0\n\nstask_initialization_block::texrtn,4,28\n";
            file.close();

            TFileContainer fc;

            bool result = true;
            try { fc.attachInfo("dummy"); } catch(...) { result = false; }

            TEST_CASE("1","O͂Ȃ", result);

            map<string, struct tagVariableInfo>::iterator scope = fc.variableinfo.find("_kernel_tinib_table");
            TEST_CASE("2","vfǉĂ (tinib)", scope != fc.variableinfo.end());
            TEST_CASE("3","l (tinib)", scope->second.size == 32);

            scope = fc.variableinfo.find("task_initialization_block::texrtn");
            TEST_CASE("4","vfǉĂ (texrtn)", scope != fc.variableinfo.end());
            TEST_CASE("5","l (texrtn.size)", scope->second.size == 4);
            TEST_CASE("6","l (texrtn.address)", scope->second.address == 28);
        } END_CASE;
        remove("dummy");

        BEGIN_CASE("4","'s''d'ȊO͂") {
            char c;
            char msg[2] = {0, 0};

            for(c=0;c<128;++c) {
                if(isprint(c) && (c != 's' && c != 'd')) {
                    fstream file("dummy",ios::out);
                    file << c;
                    file << "dummy,0\n";
                    file.close();

                    TFileContainer fc;

                    bool result = false;
                    try { fc.attachInfo("dummy"); } catch(...) { result = true; }

                    msg[0] = c;
                    TEST_CASE_("1","O", result, string(msg));
                    TEST_CASE_("2","vf͒ǉĂȂ", fc.variableinfo.size() == 0, string(msg));
                }
            }
        } END_CASE;
        remove("dummy");
    } END_CASE;

    chain.restoreContext();
}

class TTargetVariable : public TargetVariable<int>
{
    TESTSUITE_PROTOTYPE(main)

        /*
         * RXgN^ (TargetVariable<int>ɉ)
         */
    inline TTargetVariable(FileContainer::address_t addr) throw()
        : TargetVariable<int>(addr)
    {}
    
    inline TTargetVariable(FileContainer::address_t addr, size_t sz) throw()
        : TargetVariable<int>(addr, sz)
    {}

    inline TTargetVariable(FileContainer::address_t addr, size_t sz, size_t ofs, size_t ssz) throw()
        : TargetVariable<int>(addr, sz, ofs, ssz)
    {}

    inline TTargetVariable(const std::string & sym) throw()
        : TargetVariable<int>(sym)
    {}

    inline TTargetVariable(const std::string & sym, const std::string & sz) throw()
        : TargetVariable<int>(sym, sz)
    {}

        /* fXgN^ (ɉȂ) */
    virtual ~TTargetVariable(void) throw() 
    {}
};

TESTSUITE(main, TTargetVariable)
{
    PREDECESSOR("SingletonBase");
    PREDECESSOR("TFileContainer");
    PREDECESSOR("RuntimeObjectTable");

    SingletonBase::ContextChain chain;
    chain.saveContext<RuntimeObjectTable>();
    chain.renewInstance();

    TFileContainer fc;
    fstream file("dummy",ios::out);
    file << "s_test,4,0\ns_kernel_tinib_table,32,0\nstask_initialization_block::texrtn,4,28\n";
    file.close();

    fc.attachInfo("dummy");

    BEGIN_CASE("constructor","RXgN^") {
        BEGIN_CASE("1", "(address_t, size_t)") {
            TTargetVariable tv(1, 2);

            TEST_CASE("1","ϐ͗L", tv.isValid());
            TEST_CASE("2","AhX͐", tv.getAddress() == 1);
            TEST_CASE("3","TCY͐", tv.getSize() == 2);
            TEST_CASE("4","ItZbg0", tv.getOffset() == 0);
            TEST_CASE("5","\̃TCY͕ϐTCYƈꏏ", tv.getStructureSize() == tv.getSize());
        } END_CASE;

        BEGIN_CASE("2","(address_t, size_t, size_t, size_t)") {
            TTargetVariable tv(1,2,3,4);

            TEST_CASE("1","ϐ͗L", tv.isValid());
            TEST_CASE("2","AhX͐", tv.getAddress() == 1);
            TEST_CASE("3","TCY͐", tv.getSize() == 2);
            TEST_CASE("4","ItZbg͐", tv.getOffset() == 3);
            TEST_CASE("5","\̃TCY͐", tv.getStructureSize() == 4);
        } END_CASE;

        BEGIN_CASE("3","(string)") {
            TestSuite::clearCheckpoints();

            TTargetVariable tv("_test");

            TEST_CASE("1","ϐ͗L", tv.isValid());
            TEST_CASE("2","getSymbolAddressR[Ă", TestSuite::isReached("getSymbolAddress"));
            TEST_CASE("3","getSymbolAddress̈", fc.symbol.compare("_test") == 0);
            TEST_CASE("3","AhX͐", tv.getAddress() == 1);
            TEST_CASE("4","TCY͐", tv.getSize() == 4);
            TEST_CASE("5","ItZbg͐", tv.getOffset() == 0);
            TEST_CASE("6","\̃TCY͐", tv.getStructureSize() == 4);
        } END_CASE;

        BEGIN_CASE("4","(string,string)") {
            TestSuite::clearCheckpoints();

            TTargetVariable tv("_kernel_tinib_table", "task_initialization_block::texrtn");

            TEST_CASE("1","ϐ͗L", tv.isValid());
            TEST_CASE("2","getSymbolAddressR[Ă", TestSuite::isReached("getSymbolAddress"));
            TEST_CASE("3","getSymbolAddress̈", fc.symbol.compare("_kernel_tinib_table") == 0);
            TEST_CASE("3","AhX͐", tv.getAddress() == 1);
            TEST_CASE("4","TCY͐", tv.getSize() == 4);
            TEST_CASE("5","ItZbg͐", tv.getOffset() == 28);
            TEST_CASE("6","\̃TCY͐", tv.getStructureSize() == 32);
        } END_CASE;

        BEGIN_CASE("5","ȃP[X") {
            TEST_CASE("1","AhX0̕ϐ͖ (1)", !TTargetVariable(0,4).isValid());
            TEST_CASE("2","AhX0̕ϐ͖ (2)", !TTargetVariable(0,4,4,4).isValid());
            TEST_CASE("3","TCY0̕ϐ͖ (1)", !TTargetVariable(4,0).isValid());
            TEST_CASE("4","TCY0̕ϐ͖ (2)", !TTargetVariable(4,0,4,4).isValid());
            TEST_CASE("5","\̃TCY0̕ϐ͖", !TTargetVariable(4,4,4,0).isValid());

            TEST_CASE("6","݂ȂV{̕ϐ(1)", !TTargetVariable("unknown").isValid());
            TEST_CASE("7","݂ȂV{̕ϐ(2)", !TTargetVariable("unknown","task_initialization_block::texrtn").isValid());
            TEST_CASE("8","݂Ȃo̕ϐ", !TTargetVariable("_kernel_tinib_table","unknown").isValid());

            TEST_CASE("10","i[̈悪sĂϐ", !TTargetVariable("_kernel_tinib_table").isValid());
            TEST_CASE("11","Ȉꍇ", !TTargetVariable(*((TTargetVariable *)0)).isValid());
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("loadContents", "loadContents") {
        BEGIN_CASE("1","ʏN") {
            int i;
            TTargetVariable tv(0x100);

            bool result = true;
            try { tv.loadContent(&i, sizeof(int)); } catch(...) { result = false; }

            TEST_CASE("1","O͋NȂ", result);
            TEST_CASE("2","g~0ŃtBĂ", i == ~0);
        } END_CASE;

        BEGIN_CASE("2","傫Ȍ^Ŏ󂯂") {
            struct { int first; int second; } i;
            TTargetVariable tv(0x100);

            bool result = true;
            try { tv.loadContent(&i, sizeof(i)); } catch(...) { result = false; }

            TEST_CASE("1","O͋NȂ", result);
            TEST_CASE("2","g~0ŃtBĂ", i.first == ~0);
            TEST_CASE("3","c0ŃtBĂ", i.second == 0);
        } END_CASE;

        BEGIN_CASE("3","ȗvfɑ΂Ďs") {
            TTargetVariable tv(0, 0, 0, 0);
            int i;

            bool result = false;
            try{ tv.loadContent(&i, sizeof(i)); } catch(...) { result = true; }
            TEST_CASE("1","ON", result);
        } END_CASE;

        BEGIN_CASE("4","Ȍ^Ŏ󂯂") {
            char i;
            TTargetVariable tv(0x100);

            bool result = false;
            try { tv.loadContent(&i, sizeof(i)); } catch(...) { result = true; }

            TEST_CASE("1","ON", result);
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("pointer_operators","|C^̉Z") {
        TargetVariable<int> tv(0x100);
        TargetVariable<int> tvl(0x100);

        *tvl;

        TEST_CASE("0","[O] tv:AhX0x100", tv.getAddress() == 0x100);
        TEST_CASE("0","[O] tv:TCY4", tv.getSize() == 4);
        TEST_CASE("0","[O] tv:\̃TCY4", tv.getStructureSize() == 4);
        TEST_CASE("0","[O] tv:Ǐo", !tv.isLoaded());
        TEST_CASE("0","[O] tvl:AhX0x100", tvl.getAddress() == 0x100);
        TEST_CASE("0","[O] tvl:TCY4", tvl.getSize() == 4);
        TEST_CASE("0","[O] tvl:\̃TCY4", tvl.getStructureSize() == 4);
        TEST_CASE("0","[O] tvl:Ǐo", tvl.isLoaded());

        BEGIN_CASE("1","operator +") {
            TestSuite::clearCheckpoints();

            TargetVariable<int> work = tv + 0x10;
            TEST_CASE("1","work̃AhX0x140", work.getAddress() == 0x100 + sizeof(int) * 0x10);
            TEST_CASE("2","work͓ǂݍ܂ĂȂ", !work.isLoaded());
        } END_CASE;

        BEGIN_CASE("2","operator -") {
            TestSuite::clearCheckpoints();

            TargetVariable<int> work = tv - 0x10;
            TEST_CASE("1","work̃AhX0xc0", work.getAddress() == 0x100 - sizeof(int) * 0x10);
            TEST_CASE("2","work͓ǂݍ܂ĂȂ", !work.isLoaded());
        } END_CASE;

        BEGIN_CASE("3","operator ++") {
            TestSuite::clearCheckpoints();

            TargetVariable<int> work(tvl);

            TargetVariable<int> result = (++ work);

            TEST_CASE("1","work̃AhX0x104", work.getAddress() == 0x100 + sizeof(int));
            TEST_CASE("2","work == result", work == result);
            TEST_CASE("3","ǂݍݖ", !result.isLoaded());
        } END_CASE;

        BEGIN_CASE("4","operator ++(int)") {
            TestSuite::clearCheckpoints();

            TargetVariable<int> work(tvl);

            TargetVariable<int> result = (work++);

            TEST_CASE("1","work̃AhX0x104", work.getAddress() == 0x100 + sizeof(int));
            TEST_CASE("2","result̃AhX0x100", result.getAddress() == 0x100);
            TEST_CASE("3","ǂݍ݊", result.isLoaded());
        } END_CASE;

        BEGIN_CASE("5","operator --") {
            TestSuite::clearCheckpoints();

            TargetVariable<int> work(tvl);

            TargetVariable<int> result = (-- work);

            TEST_CASE("1","work̃AhX0x9c", work.getAddress() == 0x100 - sizeof(int));
            TEST_CASE("2","work == result", work == result);
            TEST_CASE("3","ǂݍݖ", !result.isLoaded());
        } END_CASE;

        BEGIN_CASE("6","operator --(int)") {
            TestSuite::clearCheckpoints();

            TargetVariable<int> work(tvl);

            TargetVariable<int> result = (work--);

            TEST_CASE("1","work̃AhX0x9c", work.getAddress() == 0x100 - sizeof(int));
            TEST_CASE("2","result̃AhX0x100", result.getAddress() == 0x100);
            TEST_CASE("3","ǂݍ݊", result.isLoaded());
        } END_CASE;

        BEGIN_CASE("7","operator +=") {
            TestSuite::clearCheckpoints();

            TargetVariable<int> work(tvl);

            work += 0x10;

            TEST_CASE("1","work̃AhX0x140", work.getAddress() == 0x100 + sizeof(int) * 0x10);
            TEST_CASE("2","ǂݍݖ", !work.isLoaded());
        } END_CASE;

        BEGIN_CASE("8","operator -=") {
            TestSuite::clearCheckpoints();

            TargetVariable<int> work(tvl);

            work -= 0x10;

            TEST_CASE("1","work̃AhX0xc0", work.getAddress() == 0x100 - sizeof(int) * 0x10);
            TEST_CASE("2","ǂݍݖ", !work.isLoaded());
        } END_CASE;

        BEGIN_CASE("9", "operator &") {
            TEST_CASE("1","AhX", &tv == 0x100);
            TEST_CASE("2","NULLCX^Xɂ0Ԃ", &(*((TargetVariable<int> *)0)) == 0);
        } END_CASE;

        BEGIN_CASE("10", "operator *") {
            TestSuite::clearCheckpoints();
            TargetVariable<int> work(0x100);

            const void * result = &(*work);

            TEST_CASE("1","loadContentssĂ", TestSuite::isReached("loadContents"));
            TEST_CASE("2","", fc.addr == 0x100);
            TEST_CASE("3","", fc.sz == sizeof(int));

            TestSuite::clearCheckpoints();
            *work;

            TEST_CASE("4","loadContents͎sȂ", !TestSuite::isReached("loadContents"));
        } END_CASE;

        BEGIN_CASE("11","operator ==/!=") {
            TEST_CASE("1","AhXvOK", tv == TTargetVariable(tv.getAddress()));
            TEST_CASE("2","NULLCX^XƂ̔rł", tv != *((TTargetVariable *)0));
        } END_CASE;

        BEGIN_CASE("cvr","JobW΍") {
            
            (*((TTargetVariable *)0)) ++;

        } END_CASE;

    } END_CASE;

    chain.restoreContext();
}


#endif

