<?php



/**
 * トラックバックを実装するクラス。
 * 
 * ページごとにシングルトンのように振る舞う。WikiIDは現在実行中のものに固定。
 */
class TrackBack
{
	protected $pagename;
	
	
	/**
	 * インスタンスを取得する。
	 */
	static function getinstance($pagename)
	{
		return new TrackBack($pagename);
	}
	
	
	/**
	 * コンストラクタ。
	 */
	protected function __construct($pagename)
	{
		$this->pagename = $pagename;
	}
	
	
	/**
	 * TrackBack Ping URL自動検知用RDFを取得する。
	 */
	function getpingurlrdf()
	{
		$smarty = new MySmarty(TPL_DIR);
		$smarty->assign('pagename', $this->pagename);
		return $smarty->fetch('trackback.tpl.htm');
	}
	
	
	/**
	 * TrackBack Ping URLを取得する。
	 */
	function getpingurl()
	{
		return SCRIPTPATH . '?cmd=trackback&page=' . rawurlencode($this->pagename);
	}
	
	
	/**
	 * 受信済みTrackBackの数を取得する。
	 */
	function countreceived()
	{
		$db = DataBase::getinstance();
		$_pagename = $db->escape($this->pagename);
		$query  = "SELECT count(*) FROM trackback";
		$query .= " WHERE pagename = '$_pagename'";
		$row = $db->fetch($db->query($query));
		return $row[0];
	}
}



?>