<?php



/**
 * プラグインはこのクラスから派生させる。
 */
class Plugin
{
	protected $pagename;	//プラグインが実行されているページ名。ページ名が無いときはnull。
	
	
	/**
	 * プラグインのインスタンスを取得する。
	 * 
	 * @param	string	$pluginname	プラグインの名前
	 * @return	Plugin	プラグインのインスタンス。プラグインがない場合はPluginExceptionを投げる。
	 */
	static function getPlugin($pluginname)
	{
		$pluginname = mb_strtolower($pluginname);
		$file = PLUGIN_DIR . $pluginname . '/plugin.inc.php';
		if(!is_file($file)){
			throw new PluginException('プラグインがありません。', $pluginname);
		}
		require_once($file);
		return eval("return new Plugin_${pluginname};");
	}
	
	
	function __construct($pagename = null)
	{
		$this->pagename = $pagename;
	}
	
	
	/**
	 * ブロックプラグインとして動作させる。
	 * 
	 * @param	string	$pagename	プラグインが実行されているページ名。ページ名が無い場合はnull。
	 * @param	string	$param1	ソースで()に囲まれた文字列。
	 * @param	string	$param2	ソースで{}に囲まれた文字列。
	 * @return	string	html形式。プラグインが無い場合はPluginExceptionを投げる。
	 */
	function do_block($pagename, $param1, $param2)
	{
		throw new PluginException('このプラグインはブロック型ではありません。', get_class($this));
	}
	
	
	/**
	 * インラインプラグインとして動作させる。
	 * 
	 * @param	string	$pagename	プラグインが実行されているページ名。ページ名が無い場合はnull。
	 * @param	string	$param1	ソースで()に囲まれた文字列。
	 * @param	string	$param2	ソースで{}に囲まれた文字列。
	 * @return	string	html形式。プラグインが無い場合はPluginExceptionを投げる。
	 */
	function do_inline($pagename, $param1, $param2)
	{
		throw new PluginException('このプラグインはインライン型ではありません。', get_class($this));
	}
	
	
	/**
	 * url指定プラグインとして動作させる。
	 * 
	 * @return	array('subject' => string, 'body' => string)	プラグインが無い場合はPluginExceptionを投げる。
	 */
	function do_url()
	{
		throw new PluginException('このプラグインはurl指定型ではありません。', get_class($this));
	}
	
	
	/**
	 * タグ型プラグインとして動作させる。
	 * 
	 * @param	string	$pagename	プラグインが実行されているページ名。ページ名が無い場合はnull。
	 * @param	string	$param1	タグの引数文字列。
	 * @param	string	$param2	タグに囲まれた文字列。
	 * @return	string	html形式。プラグインが無い場合はPluginExceptionを投げる。
	 */
	function do_blocktag($pagename, $param1, $param2)
	{
		return $this->do_block($pagename, $param1, $param2);
	}
}

?>