<?php
/**
 * rss10
 * 最近更新したページをRSSで表示する
 * @author halt <halt@sonata.zive.net>
 * @version $Id: rss10.inc.php,v 1.1 2004/09/13 13:44:56 youka Exp $
 */
class Cmd_rss10
{
	public static function getinstance()
	{
		return new Cmd_rss10;
	}
	
	
	public function run()
	{
		$get = KinoWiki::getinstance()->getGET();
		
		$num = isset($get['recent']) ? (int)$get['recent'] : 15;
		
		$db = DataBase::getinstance();
		$query  = "SELECT pagename,timestamp FROM page";
		$query .= " WHERE (pagename not like ':%' AND pagename not like '%/:%')";
		$query .= " ORDER BY timestamp DESC LIMIT $num";
		$result = $db->query($query);
		
		$list = array();
		while($row = $db->fetch($result)){
			$item['timestamp'] = $this->convertDcDate($row['timestamp']);
			$item['pagename'] = $row['pagename'];
			$item['url'] = $this->getLink($row['pagename']);
			$list[] = $item;
		}
		
		$smarty = new CmdSmarty('rss10');
		$smarty->assign('site_name', SITENAME);
		$smarty->assign('base_url', SCRIPTPATH);
		$smarty->assign('list', $list);
		header('Content-Type: application/xml; charset=UTF-8');
		$smarty->display('rss10.tpl.htm');
		exit();
	}
	
	
	/**
	 * ページ名からURLを作る。
	 * 
	 * @param	string	$pagename	ページ名
	 * @return	string	URL
	 */
	private function getLink($pagename)
	{
		return SCRIPTPATH . '?' . rawurlencode($pagename);
	}
	
	
	/**
	 * timestampをdc:date形式に変換する
	 */
	private function convertDcDate($timestamp)
	{
		return date("Y-m-d\TH:i:s",$timestamp) . '+09:00';
	}
}

?>