package org.maachang.sharedTest ;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import org.maachang.shm.ShmClient;

public class ClientTest2 {
    public static final String SHM_NAME = "mdbm" ;
    public static final int TIMEOUT = 60000 ;
    public static final void main( String[] args ) throws Exception {
        new ClientTest2().execution( args ) ;
    }
    
    /**
     * クライアントでは、入力や、出力をコントロールできる.
     */
    private void execution( String[] args ) throws Exception {
        System.out.println( "*** startup Client *** " ) ;
        BufferedReader be = new BufferedReader( new InputStreamReader( System.in ) ) ;
        ShmClient shm = new ShmClient( SHM_NAME,TIMEOUT ) ;
        for( ;; ) {
            System.out.print( "send:" ) ;
            String in = getInput( be ) ;
            if( in == null || in.length() <= 0 ) {
                continue ;
            }
            in = in.trim() ;
            if( "output".equals( in )) {
                shm.getCoreShm().outputFile( "/outout.txt" ) ;
                continue ;
            }
            else if( in.startsWith( "@:" ) ) {
                in = getFileByString( in.substring( 2 ),"UTF8" ) ;
            }
            System.out.println( "length:" + in.getBytes( "UTF8" ).length ) ;
            byte[] ret = shm.io( in.getBytes( "UTF8" ),TIMEOUT ) ;
            if( ret.length > 512 ) {
                System.out.println( "read("+ret.length+"):・・・・" ) ;
            }
            else {
                System.out.println( "read("+ret.length+"):" + new String( ret,"UTF8" ) ) ;
            }
        }
    }
    
    private static final String getInput( BufferedReader be )
        throws Exception {
        String one = be.readLine() ;
        if( one == null || ( one = one.trim() ).length() <= 0 ) {
            return null ;
        }
        return one ;
    }
    
    public static final String getFileByString(String name, String charset)
            throws Exception {
        int len;
        char[] tmp = null;

        CharArrayWriter ca = null;
        BufferedReader buf = null;
        String ret = null;

        try {

            tmp = new char[8192];
            ca = new CharArrayWriter();
            buf = new BufferedReader(new InputStreamReader(new FileInputStream(
                    name), charset));

            while ((len = buf.read(tmp, 0, 8192)) > 0) {
                ca.write(tmp, 0, len);
            }

            ret = ca.toString();
            ca.close();
            ca = null;

        } finally {

            try {
                buf.close();
            } catch (Exception t) {
            }

            try {
                ca.close();
            } catch (Exception t) {
            }

            buf = null;
            ca = null;
            tmp = null;

        }

        return ret;
    }

}
