package org.maachang.shm;

import java.util.ArrayList;

class ShmTimeoutThread extends Thread {
    private static final long TIMEOUT = 60000L ;
    private volatile boolean stopFlag = true ;
    private ArrayList<ShmData> wayList = null ;
    private final Object sync = new Object() ;
    
    public ShmTimeoutThread()
        throws Exception {
        this.wayList = new ArrayList<ShmData>() ;
        this.stopFlag = false ;
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    public void destroy() {
        setStop( true ) ;
    }
    
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    public void addData( ShmData data ) {
        if( data == null ) {
            return ;
        }
        synchronized( sync ) {
            data.updateTime() ;
            wayList.add( data ) ;
        }
    }
    
    public int size() {
        synchronized( sync ) {
            return wayList.size() ;
        }
    }
    
    public ShmData get( boolean mode,int seqId,long nowTime ) {
        synchronized( sync ) {
            int p = ShmCommon.searchList( wayList,seqId,nowTime ) ;
            if( p <= -1 ) {
                return null ;
            }
            if( mode == true ) {
                return wayList.remove( p ) ;
            }
            else {
                return wayList.get( p ) ;
            }
        }
    }
    
    private static final long WAIT = 30L ;
    
    public void run() {
        boolean endFlag = false ;
        ThreadDeath threadDeach = null ;
        for( ;; ) {
            if( endFlag == true || isStop() == true ) {
                break ;
            }
            try { Thread.sleep( WAIT ) ; } catch( InterruptedException ie ) {
                endFlag = true ;
                continue ;
            }
            try {
                int len ;
                synchronized( sync ) {
                    len = wayList.size() ;
                }
                for( int i = len-1 ; i >= 0  ; i -- ) {
                    Thread.sleep( WAIT ) ;
                    ShmData d ;
                    try {
                        synchronized( sync ) {
                            d = wayList.get( i ) ;
                        }
                    } catch( Exception ee ) {
                        d = null ;
                    }
                    if( d != null && d.getLastAccessTime() + TIMEOUT < System.currentTimeMillis() ) {
                        try {
                            synchronized( sync ) {
                                wayList.remove( i ) ;
                            }
                        } catch( Exception ee ) {
                        }
                    }
                }
            } catch( InterruptedException ie ) {
                endFlag = true ;
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
            } catch( ThreadDeath td ) {
                endFlag = true ;
                threadDeach = td ;
            }
        }
        setStop( true ) ;
        if( threadDeach != null ) {
            throw threadDeach ;
        }
    }
}
