package org.maachang.shm;

import java.util.ArrayList;

class ShmServerThread extends Thread {
    
    private static final long SEND_TIMEOUT = 5000L ;
    private volatile boolean stopFlag = true ;
    private BaseSharedIO base = null ;
    private ShmTimeoutThread wayList = null ;
    private ArrayList<ShmData> receiveList = null ;
    private ArrayList<ShmData> sendList = null ;
    private final Object sync = new Object() ;
    
    public ShmServerThread( BaseSharedIO base )
        throws Exception {
        if( base == null || base.isMode() == false ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.base = base ;
        receiveList = new ArrayList<ShmData>() ;
        wayList = new ShmTimeoutThread() ;
        sendList = new ArrayList<ShmData>() ;
        this.stopFlag = false ;
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    public void destroy() {
        setStop( true ) ;
    }
    
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    /** 送信データを設定. */
    public void setSendData( ShmData data ) {
        if( data == null || data.getDataLength() <= 0 ) {
            return ;
        }
        synchronized( sync ) {
            sendList.add( data ) ;
        }
    }
    
    /** 受信された情報を取得 */
    public ShmData getRecvData() {
        synchronized( sync ) {
            if( receiveList.size() > 0 ) {
                return receiveList.remove( 0 ) ;
            }
        }
        return null ;
    }
    
    private static final long WAIT = ShmCommon.MON_SLEEP ;
    
    public void run() {
        boolean endFlag = false ;
        ShmData sendData = null ;
        long sendDataTimeout = -1L ;
        ThreadDeath threadDeach = null ;
        for( ;; ) {
            if( endFlag == true || isStop() == true ) {
                break ;
            }
            try { Thread.sleep( WAIT ) ; } catch( InterruptedException ie ) {
                endFlag = true ;
                continue ;
            }
            try {
                // 受信情報を取得.
                executionRecv() ;
                
                // 送信中データが無い場合は、送信情報を取得.
                if( sendData == null ) {
                    sendData = getSendData() ;
                    if( sendData != null ) {
                        sendDataTimeout = System.currentTimeMillis() ;
                    }
                }
                // 送信データが存在する場合は、送信処理を行う.
                if( sendData != null ) {
                    Thread.sleep( WAIT ) ;
                    
                    // 送信処理.
                    sendDataTimeout = executionSend( sendData,sendDataTimeout ) ;
                    // 送信処理が完了している場合は、送信ヘッダを次回で即時読み取り.
                    if( sendDataTimeout == -1 ) {
                        sendData = null ;
                    }
                }
                
            } catch( InterruptedException ie ) {
                endFlag = true ;
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
                //e.printStackTrace() ;
            } catch( ThreadDeath td ) {
                endFlag = true ;
                threadDeach = td ;
            }
        }
        setStop( true ) ;
        if( threadDeach != null ) {
            throw threadDeach ;
        }
    }
    
    /** 送信可能データが存在する場合は取得. */
    private ShmData getSendData() {
        synchronized( sync ) {
            if( sendList.size() <= 0 ) {
                return null ;
            }
            return sendList.remove( 0 ) ;
        }
    }
    
    /** 受信処理. */
    private void executionRecv() throws Exception {
        try {
            //base.lock() ;
            ShmHeader hd = base.getReadHeader( true ) ;
            // 読み込みデータが無い場合は処理しない.
            if( hd.getSequenceId() == ShmCommon.FREE_DATA ) {
                return ;
            }
            ShmData recvData = wayList.get( true,hd.getSequenceId(),hd.getNowTime() ) ;
            if( recvData == null ) {
                recvData = new ShmData( hd.getSequenceId(),hd.getNowTime() ) ;
            }
            int length = hd.getDataLength() ;
            // 次データが存在する長さの場合.
            if( length  == ShmCommon.NEXT_LENGTH ) {
                // 次データ用処理.
                wayList.addData( recvData ) ;
                length = ShmCommon.IO_LENGTH ;
                byte[] b = base.getReadData( true,length ) ;
                recvData.addData( b,length ) ;
            }
            // このデータが終端の場合.
            else if( length > 0 ){
                byte[] b = base.getReadData( true,length ) ;
                recvData.addData( b,length ) ;
                synchronized( sync ) {
                    receiveList.add( recvData ) ;
                }
            }
            // 受信データ長が不正な長さの場合.
            else {
                return ;
            }
            // 受信データ終了を示す内容に書き換える.
            hd.setSequenceId( ShmCommon.FREE_DATA ) ;
            base.setRead( hd,null,-1 ) ;
        } finally {
            //try { base.unLock() ; } catch( Exception e ) {}
        }
    }
    
    /** データ送信がある場合の処理. */
    private long executionSend( ShmData sendData,long timeout )
        throws Exception {
        try {
            //base.lock() ;
            ShmHeader hd = base.getWriteHeader( true ) ;
            // 書き込み許可が存在する.
            if( hd.getSequenceId() == ShmCommon.FREE_DATA ) {
                hd.create( sendData ) ;
                int offset = base.setWrite( hd,sendData.getData(),sendData.getOffset() ) ;
                sendData.setOffset( offset ) ;
                // データ書き込みが続く場合.
                if( offset > 0 ) {
                    // タイムアウト値を更新.
                    timeout = System.currentTimeMillis() ;
                }
                // データ書き込みが終了した場合.
                else {
                    timeout = -1 ;
                }
            }
            // データタイムアウトを検知した場合.
            else if( timeout + SEND_TIMEOUT <= System.currentTimeMillis() ) {
                // 送信中のデータと一致する場合は、その内容も破棄.
                if( sendData.equals( hd.getSequenceId(),hd.getNowTime() ) == true ) {
                    timeout = -1 ;
                }
                // 送信中であるデータを破棄する.
                hd.setSequenceId( ShmCommon.FREE_DATA ) ;
                base.setWrite( hd,null,-1 ) ;
                // タイムアウト値を更新.
                timeout = System.currentTimeMillis() ;
            }
            return timeout ;
        } finally {
            //try { base.unLock() ; } catch( Exception e ) {}
        }
    }
}
