package org.maachang.shm;

/**
 * 共有メモリI/Oデータ.
 *
 * @version 2008/03/09
 * @author  masahito suzuki
 * @since  ShareMemory 1.03
 */
public class ShmIoData {
    private int sequenceId = -1 ;
    private long nowTime = -1 ;
    private byte[] data = null ;
    
    /** コンストラクタ */
    protected ShmIoData() {
        
    }
    
    /** コンストラクタ */
    protected ShmIoData( int sequenceId,long nowTime,byte[] data ) {
        this.sequenceId = sequenceId ;
        this.nowTime = nowTime ;
        this.data = data ;
    }
    
    protected void finalize() throws Exception {
        this.clear() ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        this.data = null ;
    }
    
    /**
     * シーケンスIDを取得.
     * <BR>
     * @return int シーケンスIDが返されます.
     */
    public int getSequenceId() {
        return sequenceId ;
    }
    
    /**
     * シーケンスIDを設定.
     * <BR>
     * @param sequenceId シーケンスIDを設定します.
     */
    public void setSequenceId( int sequenceId ) {
        this.sequenceId = sequenceId ;
    }
    
    /**
     * 開始時間を取得.
     * <BR>
     * @param long 開始時間が返されます.
     */
    public long getNowTime() {
        return nowTime ;
    }
    
    /**
     * 開始時間を設定.
     * <BR>
     * @param nowTime 開始時間を設定します.
     */
    public void setNowTime( long nowTime ) {
        this.nowTime = nowTime ;
    }
    
    /**
     * データを取得.
     * <BR>
     * @return byte[] データが返されます.
     */
    public byte[] getData() {
        return data ;
    }
    
    /**
     * データを設定.
     * <BR>
     * @param data データを設定します.
     * @param offset オフセット値を設定します.
     * @param length データ長を設定します.
     */
    public void setData( byte[] data,int offset,int length ) {
        if( data == null || data.length <= 0 || data.length <= offset ) {
            return ;
        }
        if( length >= data.length ) {
            length = data.length ;
        }
        if( length >= data.length + offset ) {
            length = data.length - length ;
        }
        
        this.data = new byte[ length ] ;
        System.arraycopy( data,offset,this.data,0,length ) ;
    }
    
    /**
     * データを設定.
     * <BR>
     * @param data データを設定します.
     */
    public void setData( byte[] data ) {
        this.data = data ;
    }
}
