package org.maachang.shm;

class ShmData implements Comparable<ShmData> {
    public static final int MODE_READ = 1 ;
    public static final int MODE_WRITE = 2 ;
    
    private int sequenceId = -1 ;
    private long nowTime = -1L ;
    private int hashCode = -1 ;
    private ArrayBinary data = null ;
    private int offset = 0 ;
    private int outDataOffset = -1 ;
    private long lastAccess ;
    
    public ShmData( int sequenceId ) {
        this.sequenceId = sequenceId ;
        this.nowTime = System.currentTimeMillis() ;
        this.hashCode = ShmCommon.getHashCode( this.sequenceId,this.nowTime ) ;
        this.lastAccess = System.currentTimeMillis() ;
    }
    
    public ShmData( int sequenceId,long nowTime ) {
        this.sequenceId = sequenceId ;
        this.nowTime = nowTime ;
        this.hashCode = ShmCommon.getHashCode( this.sequenceId,this.nowTime ) ;
        this.lastAccess = System.currentTimeMillis() ;
    }
    
    public int getSequenceId() {
        return sequenceId ;
    }
    
    public long getNowTime() {
        return nowTime ;
    }
    
    public synchronized ArrayBinary getArrayBinary() {
        return this.data ;
    }
    
    public synchronized void clearArrayBinary() {
        if( this.data == null ) {
            this.data = new ArrayBinary() ;
        }
        else {
            this.data.clear() ;
        }
        offset = 0 ;
        outDataOffset = -1 ;
    }
    
    public synchronized void addData( byte[] bin,int length ) {
        if( this.data == null ) {
            this.data = new ArrayBinary() ;
        }
        this.data.write( bin,length ) ;
    }
    
    public synchronized void setData( byte[] data ) {
        this.data = new ArrayBinary( data ) ;
        offset = 0 ;
        outDataOffset = -1 ;
    }
    
    public synchronized byte[] getData() {
        if( this.data != null ) {
            return this.data.getBinary() ;
        }
        return null ;
    }
    
    public synchronized int getDataLength() {
        if( this.data == null ) {
            return 0 ;
        }
        return this.data.getLength() ;
    }
    
    public synchronized int getOffset() {
        if( offset <= 0 ) {
            offset = 0 ;
        }
        return offset ;
    }
    
    public synchronized void setOffset( int offset ) {
        this.offset = offset ;
        this.outDataOffset = -1 ;
    }
    
    public synchronized void cache( int offset ) {
        this.outDataOffset = offset ;
    }
    
    public synchronized boolean isCache() {
        return ( offset == outDataOffset ) ;
    }
    
    public int hashCode() {
        return hashCode ;
    }
    
    public int compareTo( ShmData o ) {
        return o.sequenceId - sequenceId ;
    }
    
    public boolean equals( Object o ) {
        if( o instanceof ShmData ) {
            ShmData x = ( ShmData )o ;
            return ( x.sequenceId == sequenceId && x.nowTime == nowTime ) ;
        }
        return false ;
    }
    
    public boolean equals( int sequenceId,long nowTime ) {
        return ( this.sequenceId == sequenceId && this.nowTime == nowTime ) ;
    }
    
    public boolean equals( ShmHeader header ) {
        return ( this.sequenceId == header.getSequenceId() && this.nowTime == header.getNowTime() ) ;
    }
    
    public long getLastAccessTime() {
        return this.lastAccess ;
    }
    
    public void updateTime() {
        this.lastAccess = System.currentTimeMillis() ;
    }
}
