package org.maachang.shm;

import java.util.ArrayList;

import org.maachang.shm.core.CoreShm;

class ShmCommon {
    
    // IO_LENGTH初期値を設定.
    static {
        if( System.getProperty( ShmDefine.VALUE_PROPERTY ) != null ) {
            int x = -1 ;
            try {
                x = Integer.parseInt( System.getProperty( ShmDefine.VALUE_PROPERTY ) ) ;
            } catch( Exception e ) {
            }
            if( x <= -1 && x >= 0x7fffffff ) {
                x = ShmDefine.DEFAULT_VALUE_LENGTH ;
            }
            IO_LENGTH = x ;
        }
        else {
            IO_LENGTH = ShmDefine.DEFAULT_VALUE_LENGTH ;
        }
    }
    
    /**
     * １つのI/O対象長.
     */
    public static final int IO_LENGTH  ;
    
    /**
     * シーケンスID.
     */
    public static final int SEQUENCE_ID = 4 ;
    
    /**
     * 開始時間.
     */
    public static final int START_TIME = 8 ;
    
    /**
     * 格納データ数.
     */
    public static final int NOW_LENGTH = 4 ;
    
    /**
     * 共有メモリーサイズ.
     */
    public static final int SHARED_LENGTH = SEQUENCE_ID +
        ( ( SEQUENCE_ID + START_TIME + NOW_LENGTH + IO_LENGTH ) * 2 ) ;
    
    /**
     * ハーフヘッダサイズ.
     */
    public static final int HHEADER_LENGTH = SEQUENCE_ID + START_TIME + NOW_LENGTH ;
    
    /**
     * Next条件の格納データ数.
     */
    public static final int NEXT_LENGTH = 0x7fffffff ;
    
    /**
     * データI/Oフリー状態.
     */
    public static final int FREE_DATA = 0x00000000 ;
    
    /**
     * 監視スリープ時間.
     */
    public static final long MON_SLEEP = ShmDefine.MON_SLEEP ;
    
    /**
     * 新しいシーケンスIDを生成.
     * <BR>
     * @param shm CoreShmを設定します.
     * @exception Exception 例外.
     */
    public static final int getSequenceId( CoreShm shm )
        throws Exception {
        return shm.getSequenceIdEnhancing( true ) ;
    }
    
    /**
     * ヘッダ内容を設定.
     * <BR>
     * @param mode [true]の場合、書き込み条件を取得します.
     * @param sync 同期しない場合は、[false]を設定します.
     * @param shm CoreShmを設定します.
     * @param seqId シーケンスIDを設定します.
     * @param time 開始時間を設定します.
     * @param dataLen データ長を設定します.
     * @exception Exception 例外.
     */
    public static final void setHeader( boolean mode,boolean sync,CoreShm shm,int seqId,long time,int dataLen )
        throws Exception {
        shm.putHeaderEnhancing( sync,mode,seqId,time,dataLen ) ;
    }
    
    /**
     * ヘッダ内容を取得.
     * <BR>
     * @param mode [true]の場合、書き込み条件を取得します.
     * @param sync 同期しない場合は、[false]を設定します.
     * @param bin ヘッダ内容が返されます.
     * @param shm CoreShmを設定します.
     * @return ShmHeader ヘッダ情報が返されます.
     * @exception Exception 例外.
     */
    public static final ShmHeader getHeader( boolean mode,boolean sync,CoreShm shm )
        throws Exception {
        int[] seqId = new int[ 1 ] ;
        long[] time = new long[ 1 ] ;
        int[] datLen = new int[ 1 ] ;
        shm.getHeaderEnhancing( sync,mode,seqId,time,datLen ) ;
        ShmHeader ret = new ShmHeader( seqId[ 0 ],time[ 0 ] ) ;
        ret.setDataLength( datLen[ 0 ] ) ;
        return ret ;
    }
    
    /**
     * データ領域を取得.
     * <BR>
     * @param mode [true]の場合、書き込み条件を取得します.
     * @param sync 同期しない場合は、[false]を設定します.
     * @param bin データ領域が返されます.
     * @param shm CoreShmを設定します.
     * @param length 取得データ長を設定します.
     * @exception Exception 例外.
     */
    public static final void getData( boolean mode,boolean sync,byte[] bin,CoreShm shm,int length )
        throws Exception {
        shm.getValueEnhancing( sync,mode,bin,length ) ;
    }
    
    /**
     * ヘッダ+データ領域に書き込む.
     * <BR>
     * @param mode [true]の場合、書き込み条件を取得します.
     * @param sync 同期しない場合は、[false]を設定します.
     * @param shm CoreShmを設定します.
     * @param bin データ領域を設定します.
     * @param length 取得データ長を設定します.
     * @param seqId シーケンスIDを設定します.
     * @param time 開始時間を設定します.
     * @param dataLen データ長を設定します.
     * @exception Exception 例外.
     */
    public static final void outputHeaderData( boolean mode,boolean sync,CoreShm shm,byte[] bin,int length,int seqId,long time,int dataLen )
        throws Exception {
        shm.putHdValueEnhancing( sync,mode,seqId,time,dataLen,bin,length ) ;
    }
    
    /**
     * シーケンスIDと、開始時間で、Hashコードを取得.
     * <BR>
     * @param seqId 対象のシーケンスIDを設定します.
     * @param nowTime 対象の開始時間を設定します.
     * @return int Hashコードが返されます.
     */
    public static final int getHashCode( int seqId,long nowTime ) {
        byte[] b = new byte[ 12 ] ;
        b[ 0 ] = ( byte )( seqId & 0x000000ff ) ;
        b[ 1 ] = ( byte )( ( seqId & 0x0000ff00 ) >> 8 ) ;
        b[ 2 ] = ( byte )( ( seqId & 0x00ff0000 ) >> 16 ) ;
        b[ 3 ] = ( byte )( ( seqId & 0xff000000 ) >> 24 ) ;
        b[ 4 ] = ( byte )( nowTime & 0x00000000000000ffL ) ;
        b[ 5 ] = ( byte )( ( nowTime & 0x000000000000ff00L ) >> 8L ) ;
        b[ 6 ] = ( byte )( ( nowTime & 0x0000000000ff0000L ) >> 16L ) ;
        b[ 7 ] = ( byte )( ( nowTime & 0x00000000ff000000L ) >> 24L ) ;
        b[ 8 ] = ( byte )( ( nowTime & 0x000000ff00000000L ) >> 32L ) ;
        b[ 9 ] = ( byte )( ( nowTime & 0x0000ff0000000000L ) >> 40L ) ;
        b[ 10 ] = ( byte )( ( nowTime & 0x00ff000000000000L ) >> 48L ) ;
        b[ 11 ] = ( byte )( ( nowTime & 0xff00000000000000L ) >> 56L ) ;
        int len = b.length;
        long ret = 0x00000000811C9DC5L;
        for (int i = 0; i < len; i++) {
            ret ^= b[i];
            ret += (ret << 1L) + (ret << 4L) + (ret << 7L) + (ret << 8L)
                    + (ret << 24L);
        }
        return (int) (ret & 0x00000000ffffffffL);
    }
    
    /**
     * 指定リストから、条件の一致する内容を取得.
     * <BR>
     * @param list 検索対象のリストを設定します.
     * @param seqId 対象のシーケンスIDを設定します.
     * @param nowTime 対象の開始時間を設定します.
     * @return int 検索結果の項番が返されます.<BR>
     *             [-1]の場合、存在しません.
     */
    public static final int searchList( ArrayList<ShmData> list,int seqId,long nowTime ) {
        int len = list.size() ;
        for( int i = 0 ; i < len ; i ++ ) {
            ShmData data = list.get( i ) ;
            if( data.getSequenceId() == seqId && data.getNowTime() == nowTime ) {
                return i ;
            }
        }
        return -1 ;
    }
}
