package org.maachang.shm;

import java.util.ArrayList;

class ShmClientThread extends Thread {
    private volatile boolean stopFlag = true ;
    private BaseSharedIO base = null ;
    private ArrayList<ShmData> sendList = null ;
    private ShmTimeoutThread wayList = null ;
    private ArrayList<ShmData> receiveList = null ;
    private final Object sync = new Object() ;
    
    public ShmClientThread( BaseSharedIO base )
        throws Exception {
        if( base == null || base.isMode() == true ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.base = base ;
        sendList = new ArrayList<ShmData>() ;
        wayList = new ShmTimeoutThread() ;
        receiveList = new ArrayList<ShmData>() ;
        this.stopFlag = false ;
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    public void destroy() {
        setStop( true ) ;
    }
    
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    /** シーケンスIDを取得. */
    public int getSequenceId() throws Exception {
        return base.getSequenceId() ;
    }
    
    /** 送信データを設定 */
    public void setSendData( ShmData data ) {
        if( data == null || data.getDataLength() <= 0 ) {
            return ;
        }
        synchronized( sync ) {
            sendList.add( data ) ;
        }
    }
    
    /** 受信されたデータを取得. */
    public ShmData getReceiveData( int seqId,long nowTime ) {
        synchronized( sync ) {
            int p = ShmCommon.searchList( receiveList,seqId,nowTime ) ;
            if( p <= -1 ) {
                return null ;
            }
            return receiveList.remove( p ) ;
        }
    }
    
    private static final long WAIT = ShmCommon.MON_SLEEP ;
    
    public void run() {
        boolean endFlag = false ;
        ThreadDeath threadDeach = null ;
        ShmData sendData = null ;
        for( ;; ) {
            if( endFlag == true || isStop() == true ) {
                break ;
            }
            try { Thread.sleep( WAIT ) ; } catch( InterruptedException ie ) {
                endFlag = true ;
                continue ;
            }
            try {
                // 送信中データが無い場合は、送信情報を取得.
                if( sendData == null ) {
                    sendData = getSendData() ;
                }
                // 送信処理が完了した場合.
                if( executionSend( sendData ) == true ) {
                    // 送信待ち処理に遷移.
                    sendData.clearArrayBinary() ;
                    wayList.addData( sendData ) ;
                    sendData = null ;
                }
                
                // 受信待ちデータが存在しない場合は処理しない.
                if( wayList.size() > 0 ) {
                    Thread.sleep( WAIT ) ;
                    
                    // 受信処理.
                    executionRecv() ;
                }
                
            } catch( InterruptedException ie ) {
                endFlag = true ;
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
                //e.printStackTrace() ;
            } catch( ThreadDeath td ) {
                endFlag = true ;
                threadDeach = td ;
            }
        }
        wayList.destroy() ;
        sendList = null ;
        wayList = null ;
        receiveList = null ;
        setStop( true ) ;
        if( threadDeach != null ) {
            throw threadDeach ;
        }
    }
    
    /** 送信可能データが存在する場合は、取得. */
    private ShmData getSendData() {
        synchronized( sync ) {
            if( sendList.size() <= 0 ) {
                return null ;
            }
            return sendList.remove( 0 ) ;
        }
    }
    
    /** 書き込み許可がある場合に、書き込む処理. */
    private boolean executionSend( ShmData sendData )
        throws Exception {
        if( sendData == null ) {
            return false ;
        }
        try {
            boolean ret = false ;
            base.lock() ;
            ShmHeader hd = base.getWriteHeader( false ) ;
            // 書き込み許可が存在する.
            if( hd.getSequenceId() == ShmCommon.FREE_DATA ) {
                // データ書き込み.
                hd.create( sendData ) ;
                int offset = base.setWrite( hd,sendData.getData(),sendData.getOffset() ) ;
                sendData.setOffset( offset ) ;
                if( sendData.getOffset() <= 0 ) {
                    // 書き込み終了.
                    ret = true ;
                }
                // キャッシュを無効に設定.
                sendData.cache( -1 ) ;
            }
            base.unLock() ;
            return ret ;
        } catch( Exception e ) {
            try {base.unLock() ; } catch( Exception ee ) {}
            throw e ;
        }
        
    }
    
    /** 受信処理. */
    private boolean executionRecv() throws Exception {
        try {
            //base.lock() ;
            ShmHeader hd = base.getReadHeader( true ) ;
            // 読み込みデータが無い場合は処理しない.
            if( hd.getSequenceId() == ShmCommon.FREE_DATA ) {
                return false ;
            }
            ShmData wayData = wayList.get( true,hd.getSequenceId(),hd.getNowTime() ) ;
            // この条件にマッチするデータが存在する.
            if( wayData != null ) {
                int length = hd.getDataLength() ;
                // 次データが存在する長さの場合.
                if( length  == ShmCommon.NEXT_LENGTH ) {
                    // 次データ用処理.
                    wayData.updateTime() ;
                    wayList.addData( wayData ) ;
                    length = ShmCommon.IO_LENGTH ;
                    byte[] b = base.getReadData( true,length ) ;
                    wayData.addData( b,length ) ;
                }
                // このデータが終端の場合.
                else if( length > 0 ){
                    byte[] b = base.getReadData( true,length ) ;
                    wayData.addData( b,length ) ;
                    synchronized( sync ) {
                        receiveList.add( wayData ) ;
                    }
                }
                // 受信データ長が不正な長さの場合.
                else {
                    return false ;
                }
                // 受信データ終了を示す内容に書き換える.
                hd.setSequenceId( ShmCommon.FREE_DATA ) ;
                base.setRead( hd,null,-1 ) ;
                return true ;
            }
            return false ;
        } finally {
            //try { base.unLock() ; } catch( Exception e ) {}
        }
    }
}
