package org.maachang.shm;

import java.io.IOException;

class OutputArrayBuffer {
    private static final int BUFFER = 4096 ;
    private byte[] binary = null ;
    private int length = 0 ;
    
    public OutputArrayBuffer() {
        this.binary = null ;
        this.length = 0 ;
    }
    
    protected void finalize() throws Exception {
        this.clear() ;
    }
    
    public void clear() {
        this.binary = null ;
        this.length = 0 ;
    }
    
    public void write( int b ) throws IOException {
        if( binary == null ) {
            binary = new byte[ BUFFER ] ;
        }
        else if( binary.length <= length ) {
            byte[] t = binary ;
            int iLen = t.length * 2 ;
            binary = new byte[ iLen ] ;
            System.arraycopy( t,0,binary,0,t.length ) ;
            t = null ;
        }
        binary[ length ] = ( byte )( b & 0x000000ff ) ;
        length ++ ;
    }
    
    public byte[] getBinary() {
        if( binary == null ) {
            return null ;
        }
        byte[] ret = new byte[ length ] ;
        System.arraycopy( this.binary,0,ret,0,length ) ;
        return ret ;
    }
    
    public int getLength() {
        return length ;
    }
}
