package org.maachang.shm;

class ArrayBinary {
    private byte[] binary = null ;
    private int length = 0 ;
    
    public ArrayBinary() {
        this.length = 0 ;
    }
    
    public ArrayBinary( byte[] binary ) {
        this.binary = binary ;
        this.length = binary.length ;
    }
    
    protected void finalize() throws Exception {
        this.clear() ;
    }
    
    public void clear() {
        this.binary = null ;
        this.length = 0 ;
    }
    
    public void write( byte[] b,int len ) {
        if( binary == null ) {
            binary = new byte[ len ] ;
            System.arraycopy( b,0,binary,0,len ) ;
            length = len ;
        }
        else {
            byte[] x = binary ;
            binary = new byte[ len + length ] ;
            System.arraycopy( x,0,binary,0,length ) ;
            x = null ;
            System.arraycopy( b,0,binary,length,len ) ;
            length = len + length ;
        }
    }
    
    public byte getByte( int no ) {
        return binary[ no ] ;
    }
    
    public byte[] getBinary() {
        return binary ;
    }
    
    public int getLength() {
        return length ;
    }
}
