//
// WindowspSharedMemoyɂ́ACreateFileMapping𗘗pB
//
#include <windows.h>
#include "../../include/org_maachang_shm_core_NativeSharedMemory.h"

#pragma comment(lib,"jvm.lib")

///////////////////////////////////////////////////////////////////////////////
// ShareMemory.
///////////////////////////////////////////////////////////////////////////////

#define MUTEX_SLEEP_TIME		(30)
#define DEF_SEMAPHORE			(1)
#define DEF_MAXSEMAPHORE		(1)
#define MODE_NOT_SYNC			(0)

#define SEQ_LENGTH				(4)
#define HEADER_LENGTH			(16)
#define NOT_DATA_LENGTH			(36)
#define WRITE_POSITION			(0)

// ef[^wb_.
typedef struct _tag_ShmHd {
	int seq ;
	int timeD ;
	int timeU ;
	int length ;
} SHM_HD,*LPSHM_HD ;

// L.
static HANDLE hInitSem = NULL ;
static HANDLE hShare = NULL ;
static char* semName = NULL ;
static unsigned char* shareData = NULL ;
static int shareSize = -1 ;
static int serverMode = -1 ;
static int ioLength = -1 ;
static LPCRITICAL_SECTION cs = NULL ;
static int semMode = 0 ;

// vZXID擾.
inline int getProcessId() {
	return GetCurrentProcessId() ;
}

// MutexbN.
inline void LockSharedMemory() {
	int cd ;
	HANDLE h ;
	EnterCriticalSection(cs) ;
	h = hInitSem ;
	cd = semMode ;
	LeaveCriticalSection(cs) ;
	if( cd == 0 && h == NULL ) {
		for( ;; ) {
			h = CreateMutex(NULL,FALSE,semName);
			if( h == NULL ) {
				Sleep( MUTEX_SLEEP_TIME ) ;
				continue ;
			}
			EnterCriticalSection(cs) ;
			hInitSem = h ;
			semMode = 1 ;
			LeaveCriticalSection(cs) ;
			break ;
		}
	}
}

// MutexAbN.
inline void UnLockSharedMemory() {
	int cd ;
	HANDLE h ;
	EnterCriticalSection(cs) ;
	h = hInitSem ;
	cd = semMode ;
	LeaveCriticalSection(cs) ;
	if( cd == 1 && h != NULL ) {
		ReleaseMutex(h) ;
		CloseHandle(h) ;
		h = NULL ;
		EnterCriticalSection(cs) ;
		hInitSem = NULL ;
		semMode = 0 ;
		LeaveCriticalSection(cs) ;
	}
}

// Mutex.
inline int InitLockHandle(char* name) {
	int len = strlen( name ) + 3 ;
	semName = ( char* )malloc( len+1 ) ;
	memset( semName,'\0',len+1 ) ;
	sprintf( semName,"mx_%s\0",name ) ;
	cs = ( LPCRITICAL_SECTION )malloc( sizeof( CRITICAL_SECTION ) ) ;
	InitializeCriticalSection(cs) ;
	semMode = 0 ;
	return 0 ;
}

// MutexI.
inline void CloseLockHandle() {
	if( semName != NULL ) {
		free( semName ) ;
		semName = NULL ;
	}
	if( cs != NULL ) {
		DeleteCriticalSection(cs) ;
		free( cs ) ;
		cs = NULL ;
	}
}

// LI[v.
inline int OpenShare(int mode,char* shareName,int size) {
	hShare = CreateFileMapping((HANDLE)0xFFFFFFFF,0,PAGE_READWRITE,0,size,shareName);
	if( hShare == NULL ) {
		return -1 ;
	}
	shareData = ( unsigned char* )MapViewOfFile(hShare,FILE_MAP_WRITE,0,0,size);
	if( shareData == NULL ) {
		return -1 ;
	}
	if( mode == 0 ) {
		memset( shareData,'\0',size ) ;
	}
	ioLength = ( size - NOT_DATA_LENGTH ) / 2 ;
	return 0 ;
}

// LN[Y.
inline void CloseShare() {
	if( hShare != NULL ) {
		UnmapViewOfFile(hShare);
		CloseHandle(hShare);
	}
}

// LSʏ.
inline int InitShareMemory( int mode,char* semName,char* shareName,int size ) {
	serverMode = mode ;
	if( InitLockHandle( semName ) <= -1 ) {
		return -1 ;
	}
	LockSharedMemory() ;
	if( OpenShare( mode,shareName,size ) <= -1 ) {
		UnLockSharedMemory() ;
		return -1 ;
	}
	UnLockSharedMemory() ;
	shareSize = size ;
	return 0 ;
}

// LSʏI.
inline int DestroyShareMemory() {
	LockSharedMemory() ;
	CloseShare() ;
	UnLockSharedMemory() ;
	CloseLockHandle() ;
	return 0 ;
}

// Lɏǉ.
inline int PutShareData( int md,unsigned char* data,int pos,int off,int len ) {
	if( md == MODE_NOT_SYNC ) {
		EnterCriticalSection(cs) ;
		memcpy( shareData+pos,data+off,len ) ;
		LeaveCriticalSection(cs) ;
	}
	else {
		LockSharedMemory() ;
		memcpy( shareData+pos,data+off,len ) ;
		UnLockSharedMemory() ;
	}
	return 0 ;
}

// L擾.
inline int GetShareData( int md,unsigned char* data,int pos,int off,int len ) {
	if( md == MODE_NOT_SYNC ) {
		EnterCriticalSection(cs) ;
		memcpy( data+off,shareData+pos,len ) ;
		LeaveCriticalSection(cs) ;
	}
	else {
		LockSharedMemory() ;
		memcpy( data+off,shareData+pos,len ) ;
		UnLockSharedMemory() ;
	}
	return 0 ;
}

// LS̒擾.
inline int MaxShreSize() {
	return shareSize ;
}

///////////////////////////////////////////////////////////////////////////////
// Lg.
///////////////////////////////////////////////////////////////////////////////

// V[PXID擾.
inline int GetSequenceId( int md ) {
	int seq = -1 ;
	if( md != MODE_NOT_SYNC ) {
		LockSharedMemory() ;
	}
	int len = sizeof( seq ) ;
	EnterCriticalSection(cs) ;
	memcpy( &seq,shareData,len ) ;
	if( seq <= 0 || seq >= 0x7fffffff ) {
		seq = 1 ;
	}
	else {
		seq ++ ;
	}
	memcpy( shareData,&seq,len ) ;
	LeaveCriticalSection(cs) ;
	if( md != MODE_NOT_SYNC ) {
		UnLockSharedMemory() ;
	}
	return seq ;
}

// wb_̈擾.
inline void GetSmHeader( int md,int t,LPSHM_HD hd ) {
	int p ;
	if( md != MODE_NOT_SYNC ) {
		LockSharedMemory() ;
	}
	if( t == WRITE_POSITION ) {
		p = SEQ_LENGTH ;
	}
	else {
		p = SEQ_LENGTH + HEADER_LENGTH + ioLength ;
	}
	EnterCriticalSection(cs) ;
	memcpy( hd,shareData+p,sizeof( SHM_HD ) ) ;
	LeaveCriticalSection(cs) ;
	if( md != MODE_NOT_SYNC ) {
		UnLockSharedMemory() ;
	}
}

// f[^擾.
inline void GetShmValue( int md,int t,unsigned char* data,int len ) {
	int p ;
	if( md != MODE_NOT_SYNC ) {
		LockSharedMemory() ;
	}
	if( t == WRITE_POSITION ) {
		p = SEQ_LENGTH + HEADER_LENGTH ;
	}
	else {
		p = SEQ_LENGTH + HEADER_LENGTH + ioLength + HEADER_LENGTH ;
	}
	EnterCriticalSection(cs) ;
	memcpy( data,shareData+p,len ) ;
	LeaveCriticalSection(cs) ;
	if( md != MODE_NOT_SYNC ) {
		UnLockSharedMemory() ;
	}
}

// wb_.
inline void PutSmHeader( int md,int t,LPSHM_HD hd ) {
	int p ;
	if( md != MODE_NOT_SYNC ) {
		LockSharedMemory() ;
	}
	if( t == WRITE_POSITION ) {
		p = SEQ_LENGTH ;
	}
	else {
		p = SEQ_LENGTH + HEADER_LENGTH + ioLength ;
	}

	EnterCriticalSection(cs) ;
	memcpy( shareData+p,hd,sizeof( SHM_HD ) ) ;
	LeaveCriticalSection(cs) ;

	if( md != MODE_NOT_SYNC ) {
		UnLockSharedMemory() ;
	}
}

// f[^.
inline void PutShmValue( int md,int t,unsigned char* data,int len ) {
	int p ;
	if( md != MODE_NOT_SYNC ) {
		LockSharedMemory() ;
	}
	if( t == WRITE_POSITION ) {
		p = SEQ_LENGTH + HEADER_LENGTH ;
	}
	else {
		p = SEQ_LENGTH + HEADER_LENGTH + ioLength + HEADER_LENGTH ;
	}
	EnterCriticalSection(cs) ;
	memcpy( shareData+p,data,len ) ;
	LeaveCriticalSection(cs) ;
	if( md != MODE_NOT_SYNC ) {
		UnLockSharedMemory() ;
	}
}

// wb_{f[^.
inline void PutHdShmValue( int md,int t,LPSHM_HD hd,unsigned char* data,int len ) {
	int p ;
	if( md != MODE_NOT_SYNC ) {
		LockSharedMemory() ;
	}
	if( t == WRITE_POSITION ) {
		p = SEQ_LENGTH ;
	}
	else {
		p = SEQ_LENGTH + HEADER_LENGTH + ioLength ;
	}
	EnterCriticalSection(cs) ;
	memcpy( shareData+p,hd,sizeof( SHM_HD ) ) ;
	memcpy( shareData+(p+HEADER_LENGTH),data,len ) ;
	LeaveCriticalSection(cs) ;
	if( md != MODE_NOT_SYNC ) {
		UnLockSharedMemory() ;
	}
}

///////////////////////////////////////////////////////////////////////////////
// JNI.
///////////////////////////////////////////////////////////////////////////////

// NativeShareMemory.initShareMemoryĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_initShareMemory
  (JNIEnv* env, jobject o, jint mode,jbyteArray n1, jbyteArray n2, jint sz ) {
	jboolean b ;
	jbyte* semName=(*env).GetByteArrayElements(n1,&b);
	jbyte* shareName=(*env).GetByteArrayElements(n2,&b);
	jint ret = InitShareMemory( mode,( char* )semName,( char* )shareName,sz ) ;
	(*env).ReleaseByteArrayElements(n1, semName, 0);
	(*env).ReleaseByteArrayElements(n2, shareName, 0);
	return ret ;
}

// NativeShareMemory.destroyShareMemoryĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_destroyShareMemory
  (JNIEnv* env, jobject o) {
	shareSize = -1 ;
	return DestroyShareMemory() ;
}

// NativeShareMemory.writeShareMemoryĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_writeShareMemory
  (JNIEnv* env, jobject o, jint md, jbyteArray in, jint ps, jint of, jint sz) {
	jboolean b ;
	jbyte* input=(*env).GetByteArrayElements(in,&b);
	jint ret = PutShareData( md,( unsigned char* )input,ps,of,sz ) ;
	(*env).ReleaseByteArrayElements(in, input, 0);
	return ret ;
}

// NativeShareMemory.readShareMemoryĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_readShareMemory
  (JNIEnv* env, jobject o, jint md, jbyteArray ot, jint ps, jint of, jint sz) {
	jboolean b ;
	jbyte* output=(*env).GetByteArrayElements(ot,&b);
	jint ret = GetShareData( md,( unsigned char* )output,ps,of,sz ) ;
	(*env).ReleaseByteArrayElements(ot, output, 0);
	return ret ;
}

// NativeShareMemory.sizeShareMemoryĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_sizeShareMemory
  (JNIEnv* env, jobject o) {
	return MaxShreSize() ;
}

// NativeShareMemory.startLockĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_startLock
  (JNIEnv* env, jobject o) {
	LockSharedMemory() ;
	return 0 ;
}

// NativeShareMemory.endLockĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_endLock
  (JNIEnv* env, jobject o) {
	UnLockSharedMemory() ;
	return 0 ;
}

// NativeShareMemory.processIdĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_processId
  (JNIEnv* env, jobject o) {
	return getProcessId() ;
}

// NativeShareMemory.getSequenceIdĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_getSequenceId
  (JNIEnv* env, jobject o, jint md) {
	return ( int )::GetSequenceId( md ) ;
}

// NativeShareMemory.getHeaderĂяo.
JNIEXPORT void JNICALL Java_org_maachang_shm_core_NativeSharedMemory_getHeader
  (JNIEnv* env, jobject o, jint md, jint tp, jintArray seq, jintArray tu, jintArray td, jintArray dLen) {
	SHM_HD hd ;
	GetSmHeader( md,tp,&hd ) ;
	jboolean b ;
	jint* iseq = (*env).GetIntArrayElements(seq,&b) ;
	iseq[ 0 ] = hd.seq ;
	(*env).ReleaseIntArrayElements(seq,iseq,0);

	jint* itd = (*env).GetIntArrayElements(td,&b) ;
	itd[ 0 ] = hd.timeD ;
	(*env).ReleaseIntArrayElements(td,itd,0);

	jint* itu = (*env).GetIntArrayElements(tu,&b) ;
	itu[ 0 ] = hd.timeU ;
	(*env).ReleaseIntArrayElements(tu,itu,0);

	jint* idLen = (*env).GetIntArrayElements(dLen,&b) ;
	idLen[ 0 ] = hd.length ;
	(*env).ReleaseIntArrayElements(dLen,idLen,0);
}

// NativeShareMemory.putHeaderĂяo.
JNIEXPORT void JNICALL Java_org_maachang_shm_core_NativeSharedMemory_putHeader
  (JNIEnv* env, jobject o, jint md, jint tp, jint seq, jint tu, jint td, jint dLen) {
	SHM_HD hd ;
	hd.seq = seq ;
	hd.timeD = td ;
	hd.timeU = tu ;
	hd.length = dLen ;
	PutSmHeader( md,tp,&hd ) ;
}

// NativeShareMemory.getValueĂяo.
JNIEXPORT void JNICALL Java_org_maachang_shm_core_NativeSharedMemory_getValue
  (JNIEnv* env, jobject o, jint md, jint tp, jbyteArray data, jint len) {
	jboolean b ;
	jbyte* dt=(*env).GetByteArrayElements(data,&b);
	GetShmValue( md,tp,( unsigned char* )dt,len ) ;
	(*env).ReleaseByteArrayElements(data, dt, 0);
}

// NativeShareMemory.putValueĂяo.
JNIEXPORT void JNICALL Java_org_maachang_shm_core_NativeSharedMemory_putValue
  (JNIEnv* env, jobject o, jint md, jint tp, jbyteArray data, jint len) {
	jboolean b ;
	jbyte* dt=(*env).GetByteArrayElements(data,&b);
	PutShmValue( md,tp,( unsigned char* )dt,len ) ;
	(*env).ReleaseByteArrayElements(data, dt, 0);
}

// NativeShareMemory.putHdValueĂяo.
JNIEXPORT void JNICALL Java_org_maachang_shm_core_NativeSharedMemory_putHdValue
  (JNIEnv* env, jobject o, jint md, jint tp, jint seq, jint tu, jint td, jint dLen, jbyteArray data, jint len) {
	SHM_HD hd ;
	hd.seq = seq ;
	hd.timeD = td ;
	hd.timeU = tu ;
	hd.length = dLen ;
	jboolean b ;
	jbyte* dt=(*env).GetByteArrayElements(data,&b);
	PutHdShmValue( md,tp,&hd,( unsigned char* )dt,len ) ;
	(*env).ReleaseByteArrayElements(data, dt, 0);
}
