/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.util.ArrayList;
import org.maachang.shm.ShmCommon;
import org.maachang.shm.ShmData;

class ShmTimeoutThread
extends Thread {
    private static final long TIMEOUT = 60000L;
    private volatile boolean stopFlag = false;
    private ArrayList<ShmData> wayList = null;
    private final Object sync = new Object();
    private static final long WAIT = 30L;

    public ShmTimeoutThread() throws Exception {
        this.wayList = new ArrayList();
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(ShmData data) {
        if (data == null) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            data.updateTime();
            this.wayList.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.sync;
        synchronized (object) {
            return this.wayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShmData get(boolean mode, int seqId, long nowTime) {
        Object object = this.sync;
        synchronized (object) {
            int p = ShmCommon.searchList(this.wayList, seqId, nowTime);
            if (p <= -1) {
                return null;
            }
            if (mode) {
                return this.wayList.remove(p);
            }
            return this.wayList.get(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException ie) {
                endFlag = true;
                continue;
            }
            try {
                int len;
                Object object = this.sync;
                synchronized (object) {
                    len = this.wayList.size();
                }
                int i = len - 1;
                while (i >= 0) {
                    ShmData d;
                    Object object2;
                    Thread.sleep(30L);
                    try {
                        object2 = this.sync;
                        synchronized (object2) {
                            d = this.wayList.get(i);
                        }
                    }
                    catch (Exception ee) {
                        d = null;
                    }
                    if (d != null && d.getLastAccessTime() + 60000L < System.currentTimeMillis()) {
                        try {
                            object2 = this.sync;
                            synchronized (object2) {
                                this.wayList.remove(i);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    --i;
                }
            }
            catch (InterruptedException ie) {
                endFlag = true;
            }
            catch (OutOfMemoryError ie) {
            }
            catch (Exception ie) {
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

