/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.util.ArrayList;
import org.maachang.shm.BaseSharedIO;
import org.maachang.shm.ShmCommon;
import org.maachang.shm.ShmData;
import org.maachang.shm.ShmHeader;
import org.maachang.shm.ShmTimeoutThread;

class ShmServerThread
extends Thread {
    private static final long SEND_TIMEOUT = 5000L;
    private volatile boolean stopFlag = true;
    private BaseSharedIO base = null;
    private ShmTimeoutThread wayList = null;
    private ArrayList<ShmData> receiveList = null;
    private ArrayList<ShmData> sendList = null;
    private final Object sync = new Object();
    private static final long WAIT = 5L;

    public ShmServerThread(BaseSharedIO base) throws Exception {
        if (base == null || !base.isMode()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.base = base;
        this.receiveList = new ArrayList();
        this.wayList = new ShmTimeoutThread();
        this.sendList = new ArrayList();
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendData(ShmData data) {
        if (data == null || data.getDataLength() <= 0) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            this.sendList.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShmData getRecvData() {
        Object object = this.sync;
        synchronized (object) {
            if (this.receiveList.size() > 0) {
                return this.receiveList.remove(0);
            }
        }
        return null;
    }

    public void run() {
        boolean endFlag = false;
        ShmData sendData = null;
        long sendDataTimeout = -1L;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ie) {
                endFlag = true;
                continue;
            }
            try {
                this.executionRecv();
                if (sendData == null && (sendData = this.getSendData()) != null) {
                    sendDataTimeout = System.currentTimeMillis();
                }
                if (sendData == null) continue;
                Thread.sleep(5L);
                if ((sendDataTimeout = this.executionSend(sendData, sendDataTimeout)) != -1L) continue;
                sendData = null;
            }
            catch (InterruptedException ie) {
                endFlag = true;
            }
            catch (OutOfMemoryError ie) {
            }
            catch (Exception ie) {
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShmData getSendData() {
        Object object = this.sync;
        synchronized (object) {
            if (this.sendList.size() <= 0) {
                return null;
            }
            return this.sendList.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executionRecv() throws Exception {
        int length;
        ShmHeader hd = this.base.getReadHeader(true);
        if (hd.getSequenceId() == 0) {
            return;
        }
        ShmData recvData = this.wayList.get(true, hd.getSequenceId(), hd.getNowTime());
        if (recvData == null) {
            recvData = new ShmData(hd.getSequenceId(), hd.getNowTime());
        }
        if ((length = hd.getDataLength()) == Integer.MAX_VALUE) {
            this.wayList.addData(recvData);
            length = ShmCommon.IO_LENGTH;
            byte[] b = this.base.getReadData(true, length);
            recvData.addData(b, length);
        } else if (length > 0) {
            byte[] b = this.base.getReadData(true, length);
            recvData.addData(b, length);
            Object object = this.sync;
            synchronized (object) {
                this.receiveList.add(recvData);
            }
        } else {
            return;
        }
        hd.setSequenceId(0);
        this.base.setRead(hd, null, -1);
    }

    private long executionSend(ShmData sendData, long timeout) throws Exception {
        ShmHeader hd = this.base.getWriteHeader(true);
        if (hd.getSequenceId() == 0) {
            hd.create(sendData);
            int offset = this.base.setWrite(hd, sendData.getData(), sendData.getOffset());
            sendData.setOffset(offset);
            timeout = offset > 0 ? System.currentTimeMillis() : -1L;
        } else if (timeout + 5000L <= System.currentTimeMillis()) {
            if (sendData.equals(hd.getSequenceId(), hd.getNowTime())) {
                timeout = -1L;
            }
            hd.setSequenceId(0);
            this.base.setWrite(hd, null, -1);
            timeout = System.currentTimeMillis();
        }
        return timeout;
    }
}

