/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import org.maachang.shm.ArrayBinary;
import org.maachang.shm.ShmCommon;
import org.maachang.shm.ShmHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShmData
implements Comparable<ShmData> {
    public static final int MODE_READ = 1;
    public static final int MODE_WRITE = 2;
    private int sequenceId = -1;
    private long nowTime = -1L;
    private int hashCode = -1;
    private ArrayBinary data = null;
    private int offset = 0;
    private int outDataOffset = -1;
    private long lastAccess;

    public ShmData(int sequenceId) {
        this.sequenceId = sequenceId;
        this.nowTime = System.currentTimeMillis();
        this.hashCode = ShmCommon.getHashCode(this.sequenceId, this.nowTime);
        this.lastAccess = System.currentTimeMillis();
    }

    public ShmData(int sequenceId, long nowTime) {
        this.sequenceId = sequenceId;
        this.nowTime = nowTime;
        this.hashCode = ShmCommon.getHashCode(this.sequenceId, this.nowTime);
        this.lastAccess = System.currentTimeMillis();
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public long getNowTime() {
        return this.nowTime;
    }

    public synchronized ArrayBinary getArrayBinary() {
        return this.data;
    }

    public synchronized void clearArrayBinary() {
        if (this.data == null) {
            this.data = new ArrayBinary();
        } else {
            this.data.clear();
        }
        this.offset = 0;
        this.outDataOffset = -1;
    }

    public synchronized void addData(byte[] bin, int length) {
        if (this.data == null) {
            this.data = new ArrayBinary();
        }
        this.data.write(bin, length);
    }

    public synchronized void setData(byte[] data) {
        this.data = new ArrayBinary(data);
        this.offset = 0;
        this.outDataOffset = -1;
    }

    public synchronized byte[] getData() {
        if (this.data != null) {
            return this.data.getBinary();
        }
        return null;
    }

    public synchronized int getDataLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getLength();
    }

    public synchronized int getOffset() {
        if (this.offset <= 0) {
            this.offset = 0;
        }
        return this.offset;
    }

    public synchronized void setOffset(int offset) {
        this.offset = offset;
        this.outDataOffset = -1;
    }

    public synchronized void cache(int offset) {
        this.outDataOffset = offset;
    }

    public synchronized boolean isCache() {
        return this.offset == this.outDataOffset;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(ShmData o) {
        return o.sequenceId - this.sequenceId;
    }

    public boolean equals(Object o) {
        if (o instanceof ShmData) {
            ShmData x = (ShmData)o;
            return x.sequenceId == this.sequenceId && x.nowTime == this.nowTime;
        }
        return false;
    }

    public boolean equals(int sequenceId, long nowTime) {
        return this.sequenceId == sequenceId && this.nowTime == nowTime;
    }

    public boolean equals(ShmHeader header) {
        return this.sequenceId == header.getSequenceId() && this.nowTime == header.getNowTime();
    }

    public long getLastAccessTime() {
        return this.lastAccess;
    }

    public void updateTime() {
        this.lastAccess = System.currentTimeMillis();
    }
}

