/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import org.maachang.shm.ShmCommon;
import org.maachang.shm.ShmHeader;
import org.maachang.shm.core.CoreShm;

class BaseSharedIO {
    private boolean mode = false;
    private CoreShm shm = null;
    private byte[] wData = new byte[ShmCommon.IO_LENGTH];
    private byte[] rData = new byte[ShmCommon.IO_LENGTH];

    public BaseSharedIO(boolean mode, String semName, String shmName) throws Exception {
        this.mode = mode;
        this.shm = new CoreShm(mode, semName, shmName, ShmCommon.SHARED_LENGTH);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.shm != null) {
            try {
                this.shm.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.wData = null;
        this.rData = null;
        this.shm = null;
    }

    public CoreShm getCoreShm() {
        return this.shm;
    }

    public boolean isMode() {
        return this.mode;
    }

    public void lock() throws Exception {
        this.shm.lock();
    }

    public void unLock() throws Exception {
        this.shm.unLock();
    }

    public int getSequenceId() throws Exception {
        return ShmCommon.getSequenceId(this.shm);
    }

    public ShmHeader getWriteHeader(boolean sync) throws Exception {
        return ShmCommon.getHeader(!this.mode, sync, this.shm);
    }

    public ShmHeader getReadHeader(boolean sync) throws Exception {
        return ShmCommon.getHeader(this.mode, sync, this.shm);
    }

    public byte[] getWriteData(boolean sync, int length) throws Exception {
        ShmCommon.getData(!this.mode, sync, this.wData, this.shm, length);
        return this.wData;
    }

    public byte[] getReadData(boolean sync, int length) throws Exception {
        ShmCommon.getData(this.mode, sync, this.rData, this.shm, length);
        return this.rData;
    }

    public int setWrite(ShmHeader header, byte[] data, int offset) throws Exception {
        if (data == null) {
            header.setDataLength(0);
            ShmCommon.setHeader(!this.mode, true, this.shm, header.getSequenceId(), header.getNowTime(), header.getDataLength());
            return -1;
        }
        if (offset <= 0) {
            offset = 0;
        }
        int ret = -1;
        int dataLen = data.length - offset;
        if (dataLen > ShmCommon.IO_LENGTH) {
            dataLen = ShmCommon.IO_LENGTH;
            header.setDataLength(Integer.MAX_VALUE);
            ret = offset + ShmCommon.IO_LENGTH;
        } else {
            header.setDataLength(dataLen);
            ret = -1;
        }
        int len = header.getDataLength();
        if (len >= ShmCommon.IO_LENGTH) {
            len = ShmCommon.IO_LENGTH;
        }
        ShmCommon.outputHeaderData(!this.mode, true, this.shm, data, len, header.getSequenceId(), header.getNowTime(), header.getDataLength());
        return ret;
    }

    public int setRead(ShmHeader header, byte[] data, int offset) throws Exception {
        if (data == null) {
            header.setDataLength(0);
            ShmCommon.setHeader(this.mode, true, this.shm, header.getSequenceId(), header.getNowTime(), header.getDataLength());
            return -1;
        }
        if (offset <= 0) {
            offset = 0;
        }
        int ret = -1;
        int dataLen = data.length - offset;
        if (dataLen > ShmCommon.IO_LENGTH) {
            dataLen = ShmCommon.IO_LENGTH;
            header.setDataLength(Integer.MAX_VALUE);
            ret = offset + ShmCommon.IO_LENGTH;
        } else {
            header.setDataLength(dataLen);
            ret = -1;
        }
        int len = header.getDataLength();
        if (len >= ShmCommon.IO_LENGTH) {
            len = ShmCommon.IO_LENGTH;
        }
        ShmCommon.outputHeaderData(this.mode, true, this.shm, data, len, header.getSequenceId(), header.getNowTime(), header.getDataLength());
        return ret;
    }
}

