/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.maachang.shm.core.Os;

class NativeSharedMemory {
    private static boolean initFlag = false;
    private static final boolean LIB_COPY = true;

    static {
        String lib = null;
        switch (Os.getInstance().getOS()) {
            case 33: {
                lib = "WinShareMemory.dll";
                System.load(NativeSharedMemory.targetDynamincLib(true, lib));
                initFlag = true;
                break;
            }
            case 1: {
                lib = "libshm.so";
                System.load(NativeSharedMemory.targetDynamincLib(true, lib));
                initFlag = true;
                break;
            }
            default: {
                initFlag = false;
            }
        }
    }

    private static final String targetDynamincLib(boolean mode, String lib) {
        String sp = System.getProperty("file.separator");
        File targetDir = null;
        targetDir = System.getProperty("org.maachang.share.dir") == null ? new File(System.getProperty("user.home") + sp + ".lib_work") : new File(System.getProperty("org.maachang.share.dir"));
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        File outFile = new File(targetDir, lib);
        if (mode) {
            BufferedInputStream is = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/maachang/shm/core/" + lib));
            if (NativeSharedMemory.isLibFile(outFile, is)) {
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
                    try {
                        try {
                            int n;
                            while ((n = ((InputStream)is).read()) > -1) {
                                ((OutputStream)os).write(n);
                            }
                            ((OutputStream)os).flush();
                        }
                        finally {
                            ((InputStream)is).close();
                            is = null;
                        }
                    }
                    finally {
                        ((OutputStream)os).close();
                        os = null;
                    }
                }
                catch (Exception e) {
                    outFile = null;
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                is = null;
            }
        }
        if (outFile != null) {
            return outFile.getAbsolutePath();
        }
        return null;
    }

    private static final boolean isLibFile(File f, InputStream in) {
        boolean ret = false;
        try {
            int len;
            ret = !f.exists() ? true : (len = (int)f.length()) <= 0 || len != in.available();
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }

    private NativeSharedMemory() {
    }

    public NativeSharedMemory(int mode, String semName, String shareName, int size) throws Exception {
        switch (Os.getInstance().getOS()) {
            case 1: 
            case 33: {
                break;
            }
            default: {
                throw new IOException("ShareMemory\u306f\u3001\u73fe\u5728\u52d5\u4f5c\u4e2d\u306eOS\u3067\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
        }
        if (!initFlag) {
            throw new IOException("ShareMemory\u306f\u3001\u73fe\u5728\u52d5\u4f5c\u4e2d\u306eOS\u3067\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        if (semName == null || (semName = semName.trim()).length() <= 0 || shareName == null || (shareName = shareName.trim()).length() <= 0 || size <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.initShareMemory(mode, this.convertBinary(semName), this.convertBinary(shareName), size) <= -1) {
            throw new IOException("\u521d\u671f\u5316\u51e6\u7406\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.destroyShareMemory();
    }

    public synchronized void read(int mode, byte[] output, int pos, int offset, int length) throws Exception {
        if (this.readShareMemory(mode, output, pos, offset, length) <= -1) {
            throw new IOException("\u8aad\u307f\u8fbc\u307f\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }

    public synchronized void write(int mode, byte[] input, int pos, int offset, int length) throws Exception {
        if (this.writeShareMemory(mode, input, pos, offset, length) <= -1) {
            throw new IOException("\u66f8\u304d\u8fbc\u307f\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }

    public synchronized void semLock() throws Exception {
        if (this.startLock() <= -1) {
            throw new IOException("\u30ed\u30c3\u30af\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public synchronized void semUnLock() throws Exception {
        if (this.endLock() <= -1) {
            throw new IOException("\u30ed\u30c3\u30af\u89e3\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public synchronized int size() {
        return this.sizeShareMemory();
    }

    public synchronized int getProcessId() {
        return this.processId();
    }

    public int getExSequenceId(int md) {
        return this.getSequenceId(md);
    }

    public void getExHeader(int md, int tp, int[] seqId, int[] tu, int[] td, int[] datLen) {
        this.getHeader(md, tp, seqId, tu, td, datLen);
    }

    public void putExHeader(int md, int tp, int seqId, int tu, int td, int datLen) {
        this.putHeader(md, tp, seqId, tu, td, datLen);
    }

    public void getExValue(int md, int tp, byte[] data, int len) {
        this.getValue(md, tp, data, len);
    }

    public void putExValue(int md, int tp, byte[] data, int len) {
        this.putValue(md, tp, data, len);
    }

    public void putExHdValue(int md, int tp, int seqId, int tu, int td, int datLen, byte[] data, int len) {
        this.putHdValue(md, tp, seqId, tu, td, datLen, data, len);
    }

    private byte[] convertBinary(String string) {
        byte[] b = string.getBytes();
        int len = b.length;
        byte[] ret = new byte[len + 1];
        System.arraycopy(b, 0, ret, 0, len);
        b = null;
        ret[len] = 0;
        return ret;
    }

    protected native int initShareMemory(int var1, byte[] var2, byte[] var3, int var4);

    protected native int destroyShareMemory();

    protected native int writeShareMemory(int var1, byte[] var2, int var3, int var4, int var5);

    protected native int readShareMemory(int var1, byte[] var2, int var3, int var4, int var5);

    protected native int sizeShareMemory();

    protected native int startLock();

    protected native int endLock();

    protected native int processId();

    protected native int getSequenceId(int var1);

    protected native void getHeader(int var1, int var2, int[] var3, int[] var4, int[] var5, int[] var6);

    protected native void putHeader(int var1, int var2, int var3, int var4, int var5, int var6);

    protected native void getValue(int var1, int var2, byte[] var3, int var4);

    protected native void putValue(int var1, int var2, byte[] var3, int var4);

    protected native void putHdValue(int var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int var8);
}

