/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.io.IOException;
import org.maachang.shm.BaseSharedIO;
import org.maachang.shm.ShmData;
import org.maachang.shm.ShmIoData;
import org.maachang.shm.ShmServerThread;
import org.maachang.shm.core.CoreShm;

public class ShmServer {
    private BaseSharedIO base = null;
    private ShmServerThread thread = null;
    private int timeout = -1;

    private ShmServer() {
    }

    public ShmServer(String name, int timeout) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        name = name.trim();
        this.base = new BaseSharedIO(true, name, name);
        this.thread = new ShmServerThread(this.base);
        this.timeout = timeout;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.thread != null) {
            this.thread.destroy();
        }
        this.thread = null;
        if (this.base != null) {
            this.base.destroy();
        }
        this.base = null;
    }

    public ShmIoData read() throws Exception {
        return this.read(this.timeout);
    }

    public ShmIoData read(long timeout) throws Exception {
        ShmData d;
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        long time = System.currentTimeMillis();
        while (true) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            d = this.thread.getRecvData();
            if (d != null) break;
            if (timeout > 0L && time + timeout <= System.currentTimeMillis()) {
                throw new InterruptedException("timeout");
            }
            Thread.sleep(15L);
        }
        return new ShmIoData(d.getSequenceId(), d.getNowTime(), d.getData());
    }

    public void write(ShmIoData info) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (info == null || info.getData() == null || info.getData().length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ShmData data = new ShmData(info.getSequenceId(), info.getNowTime());
        data.setData(info.getData());
        this.thread.setSendData(data);
    }

    public String getName() {
        if (!this.isUse()) {
            return null;
        }
        return this.base.getCoreShm().getShareName();
    }

    public boolean isUse() {
        return this.base != null && this.base.getCoreShm() != null && this.base.getCoreShm().isUse() && this.thread != null && !this.thread.isStop();
    }

    public CoreShm getCoreShm() {
        if (!this.isUse()) {
            return null;
        }
        return this.base.getCoreShm();
    }
}

