/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.util.ArrayList;
import org.maachang.shm.ShmData;
import org.maachang.shm.ShmHeader;
import org.maachang.shm.core.CoreShm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShmCommon {
    public static final int IO_LENGTH;
    public static final int SEQUENCE_ID = 4;
    public static final int START_TIME = 8;
    public static final int NOW_LENGTH = 4;
    public static final int SHARED_LENGTH;
    public static final int HHEADER_LENGTH = 16;
    public static final int NEXT_LENGTH = Integer.MAX_VALUE;
    public static final int FREE_DATA = 0;
    public static final long MON_SLEEP = 5L;

    static {
        if (System.getProperty("org.maachang.shm.length") != null) {
            int x = -1;
            try {
                x = Integer.parseInt(System.getProperty("org.maachang.shm.length"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (x <= -1 && x >= Integer.MAX_VALUE) {
                x = 8192;
            }
            IO_LENGTH = x;
        } else {
            IO_LENGTH = 8192;
        }
        SHARED_LENGTH = 4 + (16 + IO_LENGTH) * 2;
    }

    ShmCommon() {
    }

    public static final int getSequenceId(CoreShm shm) throws Exception {
        return shm.getSequenceIdEnhancing(true);
    }

    public static final void setHeader(boolean mode, boolean sync, CoreShm shm, int seqId, long time, int dataLen) throws Exception {
        shm.putHeaderEnhancing(sync, mode, seqId, time, dataLen);
    }

    public static final ShmHeader getHeader(boolean mode, boolean sync, CoreShm shm) throws Exception {
        int[] seqId = new int[1];
        long[] time = new long[1];
        int[] datLen = new int[1];
        shm.getHeaderEnhancing(sync, mode, seqId, time, datLen);
        ShmHeader ret = new ShmHeader(seqId[0], time[0]);
        ret.setDataLength(datLen[0]);
        return ret;
    }

    public static final void getData(boolean mode, boolean sync, byte[] bin, CoreShm shm, int length) throws Exception {
        shm.getValueEnhancing(sync, mode, bin, length);
    }

    public static final void outputHeaderData(boolean mode, boolean sync, CoreShm shm, byte[] bin, int length, int seqId, long time, int dataLen) throws Exception {
        shm.putHdValueEnhancing(sync, mode, seqId, time, dataLen, bin, length);
    }

    public static final int getHashCode(int seqId, long nowTime) {
        byte[] b = new byte[]{(byte)(seqId & 0xFF), (byte)((seqId & 0xFF00) >> 8), (byte)((seqId & 0xFF0000) >> 16), (byte)((seqId & 0xFF000000) >> 24), (byte)(nowTime & 0xFFL), (byte)((nowTime & 0xFF00L) >> 8), (byte)((nowTime & 0xFF0000L) >> 16), (byte)((nowTime & 0xFF000000L) >> 24), (byte)((nowTime & 0xFF00000000L) >> 32), (byte)((nowTime & 0xFF0000000000L) >> 40), (byte)((nowTime & 0xFF000000000000L) >> 48), (byte)((nowTime & 0xFF00000000000000L) >> 56)};
        int len = b.length;
        long ret = 2166136261L;
        int i = 0;
        while (i < len) {
            ret ^= (long)b[i];
            ret += (ret << 1) + (ret << 4) + (ret << 7) + (ret << 8) + (ret << 24);
            ++i;
        }
        return (int)(ret & 0xFFFFFFFFL);
    }

    public static final int searchList(ArrayList<ShmData> list, int seqId, long nowTime) {
        int len = list.size();
        int i = 0;
        while (i < len) {
            ShmData data = list.get(i);
            if (data.getSequenceId() == seqId && data.getNowTime() == nowTime) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

