/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.util.ArrayList;
import org.maachang.shm.BaseSharedIO;
import org.maachang.shm.ShmCommon;
import org.maachang.shm.ShmData;
import org.maachang.shm.ShmHeader;
import org.maachang.shm.ShmTimeoutThread;

class ShmClientThread
extends Thread {
    private volatile boolean stopFlag = true;
    private BaseSharedIO base = null;
    private ArrayList<ShmData> sendList = null;
    private ShmTimeoutThread wayList = null;
    private ArrayList<ShmData> receiveList = null;
    private final Object sync = new Object();
    private static final long WAIT = 5L;

    public ShmClientThread(BaseSharedIO base) throws Exception {
        if (base == null || base.isMode()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.base = base;
        this.sendList = new ArrayList();
        this.wayList = new ShmTimeoutThread();
        this.receiveList = new ArrayList();
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    public int getSequenceId() throws Exception {
        return this.base.getSequenceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendData(ShmData data) {
        if (data == null || data.getDataLength() <= 0) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            this.sendList.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShmData getReceiveData(int seqId, long nowTime) {
        Object object = this.sync;
        synchronized (object) {
            int p = ShmCommon.searchList(this.receiveList, seqId, nowTime);
            if (p <= -1) {
                return null;
            }
            return this.receiveList.remove(p);
        }
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        ShmData sendData = null;
        while (!endFlag && !this.isStop()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ie) {
                endFlag = true;
                continue;
            }
            try {
                if (sendData == null) {
                    sendData = this.getSendData();
                }
                if (this.executionSend(sendData)) {
                    sendData.clearArrayBinary();
                    this.wayList.addData(sendData);
                    sendData = null;
                }
                if (this.wayList.size() <= 0) continue;
                Thread.sleep(5L);
                this.executionRecv();
            }
            catch (InterruptedException ie) {
                endFlag = true;
            }
            catch (OutOfMemoryError ie) {
            }
            catch (Exception ie) {
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.wayList.destroy();
        this.sendList = null;
        this.wayList = null;
        this.receiveList = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShmData getSendData() {
        Object object = this.sync;
        synchronized (object) {
            if (this.sendList.size() <= 0) {
                return null;
            }
            return this.sendList.remove(0);
        }
    }

    private boolean executionSend(ShmData sendData) throws Exception {
        if (sendData == null) {
            return false;
        }
        try {
            boolean ret = false;
            this.base.lock();
            ShmHeader hd = this.base.getWriteHeader(false);
            if (hd.getSequenceId() == 0) {
                hd.create(sendData);
                int offset = this.base.setWrite(hd, sendData.getData(), sendData.getOffset());
                sendData.setOffset(offset);
                if (sendData.getOffset() <= 0) {
                    ret = true;
                }
                sendData.cache(-1);
            }
            this.base.unLock();
            return ret;
        }
        catch (Exception e) {
            try {
                this.base.unLock();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executionRecv() throws Exception {
        ShmHeader hd = this.base.getReadHeader(true);
        if (hd.getSequenceId() == 0) {
            return false;
        }
        ShmData wayData = this.wayList.get(true, hd.getSequenceId(), hd.getNowTime());
        if (wayData != null) {
            int length = hd.getDataLength();
            if (length == Integer.MAX_VALUE) {
                wayData.updateTime();
                this.wayList.addData(wayData);
                length = ShmCommon.IO_LENGTH;
                byte[] b = this.base.getReadData(true, length);
                wayData.addData(b, length);
            } else if (length > 0) {
                byte[] b = this.base.getReadData(true, length);
                wayData.addData(b, length);
                Object object = this.sync;
                synchronized (object) {
                    this.receiveList.add(wayData);
                }
            } else {
                return false;
            }
            hd.setSequenceId(0);
            this.base.setRead(hd, null, -1);
            return true;
        }
        return false;
    }
}

