/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.io.IOException;
import org.maachang.shm.BaseSharedIO;
import org.maachang.shm.ShmClientThread;
import org.maachang.shm.ShmData;
import org.maachang.shm.core.CoreShm;

public class ShmClient {
    private BaseSharedIO base = null;
    private ShmClientThread thread = null;
    private int timeout = -1;

    private ShmClient() {
    }

    public ShmClient(String name, int timeout) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        name = name.trim();
        this.base = new BaseSharedIO(false, name, name);
        this.thread = new ShmClientThread(this.base);
        this.timeout = timeout;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.thread != null) {
            this.thread.destroy();
        }
        this.thread = null;
        if (this.base != null) {
            this.base.destroy();
        }
        this.base = null;
    }

    public byte[] io(byte[] sendData) throws Exception {
        return this.io(sendData, this.timeout);
    }

    public byte[] io(byte[] sendData, int timeout) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (sendData == null || sendData.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        long time = System.currentTimeMillis();
        int seqId = this.thread.getSequenceId();
        ShmData d = new ShmData(seqId);
        long nowTime = d.getNowTime();
        d.setData(sendData);
        this.thread.setSendData(d);
        while (true) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            d = this.thread.getReceiveData(seqId, nowTime);
            if (d != null) break;
            if (timeout > 0 && time + (long)timeout <= System.currentTimeMillis()) {
                throw new InterruptedException("timeout");
            }
            Thread.sleep(15L);
        }
        return d.getData();
    }

    public String getName() {
        if (!this.isUse()) {
            return null;
        }
        return this.base.getCoreShm().getShareName();
    }

    public boolean isUse() {
        return this.base != null && this.base.getCoreShm() != null && this.base.getCoreShm().isUse() && this.thread != null && !this.thread.isStop();
    }

    public CoreShm getCoreShm() {
        if (!this.isUse()) {
            return null;
        }
        return this.base.getCoreShm();
    }
}

