/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.io.IOException;

class OutputArrayBuffer {
    private static final int BUFFER = 4096;
    private byte[] binary = null;
    private int length = 0;

    protected void finalize() throws Exception {
        this.clear();
    }

    public void clear() {
        this.binary = null;
        this.length = 0;
    }

    public void write(int b) throws IOException {
        if (this.binary == null) {
            this.binary = new byte[4096];
        } else if (this.binary.length <= this.length) {
            byte[] t = this.binary;
            int iLen = t.length * 2;
            this.binary = new byte[iLen];
            System.arraycopy(t, 0, this.binary, 0, t.length);
            byte[] byArray = null;
        }
        this.binary[this.length] = (byte)(b & 0xFF);
        ++this.length;
    }

    public byte[] getBinary() {
        if (this.binary == null) {
            return null;
        }
        byte[] ret = new byte[this.length];
        System.arraycopy(this.binary, 0, ret, 0, this.length);
        return ret;
    }

    public int getLength() {
        return this.length;
    }
}

